/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.eventloop.AsyncTcpSocket;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.NioChannelEventHandler;
import io.datakernel.eventloop.ScheduledRunnable;
import io.datakernel.exception.AsyncTimeoutException;
import io.datakernel.jmx.EventStats;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.ValueStats;
import io.datakernel.net.SocketSettings;
import io.datakernel.util.MemSize;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;

public final class AsyncTcpSocketImpl
implements AsyncTcpSocket,
NioChannelEventHandler {
    public static final MemSize DEFAULT_READ_BUF_SIZE = MemSize.kilobytes((long)16L);
    public static final int OP_POSTPONED = 128;
    public static final AsyncTimeoutException TIMEOUT_EXCEPTION = new AsyncTimeoutException("timed out");
    public static final int NO_TIMEOUT = -1;
    private static final MemSize MAX_MERGE_SIZE = MemSize.kilobytes((long)16L);
    private static final AtomicInteger connectionCount = new AtomicInteger(0);
    private final Eventloop eventloop;
    private final SocketChannel channel;
    private final ArrayDeque<ByteBuf> writeQueue = new ArrayDeque();
    private boolean writeEndOfStream;
    private AsyncTcpSocket.EventHandler socketEventHandler;
    private SelectionKey key;
    private int ops = 0;
    private long readTimestamp = 0L;
    private long writeTimestamp = 0L;
    private long readTimeout = -1L;
    private long writeTimeout = -1L;
    protected MemSize readMaxSize = DEFAULT_READ_BUF_SIZE;
    protected MemSize writeMaxSize = MAX_MERGE_SIZE;
    private ScheduledRunnable checkReadTimeout;
    private ScheduledRunnable checkWriteTimeout;
    private Inspector inspector;

    public static AsyncTcpSocketImpl wrapChannel(Eventloop eventloop, SocketChannel socketChannel, SocketSettings socketSettings) {
        try {
            socketSettings.applySettings(socketChannel);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to apply socketSettings", e);
        }
        AsyncTcpSocketImpl asyncTcpSocket = new AsyncTcpSocketImpl(eventloop, socketChannel);
        if (socketSettings.hasImplReadTimeout()) {
            asyncTcpSocket.readTimeout = socketSettings.getImplReadTimeout().toMillis();
        }
        if (socketSettings.hasImplWriteTimeout()) {
            asyncTcpSocket.writeTimeout = socketSettings.getImplWriteTimeout().toMillis();
        }
        if (socketSettings.hasImplReadSize()) {
            asyncTcpSocket.readMaxSize = socketSettings.getImplReadSize();
        }
        if (socketSettings.hasImplWriteSize()) {
            asyncTcpSocket.writeMaxSize = socketSettings.getImplWriteSize();
        }
        return asyncTcpSocket;
    }

    public static AsyncTcpSocketImpl wrapChannel(Eventloop eventloop, SocketChannel socketChannel) {
        return new AsyncTcpSocketImpl(eventloop, socketChannel);
    }

    public AsyncTcpSocketImpl withInspector(Inspector inspector) {
        this.inspector = inspector;
        return this;
    }

    private AsyncTcpSocketImpl(Eventloop eventloop, SocketChannel socketChannel) {
        this.eventloop = (Eventloop)Preconditions.checkNotNull((Object)eventloop);
        this.channel = (SocketChannel)Preconditions.checkNotNull((Object)socketChannel);
    }

    @Override
    public void setEventHandler(AsyncTcpSocket.EventHandler eventHandler) {
        this.socketEventHandler = eventHandler;
    }

    public static int getConnectionCount() {
        return connectionCount.get();
    }

    public final void register() {
        this.socketEventHandler.onRegistered();
        try {
            this.key = this.channel.register(this.eventloop.ensureSelector(), this.ops, this);
            connectionCount.incrementAndGet();
        }
        catch (IOException e) {
            this.eventloop.post(() -> {
                this.eventloop.closeChannel(this.channel);
                this.socketEventHandler.onClosedWithError(e);
            });
        }
        if ((this.ops & 1) != 0) {
            this.onReadReady();
        }
    }

    void scheduleReadTimeOut() {
        if (this.checkReadTimeout == null) {
            this.checkReadTimeout = this.eventloop.delayBackground(this.readTimeout, () -> {
                if (this.inspector != null) {
                    this.inspector.onReadTimeout();
                }
                this.checkReadTimeout = null;
                this.closeWithError((Exception)TIMEOUT_EXCEPTION, false);
            });
        }
    }

    void scheduleWriteTimeOut() {
        if (this.checkWriteTimeout == null) {
            this.checkWriteTimeout = this.eventloop.delayBackground(this.writeTimeout, () -> {
                if (this.inspector != null) {
                    this.inspector.onWriteTimeout();
                }
                this.checkWriteTimeout = null;
                this.closeWithError((Exception)TIMEOUT_EXCEPTION, false);
            });
        }
    }

    private void interests(int newOps) {
        if (this.ops != newOps) {
            this.ops = newOps;
            if ((this.ops & 0x80) == 0 && this.key != null) {
                this.key.interestOps(this.ops);
            }
        }
    }

    private void readInterest(boolean readInterest) {
        this.interests(readInterest ? this.ops | 1 : this.ops & 0xFFFFFFFE);
    }

    private void writeInterest(boolean writeInterest) {
        this.interests(writeInterest ? this.ops | 4 : this.ops & 0xFFFFFFFB);
    }

    @Override
    public void read() {
        if (this.readTimeout != -1L) {
            this.scheduleReadTimeOut();
        }
        this.readInterest(true);
        if (this.readTimestamp == 0L) {
            this.readTimestamp = this.eventloop.currentTimeMillis();
            assert (this.readTimestamp != 0L);
        }
    }

    @Override
    public void onReadReady() {
        this.readTimestamp = 0L;
        int oldOps = this.ops;
        this.ops |= 0x80;
        this.readInterest(false);
        int bytesRead = this.doRead();
        if (bytesRead != 0) {
            int newOps = this.ops & 0xFFFFFF7F;
            this.ops = oldOps;
            this.interests(newOps);
        } else {
            this.ops = oldOps;
        }
    }

    private int doRead() {
        int numRead;
        ByteBuf buf = ByteBufPool.allocate((MemSize)this.readMaxSize);
        ByteBuffer buffer = buf.toWriteByteBuffer();
        try {
            numRead = this.channel.read(buffer);
            buf.ofWriteByteBuffer(buffer);
        }
        catch (IOException e) {
            buf.recycle();
            if (this.inspector != null) {
                this.inspector.onReadError(e);
            }
            this.closeWithError(e, false);
            return -1;
        }
        if (numRead == 0) {
            if (this.inspector != null) {
                this.inspector.onRead(buf);
            }
            buf.recycle();
            return numRead;
        }
        if (this.checkReadTimeout != null) {
            this.checkReadTimeout.cancel();
            this.checkReadTimeout = null;
        }
        if (numRead == -1) {
            buf.recycle();
            if (this.inspector != null) {
                this.inspector.onReadEndOfStream();
            }
            this.socketEventHandler.onReadEndOfStream();
            return numRead;
        }
        if (this.inspector != null) {
            this.inspector.onRead(buf);
        }
        this.socketEventHandler.onRead(buf);
        return numRead;
    }

    @Override
    public void write(ByteBuf buf) {
        assert (this.eventloop.inEventloopThread());
        if (this.writeTimeout != -1L) {
            this.scheduleWriteTimeOut();
        }
        this.writeQueue.add(buf);
        this.postWriteRunnable();
    }

    @Override
    public void writeEndOfStream() {
        assert (this.eventloop.inEventloopThread());
        if (this.writeEndOfStream) {
            return;
        }
        this.writeEndOfStream = true;
        this.postWriteRunnable();
    }

    @Override
    public void onWriteReady() {
        this.writeTimestamp = 0L;
        try {
            this.doWrite();
        }
        catch (IOException e) {
            this.closeWithError(e, false);
        }
    }

    private void doWrite() throws IOException {
        ByteBuf bufToSend;
        int writeMaxSize = this.writeMaxSize.toInt();
        while ((bufToSend = this.writeQueue.poll()) != null) {
            ByteBuf nextBuf;
            while ((nextBuf = this.writeQueue.peek()) != null) {
                int bytesToCopy = nextBuf.readRemaining();
                if (bufToSend.readPosition() + bufToSend.readRemaining() + bytesToCopy > bufToSend.limit()) {
                    bytesToCopy += bufToSend.readRemaining();
                }
                if (bytesToCopy >= writeMaxSize) break;
                bufToSend = ByteBufPool.append((ByteBuf)bufToSend, (ByteBuf)nextBuf);
                this.writeQueue.poll();
            }
            ByteBuffer bufferToSend = bufToSend.toReadByteBuffer();
            try {
                this.channel.write(bufferToSend);
            }
            catch (IOException e) {
                if (this.inspector != null) {
                    this.inspector.onWriteError(e);
                }
                bufToSend.recycle();
                throw e;
            }
            if (this.inspector != null) {
                this.inspector.onWrite(bufToSend, bufferToSend.position() - bufToSend.readPosition());
            }
            bufToSend.ofReadByteBuffer(bufferToSend);
            if (bufToSend.canRead()) {
                this.writeQueue.addFirst(bufToSend);
                break;
            }
            bufToSend.recycle();
        }
        if (this.writeQueue.isEmpty()) {
            if (this.checkWriteTimeout != null) {
                this.checkWriteTimeout.cancel();
                this.checkWriteTimeout = null;
            }
            if (this.writeEndOfStream) {
                this.channel.shutdownOutput();
            }
            this.writeInterest(false);
            this.socketEventHandler.onWrite();
        } else {
            this.writeInterest(true);
        }
    }

    @Override
    public void close() {
        assert (this.eventloop.inEventloopThread());
        if (this.key == null) {
            return;
        }
        this.eventloop.closeChannel(this.key);
        this.key = null;
        connectionCount.decrementAndGet();
        for (ByteBuf buf : this.writeQueue) {
            buf.recycle();
        }
        this.writeQueue.clear();
        if (this.checkWriteTimeout != null) {
            this.checkWriteTimeout.cancel();
            this.checkWriteTimeout = null;
        }
        if (this.checkReadTimeout != null) {
            this.checkReadTimeout.cancel();
            this.checkReadTimeout = null;
        }
    }

    private void closeWithError(Exception e, boolean fireAsync) {
        if (this.isOpen()) {
            this.close();
            if (fireAsync) {
                this.eventloop.post(() -> this.socketEventHandler.onClosedWithError(e));
            } else {
                this.socketEventHandler.onClosedWithError(e);
            }
        }
    }

    private void postWriteRunnable() {
        if (this.writeTimestamp == 0L) {
            this.writeTimestamp = this.eventloop.currentTimeMillis();
            assert (this.writeTimestamp != 0L);
            this.eventloop.post(() -> {
                if (this.writeTimestamp == 0L || !this.isOpen()) {
                    return;
                }
                this.writeTimestamp = 0L;
                try {
                    this.doWrite();
                }
                catch (IOException e) {
                    this.closeWithError(e, true);
                }
            });
        }
    }

    public boolean isOpen() {
        return this.key != null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        try {
            return (InetSocketAddress)this.channel.getRemoteAddress();
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"I/O error occurs or channel closed");
        }
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public String toString() {
        String keyOps;
        try {
            keyOps = this.key == null ? "" : this.opsToString(this.key.interestOps());
        }
        catch (Exception e) {
            keyOps = "Key throwed exception: " + e.toString();
        }
        return "AsyncTcpSocketImpl{channel=" + (this.channel == null ? "" : this.channel.toString()) + ", writeQueueSize=" + this.writeQueue.size() + ", writeEndOfStream=" + this.writeEndOfStream + ", key.ops=" + keyOps + ", ops=" + this.opsToString(this.ops) + ", writing=" + (this.writeTimestamp != 0L) + '}';
    }

    private String opsToString(int ops) {
        StringBuilder sb = new StringBuilder();
        if ((ops & 0x80) != 0) {
            sb.append("OP_POSTPONED ");
        }
        if ((ops & 4) != 0) {
            sb.append("OP_WRITE ");
        }
        if ((ops & 1) != 0) {
            sb.append("OP_READ ");
        }
        return sb.toString();
    }

    public static class JmxInspector
    implements Inspector {
        public static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
        private final ValueStats reads = ValueStats.create(SMOOTHING_WINDOW);
        private final EventStats readEndOfStreams = EventStats.create(SMOOTHING_WINDOW);
        private final EventStats readErrors = EventStats.create(SMOOTHING_WINDOW);
        private final EventStats readTimeouts = EventStats.create(SMOOTHING_WINDOW);
        private final ValueStats writes = ValueStats.create(SMOOTHING_WINDOW);
        private final EventStats writeErrors = EventStats.create(SMOOTHING_WINDOW);
        private final EventStats writeTimeouts = EventStats.create(SMOOTHING_WINDOW);
        private final EventStats writeOverloaded = EventStats.create(SMOOTHING_WINDOW);

        @Override
        public void onReadTimeout() {
            this.readTimeouts.recordEvent();
        }

        @Override
        public void onRead(ByteBuf buf) {
            this.reads.recordValue(buf.readRemaining());
        }

        @Override
        public void onReadEndOfStream() {
            this.readEndOfStreams.recordEvent();
        }

        @Override
        public void onReadError(IOException e) {
            this.readErrors.recordEvent();
        }

        @Override
        public void onWriteTimeout() {
            this.writeTimeouts.recordEvent();
        }

        @Override
        public void onWrite(ByteBuf buf, int bytes) {
            this.writes.recordValue(bytes);
            if (buf.readRemaining() != bytes) {
                this.writeOverloaded.recordEvent();
            }
        }

        @Override
        public void onWriteError(IOException e) {
            this.writeErrors.recordEvent();
        }

        @JmxAttribute
        public EventStats getReadTimeouts() {
            return this.readTimeouts;
        }

        @JmxAttribute
        public ValueStats getReads() {
            return this.reads;
        }

        @JmxAttribute
        public EventStats getReadEndOfStreams() {
            return this.readEndOfStreams;
        }

        @JmxAttribute
        public EventStats getReadErrors() {
            return this.readErrors;
        }

        @JmxAttribute
        public EventStats getWriteTimeouts() {
            return this.writeTimeouts;
        }

        @JmxAttribute
        public ValueStats getWrites() {
            return this.writes;
        }

        @JmxAttribute
        public EventStats getWriteErrors() {
            return this.writeErrors;
        }

        @JmxAttribute
        public EventStats getWriteOverloaded() {
            return this.writeOverloaded;
        }
    }

    public static interface Inspector {
        public void onReadTimeout();

        public void onRead(ByteBuf var1);

        public void onReadEndOfStream();

        public void onReadError(IOException var1);

        public void onWriteTimeout();

        public void onWrite(ByteBuf var1, int var2);

        public void onWriteError(IOException var1);
    }
}

