/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.eventloop.AsyncUdpSocket;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.NioChannelEventHandler;
import io.datakernel.eventloop.UdpPacket;
import io.datakernel.jmx.EventStats;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.ValueStats;
import io.datakernel.util.MemSize;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.time.Duration;
import java.util.ArrayDeque;

public final class AsyncUdpSocketImpl
implements AsyncUdpSocket,
NioChannelEventHandler {
    private static final MemSize DEFAULT_UDP_BUFFER_SIZE = MemSize.kilobytes((long)16L);
    private final Eventloop eventloop;
    private SelectionKey key;
    private int receiveBufferSize = DEFAULT_UDP_BUFFER_SIZE.toInt();
    private final DatagramChannel channel;
    private final ArrayDeque<UdpPacket> writeQueue = new ArrayDeque();
    private AsyncUdpSocket.EventHandler eventHandler;
    private int ops = 0;
    private Inspector inspector;

    private AsyncUdpSocketImpl(Eventloop eventloop, DatagramChannel channel) {
        this.eventloop = (Eventloop)Preconditions.checkNotNull((Object)eventloop);
        this.channel = (DatagramChannel)Preconditions.checkNotNull((Object)channel);
    }

    public static AsyncUdpSocketImpl create(Eventloop eventloop, DatagramChannel channel) {
        return new AsyncUdpSocketImpl(eventloop, channel);
    }

    public AsyncUdpSocketImpl withInspector(Inspector inspector) {
        this.inspector = inspector;
        return this;
    }

    @Override
    public void setEventHandler(AsyncUdpSocket.EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void register() {
        try {
            this.key = this.channel.register(this.eventloop.ensureSelector(), this.ops, this);
        }
        catch (IOException e) {
            this.eventloop.post(() -> {
                this.eventloop.closeChannel(this.channel);
                this.eventHandler.onClosedWithError(e);
            });
        }
        this.eventHandler.onRegistered();
    }

    public final boolean isOpen() {
        return this.key != null;
    }

    @Override
    public void receive() {
        this.readInterest(true);
    }

    @Override
    public void onReadReady() {
        while (this.isOpen()) {
            InetSocketAddress sourceAddress;
            ByteBuffer buffer;
            ByteBuf buf;
            block5: {
                buf = ByteBufPool.allocate((int)this.receiveBufferSize);
                buffer = buf.toWriteByteBuffer();
                sourceAddress = null;
                try {
                    sourceAddress = (InetSocketAddress)this.channel.receive(buffer);
                }
                catch (IOException e) {
                    if (this.inspector == null) break block5;
                    this.inspector.onReceiveError(e);
                }
            }
            if (sourceAddress == null) {
                buf.recycle();
                break;
            }
            buf.ofWriteByteBuffer(buffer);
            UdpPacket packet = UdpPacket.of(buf, sourceAddress);
            if (this.inspector != null) {
                this.inspector.onReceive(packet);
            }
            this.eventHandler.onReceive(packet);
        }
    }

    @Override
    public void send(UdpPacket packet) {
        this.writeQueue.add(packet);
        this.onWriteReady();
    }

    @Override
    public void onWriteReady() {
        while (!this.writeQueue.isEmpty()) {
            int sent;
            int needToSend;
            UdpPacket packet;
            block6: {
                packet = this.writeQueue.peek();
                ByteBuffer buffer = packet.getBuf().toReadByteBuffer();
                needToSend = buffer.remaining();
                sent = -1;
                try {
                    sent = this.channel.send(buffer, packet.getSocketAddress());
                }
                catch (IOException e) {
                    if (this.inspector == null) break block6;
                    this.inspector.onSendError(e);
                }
            }
            if (sent != needToSend) break;
            if (this.inspector != null) {
                this.inspector.onSend(packet);
            }
            this.writeQueue.poll();
            packet.recycle();
        }
        if (this.writeQueue.isEmpty()) {
            this.eventHandler.onSend();
            this.writeInterest(false);
        } else {
            this.writeInterest(true);
        }
    }

    private void interests(int newOps) {
        if (this.ops != newOps) {
            this.ops = newOps;
            if ((this.ops & 0x80) == 0 && this.key != null) {
                this.key.interestOps(this.ops);
            }
        }
    }

    private void readInterest(boolean readInterest) {
        this.interests(readInterest ? this.ops | 1 : this.ops & 0xFFFFFFFE);
    }

    private void writeInterest(boolean writeInterest) {
        this.interests(writeInterest ? this.ops | 4 : this.ops & 0xFFFFFFFB);
    }

    @Override
    public void close() {
        assert (this.eventloop.inEventloopThread());
        if (this.key == null) {
            return;
        }
        this.eventloop.closeChannel(this.key);
        this.key = null;
        for (UdpPacket packet : this.writeQueue) {
            packet.recycle();
        }
        this.writeQueue.clear();
    }

    public String toString() {
        return this.getRemoteSocketAddress() + " " + this.eventHandler.toString();
    }

    private InetSocketAddress getRemoteSocketAddress() {
        try {
            return (InetSocketAddress)this.channel.getRemoteAddress();
        }
        catch (IOException ignored) {
            throw new AssertionError((Object)"I/O error occurs or channel closed");
        }
    }

    public static class JmxInspector
    implements Inspector {
        private final ValueStats receives;
        private final EventStats receiveErrors;
        private final ValueStats sends;
        private final EventStats sendErrors;

        public JmxInspector(Duration smoothingWindow) {
            this.receives = ValueStats.create(smoothingWindow);
            this.receiveErrors = EventStats.create(smoothingWindow);
            this.sends = ValueStats.create(smoothingWindow);
            this.sendErrors = EventStats.create(smoothingWindow);
        }

        @Override
        public void onReceive(UdpPacket packet) {
            this.receives.recordValue(packet.getBuf().readRemaining());
        }

        @Override
        public void onReceiveError(IOException e) {
            this.receiveErrors.recordEvent();
        }

        @Override
        public void onSend(UdpPacket packet) {
            this.sends.recordValue(packet.getBuf().readRemaining());
        }

        @Override
        public void onSendError(IOException e) {
            this.sendErrors.recordEvent();
        }

        @JmxAttribute(description="Received packet size")
        public ValueStats getReceives() {
            return this.receives;
        }

        @JmxAttribute
        public EventStats getReceiveErrors() {
            return this.receiveErrors;
        }

        @JmxAttribute(description="Sent packet size")
        public ValueStats getSends() {
            return this.sends;
        }

        @JmxAttribute
        public EventStats getSendErrors() {
            return this.sendErrors;
        }
    }

    public static interface Inspector {
        public void onReceive(UdpPacket var1);

        public void onReceiveError(IOException var1);

        public void onSend(UdpPacket var1);

        public void onSendError(IOException var1);
    }
}

