/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.async.AsyncCallable;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingEventloopExecutor
implements EventloopExecutor {
    private final Eventloop eventloop;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final AtomicInteger tasks = new AtomicInteger();
    private final int limit;

    private BlockingEventloopExecutor(Eventloop eventloop, int limit) {
        this.eventloop = eventloop;
        this.limit = limit;
    }

    public static BlockingEventloopExecutor create(Eventloop eventloop, int limit) {
        return new BlockingEventloopExecutor(eventloop, limit);
    }

    public int getLimit() {
        return this.limit;
    }

    private void post(Runnable runnable) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.tasks.get() > this.limit) {
                this.notFull.await();
            }
            this.tasks.incrementAndGet();
            this.eventloop.execute(runnable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void post(Runnable runnable, CompletableFuture<?> future) {
        try {
            this.post(runnable);
        }
        catch (InterruptedException e) {
            future.completeExceptionally(e);
        }
    }

    private void complete() {
        this.lock.lock();
        try {
            this.tasks.decrementAndGet();
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void execute(final Runnable runnable) {
        try {
            this.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        BlockingEventloopExecutor.this.complete();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public CompletableFuture<Void> submit(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.post(() -> {
            Exception exception = null;
            try {
                runnable.run();
            }
            catch (Exception e) {
                exception = e;
            }
            this.complete();
            if (exception == null) {
                future.complete(null);
            } else {
                future.completeExceptionally(exception);
            }
        }, future);
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(Callable<T> callable) {
        CompletableFuture future = new CompletableFuture();
        this.post(() -> {
            Object result = null;
            Exception exception = null;
            try {
                result = callable.call();
            }
            catch (Exception e) {
                exception = e;
            }
            this.complete();
            if (exception == null) {
                future.complete(result);
            } else {
                future.completeExceptionally(exception);
            }
        }, future);
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(AsyncCallable<T> asyncCallable) {
        CompletableFuture future = new CompletableFuture();
        this.post(() -> asyncCallable.call().whenComplete((t, throwable) -> this.complete()).whenComplete((t, throwable) -> {
            if (throwable == null) {
                future.complete(t);
            } else {
                future.completeExceptionally(throwable);
            }
        }), future);
        return future;
    }
}

