/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.AsyncCallable;
import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.eventloop.AcceptCallback;
import io.datakernel.eventloop.EventloopExecutor;
import io.datakernel.eventloop.EventloopStats;
import io.datakernel.eventloop.FatalErrorHandler;
import io.datakernel.eventloop.FatalErrorHandlers;
import io.datakernel.eventloop.NioChannelEventHandler;
import io.datakernel.eventloop.ScheduledRunnable;
import io.datakernel.eventloop.Scheduler;
import io.datakernel.eventloop.ThrottlingController;
import io.datakernel.exception.AsyncTimeoutException;
import io.datakernel.exception.StacklessException;
import io.datakernel.jmx.EventloopJmxMBeanEx;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxOperation;
import io.datakernel.net.DatagramSocketSettings;
import io.datakernel.net.ServerSocketSettings;
import io.datakernel.time.CurrentTimeProvider;
import io.datakernel.time.CurrentTimeProviderSystem;
import io.datakernel.util.Initializable;
import io.datakernel.util.Preconditions;
import io.datakernel.util.Stopwatch;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Eventloop
implements Runnable,
EventloopExecutor,
Scheduler,
CurrentTimeProvider,
Initializable<Eventloop>,
EventloopJmxMBeanEx {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final Duration DEFAULT_SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    public static final AsyncTimeoutException CONNECT_TIMEOUT = new AsyncTimeoutException("Connection timed out");
    public static final Duration DEFAULT_IDLE_INTERVAL = Duration.ofSeconds(1L);
    private static volatile FatalErrorHandler globalFatalErrorHandler = FatalErrorHandlers.ignoreAllErrors();
    private final ArrayDeque<Runnable> localTasks = new ArrayDeque();
    private final ConcurrentLinkedQueue<Runnable> concurrentTasks = new ConcurrentLinkedQueue();
    private final PriorityQueue<ScheduledRunnable> scheduledTasks = new PriorityQueue();
    private final PriorityQueue<ScheduledRunnable> backgroundTasks = new PriorityQueue();
    private final AtomicInteger externalTasksCount = new AtomicInteger(0);
    private final CurrentTimeProvider timeProvider;
    private long timeAfterSelectorSelect;
    private long timeAfterBusinessLogic;
    private Selector selector;
    private SelectorProvider selectorProvider;
    private Thread eventloopThread;
    private static final ThreadLocal<Eventloop> CURRENT_EVENTLOOP = new ThreadLocal();
    private String threadName;
    private int threadPriority;
    private FatalErrorHandler fatalErrorHandler;
    private volatile boolean keepAlive;
    private volatile boolean breakEventloop;
    private long tick;
    private long timestamp;
    private Duration idleInterval = DEFAULT_IDLE_INTERVAL;
    private ThrottlingController throttlingController;
    private int throttlingKeys;
    private int lastSelectedKeys;
    private int cancelledKeys;
    private int lastExternalTasksCount;
    private final EventloopStats stats = new EventloopStats(new ExtraStatsExtractor());
    private boolean monitoring = false;
    private static final String NO_CURRENT_EVENTLOOP_ERROR = "Trying to start async operations prior eventloop.run(), or from outside of eventloop.run() \nPossible solutions: 1) Eventloop.create().withCurrentThread() ... {your code block} ... eventloop.run() \n2) try_with_resources Eventloop.useCurrentThread() ... {your code block} \n3) refactor application so it starts async operations within eventloop.run(), \n   i.e. by implementing EventloopService::start() {your code block} and using ServiceGraphModule";

    private Eventloop(CurrentTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.refreshTimestamp();
    }

    public static Eventloop create() {
        return Eventloop.create((CurrentTimeProvider)CurrentTimeProviderSystem.instance());
    }

    public static Eventloop create(CurrentTimeProvider currentTimeProvider) {
        return new Eventloop(currentTimeProvider);
    }

    public Eventloop withThreadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public Eventloop withThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        return this;
    }

    public Eventloop withThrottlingController(@Nullable ThrottlingController throttlingController) {
        this.throttlingController = throttlingController;
        if (throttlingController != null) {
            throttlingController.setEventloop(this);
        }
        return this;
    }

    public Eventloop withFatalErrorHandler(FatalErrorHandler fatalErrorHandler) {
        this.fatalErrorHandler = fatalErrorHandler;
        return this;
    }

    public Eventloop withSelectorProvider(SelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
        return this;
    }

    public Eventloop withIdleInterval(Duration idleInterval) {
        this.idleInterval = idleInterval;
        return this;
    }

    public Eventloop withCurrentThread() {
        CURRENT_EVENTLOOP.set(this);
        return this;
    }

    public Scope useCurrentThread() {
        Eventloop previousEventloop = CURRENT_EVENTLOOP.get();
        CURRENT_EVENTLOOP.set(this);
        return new Scope(previousEventloop);
    }

    public static Eventloop getCurrentEventloop() {
        Eventloop eventloop = CURRENT_EVENTLOOP.get();
        if (eventloop != null) {
            return eventloop;
        }
        throw new IllegalStateException(NO_CURRENT_EVENTLOOP_ERROR);
    }

    public ThrottlingController getThrottlingController() {
        return this.throttlingController;
    }

    private void openSelector() {
        if (this.selector == null) {
            try {
                this.selector = (this.selectorProvider != null ? this.selectorProvider : SelectorProvider.provider()).openSelector();
            }
            catch (Exception exception) {
                this.logger.error("Could not open selector", (Throwable)exception);
                throw new RuntimeException(exception);
            }
        }
    }

    private void closeSelector() {
        if (this.selector != null) {
            try {
                this.selector.close();
                this.selector = null;
                this.cancelledKeys = 0;
            }
            catch (IOException exception) {
                this.logger.error("Could not close selector", (Throwable)exception);
            }
        }
    }

    Selector ensureSelector() {
        if (this.selector == null) {
            this.openSelector();
        }
        return this.selector;
    }

    public void closeChannel(SelectionKey channelKey) {
        if (channelKey.isValid()) {
            ++this.cancelledKeys;
        }
        try {
            channelKey.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeChannel(SelectableChannel channel) {
        if (!channel.isOpen()) {
            return;
        }
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null && key.isValid()) {
            ++this.cancelledKeys;
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean inEventloopThread() {
        return this.eventloopThread == null || this.eventloopThread == Thread.currentThread();
    }

    public void keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        if (!keepAlive && this.selector != null) {
            this.selector.wakeup();
        }
    }

    public void breakEventloop() {
        this.breakEventloop = true;
        if (this.breakEventloop && this.selector != null) {
            this.selector.wakeup();
        }
    }

    private boolean isAlive() {
        if (this.breakEventloop) {
            return false;
        }
        this.lastExternalTasksCount = this.externalTasksCount.get();
        return !this.localTasks.isEmpty() || !this.scheduledTasks.isEmpty() || !this.concurrentTasks.isEmpty() || this.lastExternalTasksCount > 0 || this.keepAlive || this.selector.keys().size() - this.cancelledKeys > 0;
    }

    public Thread getEventloopThread() {
        return this.eventloopThread;
    }

    @Override
    public void run() {
        this.eventloopThread = Thread.currentThread();
        if (this.threadName != null) {
            this.eventloopThread.setName(this.threadName);
        }
        if (this.threadPriority != 0) {
            this.eventloopThread.setPriority(this.threadPriority);
        }
        CURRENT_EVENTLOOP.set(this);
        this.ensureSelector();
        this.breakEventloop = false;
        this.timeAfterSelectorSelect = 0L;
        this.timeAfterBusinessLogic = 0L;
        while (true) {
            if (!this.isAlive()) {
                this.logger.info("Eventloop {} is complete, exiting...", (Object)this);
                break;
            }
            try {
                long selectTimeout = this.getSelectTimeout();
                this.stats.updateSelectorSelectTimeout(selectTimeout);
                this.lastSelectedKeys = selectTimeout <= 0L ? this.selector.selectNow() : this.selector.select(selectTimeout);
                this.cancelledKeys = 0;
            }
            catch (ClosedChannelException e) {
                this.logger.error("Selector is closed, exiting...", (Throwable)e);
                break;
            }
            catch (IOException e) {
                this.recordIoError(e, this.selector);
            }
            this.updateSelectorSelectStats();
            int keys = this.processSelectedKeys(this.selector.selectedKeys());
            int concurrentTasks = this.executeConcurrentTasks();
            int scheduledTasks = this.executeScheduledTasks();
            int backgroundTasks = this.executeBackgroundTasks();
            int localTasks = this.executeLocalTasks();
            this.updateBusinessLogicStats(keys + concurrentTasks + scheduledTasks + backgroundTasks + localTasks);
            this.tick = this.tick + 0x100000000L & 0xFFFFFFFF00000000L;
        }
        this.logger.info("Eventloop {} finished", (Object)this);
        this.eventloopThread = null;
        if (this.selector.keys().stream().noneMatch(SelectionKey::isValid)) {
            this.closeSelector();
        } else {
            this.logger.warn("Selector is still open, because event loop {} has {} keys", (Object)this, this.selector.keys());
        }
    }

    private void updateSelectorSelectStats() {
        this.timeAfterSelectorSelect = this.refreshTimestampAndGet();
        if (this.timeAfterBusinessLogic != 0L) {
            long selectorSelectTime = this.timeAfterSelectorSelect - this.timeAfterBusinessLogic;
            this.stats.updateSelectorSelectTime(selectorSelectTime);
        }
        if (this.throttlingController != null) {
            this.throttlingKeys = this.lastSelectedKeys + this.concurrentTasks.size();
            this.throttlingController.calculateThrottling(this.throttlingKeys);
        }
    }

    private void updateBusinessLogicStats(int tasksAndKeys) {
        this.timeAfterBusinessLogic = this.timestamp;
        long businessLogicTime = this.timeAfterBusinessLogic - this.timeAfterSelectorSelect;
        this.stats.updateBusinessLogicTime(tasksAndKeys, this.lastExternalTasksCount, businessLogicTime);
        if (this.throttlingController != null) {
            this.throttlingController.updateInternalStats(this.throttlingKeys, (int)businessLogicTime);
        }
    }

    private long getSelectTimeout() {
        if (!this.concurrentTasks.isEmpty() || !this.localTasks.isEmpty()) {
            return 0L;
        }
        if (this.scheduledTasks.isEmpty() && this.backgroundTasks.isEmpty()) {
            return this.idleInterval.toMillis();
        }
        return Math.min(this.getTimeBeforeExecution(this.scheduledTasks), this.getTimeBeforeExecution(this.backgroundTasks));
    }

    private long getTimeBeforeExecution(PriorityQueue<ScheduledRunnable> taskQueue) {
        while (!taskQueue.isEmpty()) {
            ScheduledRunnable first = taskQueue.peek();
            assert (first != null);
            if (first.isCancelled()) {
                taskQueue.poll();
                continue;
            }
            return first.getTimestamp() - this.currentTimeMillis();
        }
        return this.idleInterval.toMillis();
    }

    private int processSelectedKeys(Set<SelectionKey> selectedKeys) {
        Iterator<Object> iterator;
        long startTimestamp = this.timestamp;
        Stopwatch sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        int invalidKeys = 0;
        int acceptKeys = 0;
        int connectKeys = 0;
        int readKeys = 0;
        int writeKeys = 0;
        Iterator<Object> iterator2 = iterator = this.lastSelectedKeys != 0 ? selectedKeys.iterator() : Collections.emptyIterator();
        while (iterator.hasNext()) {
            SelectionKey key = (SelectionKey)iterator.next();
            iterator.remove();
            if (!key.isValid()) {
                ++invalidKeys;
                continue;
            }
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (key.isAcceptable()) {
                this.onAccept(key);
                ++acceptKeys;
            } else if (key.isConnectable()) {
                this.onConnect(key);
                ++connectKeys;
            } else {
                if (key.isReadable()) {
                    this.onRead(key);
                    ++readKeys;
                }
                if (key.isValid()) {
                    if (key.isWritable()) {
                        this.onWrite(key);
                        ++writeKeys;
                    }
                } else {
                    ++invalidKeys;
                }
            }
            if (sw == null) continue;
            this.stats.updateSelectedKeyDuration(sw);
        }
        long loopTime = this.refreshTimestampAndGet() - startTimestamp;
        this.stats.updateSelectedKeysStats(this.lastSelectedKeys, invalidKeys, acceptKeys, connectKeys, readKeys, writeKeys, loopTime);
        return acceptKeys + connectKeys + readKeys + writeKeys + invalidKeys;
    }

    private int executeLocalTasks() {
        Runnable runnable;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        int newRunnables = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((runnable = this.localTasks.poll()) != null) {
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            try {
                runnable.run();
                ++this.tick;
                if (sw != null) {
                    this.stats.updateLocalTaskDuration(runnable, sw);
                }
            }
            catch (Throwable e) {
                this.recordFatalError(e, runnable);
            }
            ++newRunnables;
        }
        long loopTime = this.refreshTimestampAndGet() - startTimestamp;
        this.stats.updateLocalTasksStats(newRunnables, loopTime);
        return newRunnables;
    }

    private int executeConcurrentTasks() {
        Runnable runnable;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        int newRunnables = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((runnable = this.concurrentTasks.poll()) != null) {
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            try {
                runnable.run();
                if (sw != null) {
                    this.stats.updateConcurrentTaskDuration(runnable, sw);
                }
            }
            catch (Throwable e) {
                this.recordFatalError(e, runnable);
            }
            ++newRunnables;
        }
        long loopTime = this.refreshTimestampAndGet() - startTimestamp;
        this.stats.updateConcurrentTasksStats(newRunnables, loopTime);
        return newRunnables;
    }

    private int executeScheduledTasks() {
        return this.executeScheduledTasks(this.scheduledTasks);
    }

    private int executeBackgroundTasks() {
        return this.executeScheduledTasks(this.backgroundTasks);
    }

    private int executeScheduledTasks(PriorityQueue<ScheduledRunnable> taskQueue) {
        ScheduledRunnable peeked;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        boolean background = taskQueue == this.backgroundTasks;
        int newRunnables = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((peeked = taskQueue.peek()) != null) {
            if (peeked.isCancelled()) {
                taskQueue.poll();
                continue;
            }
            if (peeked.getTimestamp() > this.currentTimeMillis()) break;
            ScheduledRunnable polled = taskQueue.poll();
            assert (polled == peeked);
            Runnable runnable = polled.getRunnable();
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (this.monitoring) {
                int overdue = (int)(System.currentTimeMillis() - peeked.getTimestamp());
                this.stats.recordScheduledTaskOverdue(overdue, background);
            }
            try {
                runnable.run();
                ++this.tick;
                polled.complete();
                if (sw != null) {
                    this.stats.updateScheduledTaskDuration(runnable, sw, background);
                }
            }
            catch (Throwable e) {
                this.recordFatalError(e, runnable);
            }
            ++newRunnables;
        }
        long loopTime = this.refreshTimestampAndGet() - startTimestamp;
        this.stats.updateScheduledTasksStats(newRunnables, loopTime, background);
        return newRunnables;
    }

    private void onAccept(SelectionKey key) {
        assert (this.inEventloopThread());
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        if (!serverSocketChannel.isOpen()) {
            key.cancel();
            return;
        }
        AcceptCallback acceptCallback = (AcceptCallback)key.attachment();
        while (true) {
            SocketChannel socketChannel;
            try {
                socketChannel = serverSocketChannel.accept();
                if (socketChannel == null) break;
                socketChannel.configureBlocking(false);
            }
            catch (ClosedChannelException e) {
                break;
            }
            catch (IOException e) {
                this.recordIoError(e, serverSocketChannel);
                break;
            }
            try {
                acceptCallback.onAccept(socketChannel);
            }
            catch (Throwable e) {
                this.recordFatalError(e, acceptCallback);
                this.closeChannel(socketChannel);
            }
        }
    }

    private void onConnect(SelectionKey key) {
        boolean connected;
        assert (this.inEventloopThread());
        SettableStage connectStage = (SettableStage)key.attachment();
        SocketChannel socketChannel = (SocketChannel)key.channel();
        try {
            connected = socketChannel.finishConnect();
        }
        catch (IOException e) {
            this.closeChannel(socketChannel);
            connectStage.setException(e);
            return;
        }
        try {
            if (connected) {
                connectStage.set(socketChannel);
            } else {
                connectStage.setException((Throwable)new StacklessException("Not connected"));
            }
        }
        catch (Throwable e) {
            this.recordFatalError(e, socketChannel);
            this.closeChannel(socketChannel);
        }
    }

    private void onRead(SelectionKey key) {
        assert (this.inEventloopThread());
        NioChannelEventHandler handler = (NioChannelEventHandler)key.attachment();
        try {
            handler.onReadReady();
        }
        catch (Throwable e) {
            this.recordFatalError(e, handler);
            this.closeChannel(key);
        }
    }

    private void onWrite(SelectionKey key) {
        assert (this.inEventloopThread());
        NioChannelEventHandler handler = (NioChannelEventHandler)key.attachment();
        try {
            handler.onWriteReady();
        }
        catch (Throwable e) {
            this.recordFatalError(e, handler);
            this.closeChannel(key);
        }
    }

    public ServerSocketChannel listen(InetSocketAddress address, ServerSocketSettings serverSocketSettings, AcceptCallback acceptCallback) throws IOException {
        assert (this.inEventloopThread());
        ServerSocketChannel serverChannel = null;
        try {
            serverChannel = ServerSocketChannel.open();
            serverSocketSettings.applySettings(serverChannel);
            serverChannel.configureBlocking(false);
            serverChannel.bind(address, serverSocketSettings.getBacklog());
            serverChannel.register(this.ensureSelector(), 16, acceptCallback);
            return serverChannel;
        }
        catch (IOException e) {
            if (serverChannel != null) {
                this.closeChannel(serverChannel);
            }
            throw e;
        }
    }

    public static DatagramChannel createDatagramChannel(DatagramSocketSettings datagramSocketSettings, @Nullable InetSocketAddress bindAddress, @Nullable InetSocketAddress connectAddress) throws IOException {
        DatagramChannel datagramChannel = null;
        try {
            datagramChannel = DatagramChannel.open();
            datagramSocketSettings.applySettings(datagramChannel);
            datagramChannel.configureBlocking(false);
            datagramChannel.bind(bindAddress);
            if (connectAddress != null) {
                datagramChannel.connect(connectAddress);
            }
            return datagramChannel;
        }
        catch (IOException e) {
            if (datagramChannel != null) {
                try {
                    datagramChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public Stage<SocketChannel> connect(SocketAddress address) {
        return this.connect(address, 0);
    }

    public Stage<SocketChannel> connect(SocketAddress address, int timeout) {
        assert (this.inEventloopThread());
        SocketChannel socketChannel = null;
        SettableStage<SocketChannel> stage = SettableStage.create();
        try {
            socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.connect(address);
            SelectionKey key = socketChannel.register(this.ensureSelector(), 8, stage);
            if (timeout != 0) {
                ScheduledRunnable scheduledTimeout = this.delay(timeout, () -> {
                    this.closeChannel(key);
                    stage.setException((Throwable)CONNECT_TIMEOUT);
                });
                stage.whenComplete(($, throwable) -> scheduledTimeout.cancel());
            }
        }
        catch (IOException e) {
            if (socketChannel != null) {
                this.closeChannel(socketChannel);
            }
            try {
                stage.setException(e);
            }
            catch (Throwable e1) {
                this.recordFatalError(e1, stage);
            }
        }
        return stage;
    }

    public long tick() {
        assert (this.inEventloopThread());
        return this.tick;
    }

    public void post(Runnable runnable) {
        assert (this.inEventloopThread());
        this.localTasks.addFirst(runnable);
    }

    public void postLater(Runnable runnable) {
        assert (this.inEventloopThread());
        this.localTasks.addLast(runnable);
    }

    @Override
    public void execute(Runnable runnable) {
        this.concurrentTasks.offer(runnable);
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    @Override
    public ScheduledRunnable schedule(long timestamp, Runnable runnable) {
        assert (this.inEventloopThread());
        return this.addScheduledTask(timestamp, runnable, false);
    }

    public ScheduledRunnable delay(long delayMillis, Runnable runnable) {
        return this.schedule(this.timestamp + delayMillis, runnable);
    }

    public ScheduledRunnable delay(Duration delay, Runnable runnable) {
        return this.delay(delay.toMillis(), runnable);
    }

    @Override
    public ScheduledRunnable scheduleBackground(long timestamp, Runnable runnable) {
        assert (this.inEventloopThread());
        return this.addScheduledTask(timestamp, runnable, true);
    }

    public ScheduledRunnable delayBackground(long delayMillis, Runnable runnable) {
        return this.scheduleBackground(this.timestamp + delayMillis, runnable);
    }

    private ScheduledRunnable addScheduledTask(long timestamp, Runnable runnable, boolean background) {
        ScheduledRunnable scheduledTask = ScheduledRunnable.create(timestamp, runnable);
        PriorityQueue<ScheduledRunnable> taskQueue = background ? this.backgroundTasks : this.scheduledTasks;
        taskQueue.offer(scheduledTask);
        return scheduledTask;
    }

    public void startExternalTask() {
        this.externalTasksCount.incrementAndGet();
    }

    public void completeExternalTask() {
        this.externalTasksCount.decrementAndGet();
    }

    public long refreshTimestampAndGet() {
        this.refreshTimestamp();
        return this.timestamp;
    }

    private void refreshTimestamp() {
        this.timestamp = this.timeProvider.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.timestamp;
    }

    @Override
    public Eventloop getEventloop() {
        return this;
    }

    @Override
    public CompletableFuture<Void> submit(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.execute(() -> {
            Exception exception = null;
            try {
                runnable.run();
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception == null) {
                future.complete(null);
            } else {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(Callable<T> callable) {
        CompletableFuture future = new CompletableFuture();
        this.execute(() -> {
            Object result = null;
            Exception exception = null;
            try {
                result = callable.call();
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception == null) {
                future.complete(result);
            } else {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(AsyncCallable<T> asyncCallable) {
        CompletableFuture future = new CompletableFuture();
        this.execute(() -> asyncCallable.call().whenComplete((t, throwable) -> {
            if (throwable == null) {
                future.complete(t);
            } else {
                future.completeExceptionally(throwable);
            }
        }));
        return future;
    }

    public static void setGlobalFatalErrorHandler(FatalErrorHandler handler) {
        globalFatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)handler);
    }

    @JmxOperation(description="enable monitoring [ when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled) ]")
    public void startExtendedMonitoring() {
        this.monitoring = true;
    }

    @JmxOperation(description="disable monitoring [ when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled) ]")
    public void stopExtendedMonitoring() {
        this.monitoring = false;
    }

    @JmxAttribute(description="when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled)")
    public boolean isExtendedMonitoring() {
        return this.monitoring;
    }

    private void recordIoError(Exception e, Object context) {
        this.logger.warn("IO Error in {}: {}", context, (Object)e.toString());
    }

    public void recordFatalError(Throwable e, Object context) {
        if (e instanceof RethrowedError) {
            Eventloop.propagate(e.getCause());
        }
        this.logger.error("Fatal Error in " + context, e);
        if (this.fatalErrorHandler != null) {
            this.handleFatalError(this.fatalErrorHandler, e, context);
        } else {
            this.handleFatalError(globalFatalErrorHandler, e, context);
        }
        if (this.inEventloopThread()) {
            this.stats.recordFatalError(e, context);
        } else {
            this.execute(() -> this.stats.recordFatalError(e, context));
        }
    }

    private void handleFatalError(FatalErrorHandler handler, Throwable e, Object context) {
        if (this.inEventloopThread()) {
            handler.handle(e, context);
        } else {
            try {
                handler.handle(e, context);
            }
            catch (Throwable handlerError) {
                this.execute(() -> {
                    throw new RethrowedError(handlerError);
                });
            }
        }
    }

    private static void propagate(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public int getLoop() {
        return (int)(this.tick >>> 32);
    }

    public long getTick() {
        return this.tick;
    }

    public FatalErrorHandler getFatalErrorHandler() {
        return this.fatalErrorHandler;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    @JmxAttribute
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @JmxAttribute(name="")
    public EventloopStats getStats() {
        return this.stats;
    }

    @JmxAttribute
    public Duration getIdleInterval() {
        return this.idleInterval;
    }

    @JmxAttribute
    public void setIdleInterval(Duration idleInterval) {
        this.idleInterval = idleInterval;
    }

    public String toString() {
        return this.threadName != null ? this.threadName : super.toString();
    }

    final class ExtraStatsExtractor {
        ExtraStatsExtractor() {
        }

        int getLocalTasksCount() {
            return Eventloop.this.localTasks.size();
        }

        int getConcurrentTasksCount() {
            return Eventloop.this.concurrentTasks.size();
        }

        int getScheduledTasksCount() {
            return Eventloop.this.scheduledTasks.size();
        }

        int getBackgroundTasksCount() {
            return Eventloop.this.backgroundTasks.size();
        }
    }

    private static class RethrowedError
    extends Error {
        public RethrowedError(Throwable cause) {
            super(cause);
        }
    }

    public final class Scope
    implements AutoCloseable {
        private final Eventloop previousEventloop;
        private boolean closed;

        public Scope(Eventloop previousEventloop) {
            this.previousEventloop = previousEventloop;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.previousEventloop == null) {
                CURRENT_EVENTLOOP.remove();
            } else {
                CURRENT_EVENTLOOP.set(this.previousEventloop);
            }
        }
    }
}

