/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.annotation.Nullable;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.jmx.EventStats;
import io.datakernel.jmx.ExceptionStats;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxReducers;
import io.datakernel.jmx.JmxStats;
import io.datakernel.jmx.JmxStatsWithReset;
import io.datakernel.jmx.ValueStats;
import io.datakernel.util.Stopwatch;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class EventloopStats {
    private final EventStats loops = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
    private final ValueStats selectorSelectTimeout = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(new int[]{-256, -128, -64, -32, -16, -8, -4, -2, -1, 0, 1, 2, 4, 8, 16, 32});
    private final ValueStats selectorSelectTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
    private final ValueStats businessLogicTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
    private final Tasks tasks;
    private final Keys keys;
    private final ExceptionStats fatalErrors;
    private final Map<Class<? extends Throwable>, ExceptionStats> fatalErrorsMap;
    private final EventStats idleLoops;
    private final EventStats idleLoopsWaitingExternalTask;
    private final EventStats selectOverdues;

    EventloopStats(Eventloop.ExtraStatsExtractor extraStatsExtractor) {
        this.tasks = new Tasks(extraStatsExtractor);
        this.keys = new Keys();
        this.fatalErrors = ExceptionStats.create();
        this.fatalErrorsMap = new HashMap<Class<? extends Throwable>, ExceptionStats>();
        this.idleLoops = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        this.idleLoopsWaitingExternalTask = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        this.selectOverdues = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
    }

    public void updateBusinessLogicTime(int tasksAndKeys, int externalTasksCount, long businessLogicTime) {
        this.loops.recordEvent();
        if (tasksAndKeys != 0) {
            this.businessLogicTime.recordValue((int)businessLogicTime);
        } else if (externalTasksCount == 0) {
            this.idleLoops.recordEvent();
        } else {
            this.idleLoopsWaitingExternalTask.recordEvent();
        }
    }

    public void updateSelectorSelectTime(long selectorSelectTime) {
        this.selectorSelectTime.recordValue((int)selectorSelectTime);
    }

    public void updateSelectorSelectTimeout(long selectorSelectTimeout) {
        this.selectorSelectTimeout.recordValue((int)selectorSelectTimeout);
        if (selectorSelectTimeout < 0L) {
            this.selectOverdues.recordEvent();
        }
    }

    public void updateSelectedKeyDuration(Stopwatch sw) {
        if (sw != null) {
            this.keys.oneKeyTime.recordValue((int)sw.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    public void updateSelectedKeysStats(int lastSelectedKeys, int invalidKeys, int acceptKeys, int connectKeys, int readKeys, int writeKeys, long loopTime) {
        this.keys.all.recordEvents(lastSelectedKeys);
        this.keys.invalid.recordEvents(invalidKeys);
        this.keys.acceptPerLoop.recordValue(acceptKeys);
        this.keys.connectPerLoop.recordValue(connectKeys);
        this.keys.readPerLoop.recordValue(readKeys);
        this.keys.writePerLoop.recordValue(writeKeys);
        if (lastSelectedKeys != 0) {
            this.keys.loopTime.recordValue((int)loopTime);
        }
    }

    private void updateTaskDuration(ValueStats counter, DurationRunnable longestCounter, Runnable runnable, @Nullable Stopwatch sw) {
        if (sw != null) {
            int elapsed = (int)sw.elapsed(TimeUnit.MICROSECONDS);
            counter.recordValue(elapsed);
            if ((long)elapsed > longestCounter.getDuration()) {
                longestCounter.update(runnable, elapsed);
            }
        }
    }

    public void updateLocalTaskDuration(Runnable runnable, @Nullable Stopwatch sw) {
        this.updateTaskDuration(this.tasks.local.oneTaskTime, this.tasks.local.longestTask, runnable, sw);
    }

    public void updateLocalTasksStats(int newTasks, long loopTime) {
        if (newTasks != 0) {
            this.tasks.local.loopTime.recordValue((int)loopTime);
        }
        this.tasks.local.tasksPerLoop.recordValue(newTasks);
    }

    public void updateConcurrentTaskDuration(Runnable runnable, @Nullable Stopwatch sw) {
        this.updateTaskDuration(this.tasks.concurrent.oneTaskTime, this.tasks.concurrent.longestTask, runnable, sw);
    }

    public void updateConcurrentTasksStats(int newTasks, long loopTime) {
        if (newTasks != 0) {
            this.tasks.concurrent.loopTime.recordValue((int)loopTime);
        }
        this.tasks.concurrent.tasksPerLoop.recordValue(newTasks);
    }

    public void updateScheduledTaskDuration(Runnable runnable, @Nullable Stopwatch sw, boolean background) {
        if (background) {
            this.updateTaskDuration(this.tasks.background.getOneTaskTime(), this.tasks.background.getLongestTask(), runnable, sw);
        } else {
            this.updateTaskDuration(this.tasks.scheduled.getOneTaskTime(), this.tasks.scheduled.getLongestTask(), runnable, sw);
        }
    }

    public void updateScheduledTasksStats(int newTasks, long loopTime, boolean background) {
        if (background) {
            if (newTasks != 0) {
                this.tasks.background.getLoopTime().recordValue((int)loopTime);
            }
            this.tasks.background.getTasksPerLoop().recordValue(newTasks);
        } else {
            if (newTasks != 0) {
                this.tasks.scheduled.getLoopTime().recordValue((int)loopTime);
            }
            this.tasks.scheduled.getTasksPerLoop().recordValue(newTasks);
        }
    }

    public void recordFatalError(Throwable throwable, Object causedObject) {
        this.fatalErrors.recordException(throwable, causedObject);
        Class<?> type = throwable.getClass();
        ExceptionStats stats = this.fatalErrorsMap.get(type);
        if (stats == null) {
            stats = ExceptionStats.create();
            this.fatalErrorsMap.put(type, stats);
        }
        stats.recordException(throwable, causedObject);
    }

    public void recordScheduledTaskOverdue(int overdue, boolean background) {
        if (background) {
            this.tasks.background.overdues.recordValue(overdue);
        } else {
            this.tasks.scheduled.overdues.recordValue(overdue);
        }
    }

    @JmxAttribute
    public EventStats getLoops() {
        return this.loops;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getSelectorSelectTime() {
        return this.selectorSelectTime;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getSelectorSelectTimeout() {
        return this.selectorSelectTimeout;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getBusinessLogicTime() {
        return this.businessLogicTime;
    }

    @JmxAttribute
    public Tasks getTasks() {
        return this.tasks;
    }

    @JmxAttribute
    public Keys getKeys() {
        return this.keys;
    }

    @JmxAttribute
    public ExceptionStats getFatalErrors() {
        return this.fatalErrors;
    }

    @JmxAttribute
    public Map<Class<? extends Throwable>, ExceptionStats> getFatalErrorsMap() {
        return this.fatalErrorsMap;
    }

    @JmxAttribute
    public EventStats getIdleLoops() {
        return this.idleLoops;
    }

    @JmxAttribute
    public EventStats getIdleLoopsWaitingExternalTask() {
        return this.idleLoopsWaitingExternalTask;
    }

    @JmxAttribute
    public EventStats getSelectOverdues() {
        return this.selectOverdues;
    }

    public static final class DurationRunnable
    implements JmxStats<DurationRunnable>,
    JmxStatsWithReset {
        private long duration;
        private Runnable runnable;

        @Override
        public void resetStats() {
            this.duration = 0L;
            this.runnable = null;
        }

        void update(Runnable runnable, long duration) {
            this.duration = duration;
            this.runnable = runnable;
        }

        @JmxAttribute(name="duration(\u03bcs)")
        public long getDuration() {
            return this.duration;
        }

        @JmxAttribute
        public String getClassName() {
            return this.runnable == null ? "" : this.runnable.getClass().getName();
        }

        @Override
        public void add(DurationRunnable another) {
            if (another.duration > this.duration) {
                this.duration = another.duration;
                this.runnable = another.runnable;
            }
        }
    }

    private static final class StackTrace {
        private final StackTraceElement[] stackTraceElements;

        public StackTrace(StackTraceElement[] stackTraceElements) {
            this.stackTraceElements = stackTraceElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StackTrace)) {
                return false;
            }
            StackTrace that = (StackTrace)o;
            return Arrays.equals(this.stackTraceElements, that.stackTraceElements);
        }

        public int hashCode() {
            return this.stackTraceElements != null ? Arrays.hashCode(this.stackTraceElements) : 0;
        }
    }

    private static interface Count {
        public int getCount();
    }

    public static final class Keys {
        private final EventStats all = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        private final EventStats invalid = EventStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW);
        private final ValueStats acceptPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats connectPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats readPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats writePerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats loopTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats oneKeyTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);

        @JmxAttribute
        public EventStats getAll() {
            return this.all;
        }

        @JmxAttribute
        public EventStats getInvalid() {
            return this.invalid;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getAcceptPerLoop() {
            return this.acceptPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getConnectPerLoop() {
            return this.connectPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getReadPerLoop() {
            return this.readPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getWritePerLoop() {
            return this.writePerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getLoopTime() {
            return this.loopTime;
        }

        @JmxAttribute(name="oneKeyTime(\u03bcs)", extraSubAttributes={"histogram"})
        public ValueStats getOneKeyTime() {
            return this.oneKeyTime;
        }
    }

    public static final class ScheduledTaskStats
    extends TaskStats {
        private final ValueStats overdues = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);

        public ScheduledTaskStats(Count count) {
            super(count);
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOverdues() {
            return this.overdues;
        }
    }

    public static class TaskStats {
        private final ValueStats tasksPerLoop = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats loopTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final ValueStats oneTaskTime = ValueStats.create(Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(ValueStats.POWERS_OF_TWO);
        private final DurationRunnable longestTask = new DurationRunnable();
        private final Count count;

        public TaskStats(Count count) {
            this.count = count;
        }

        @JmxAttribute(name="perLoop", extraSubAttributes={"histogram"})
        public ValueStats getTasksPerLoop() {
            return this.tasksPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getLoopTime() {
            return this.loopTime;
        }

        @JmxAttribute(name="oneTaskTime(\u03bcs)", extraSubAttributes={"histogram"})
        public ValueStats getOneTaskTime() {
            return this.oneTaskTime;
        }

        @JmxAttribute
        public DurationRunnable getLongestTask() {
            return this.longestTask;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getCount() {
            return this.count.getCount();
        }
    }

    public static final class Tasks {
        private final TaskStats local = new TaskStats(extraStatsExtractor::getLocalTasksCount);
        private final TaskStats concurrent = new TaskStats(extraStatsExtractor::getConcurrentTasksCount);
        private final ScheduledTaskStats scheduled = new ScheduledTaskStats(extraStatsExtractor::getScheduledTasksCount);
        private final ScheduledTaskStats background = new ScheduledTaskStats(extraStatsExtractor::getBackgroundTasksCount);

        public Tasks(Eventloop.ExtraStatsExtractor extraStatsExtractor) {
        }

        @JmxAttribute
        public TaskStats getLocal() {
            return this.local;
        }

        @JmxAttribute
        public TaskStats getConcurrent() {
            return this.concurrent;
        }

        @JmxAttribute
        public ScheduledTaskStats getScheduled() {
            return this.scheduled;
        }

        @JmxAttribute
        public ScheduledTaskStats getBackground() {
            return this.background;
        }
    }
}

