/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.eventloop.FatalErrorHandler;
import java.io.IOError;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipError;

public final class FatalErrorHandlers {
    private FatalErrorHandlers() {
    }

    public static FatalErrorHandler ignoreAllErrors() {
        return (error, context) -> {};
    }

    public static FatalErrorHandler exitOnAnyError() {
        return (error, context) -> FatalErrorHandlers.shutdownForcibly();
    }

    public static FatalErrorHandler exitOnMatchedError(List<Class> whiteList, List<Class> blackList) {
        return (error, context) -> {
            if (FatalErrorHandlers.matchesAny(error.getClass(), whiteList) && !FatalErrorHandlers.matchesAny(error.getClass(), blackList)) {
                FatalErrorHandlers.shutdownForcibly();
            }
        };
    }

    public static FatalErrorHandler exitOnJvmError() {
        return FatalErrorHandlers.exitOnMatchedError(Collections.singletonList(Error.class), Arrays.asList(AssertionError.class, StackOverflowError.class, IOError.class, ZipError.class));
    }

    public static FatalErrorHandler rethrowOnAnyError() {
        return (error, context) -> FatalErrorHandlers.propagate(error);
    }

    public static FatalErrorHandler rethrowOnMatchedError(List<Class> whiteList, List<Class> blackList) {
        return (error, context) -> {
            if (FatalErrorHandlers.matchesAny(error.getClass(), whiteList) && !FatalErrorHandlers.matchesAny(error.getClass(), blackList)) {
                FatalErrorHandlers.propagate(error);
            }
        };
    }

    private static void propagate(Throwable error) {
        if (error instanceof Error) {
            throw (Error)error;
        }
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new RuntimeException(error);
    }

    private static void shutdownForcibly() {
        Runtime.getRuntime().halt(1);
    }

    private static boolean matchesAny(Class c, List<Class> list) {
        return list.stream().anyMatch(cl -> cl.isAssignableFrom(c));
    }
}

