/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.exception.ParseException;
import io.datakernel.util.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class InetAddressRange
implements Comparable<InetAddressRange>,
Iterable<InetAddress> {
    private static final int[] EMPTY_MASK = new int[]{0, 0, 0, 0};
    public static final int[] START = new int[]{0, 0, 0, 0};
    public static final int[] END = new int[]{-1, -1, -1, -1};
    private final int[] network;
    private final int[] mask;
    private final int[] end;
    private boolean acceptAll;

    private InetAddressRange(int[] network, int[] mask, int[] end) {
        this.network = network;
        this.mask = mask;
        this.end = end;
    }

    private InetAddressRange(int[] start, int[] end) {
        this(start, EMPTY_MASK, end);
    }

    private InetAddressRange() {
        this(START, END);
        this.acceptAll = true;
    }

    public static InetAddressRange parse(String s) throws ParseException {
        if (s.equals("*")) {
            return new InetAddressRange();
        }
        int index = s.indexOf(47);
        if (index >= 0) {
            String address = s.substring(0, index);
            try {
                int cidrPrefix = Integer.parseInt(s.substring(index + 1));
                InetAddress inetAddress = InetAddressRange.forString(address);
                if (inetAddress instanceof Inet4Address) {
                    return InetAddressRange.fromCidr((Inet4Address)inetAddress, cidrPrefix);
                }
                return InetAddressRange.fromCidr((Inet6Address)inetAddress, cidrPrefix);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid cidrPrefix");
            }
        }
        index = s.indexOf(45);
        if (index >= 0) {
            InetAddress address1 = InetAddressRange.forString(s.substring(0, index));
            InetAddress address2 = InetAddressRange.forString(s.substring(index + 1));
            if (address1 instanceof Inet4Address && address2 instanceof Inet4Address) {
                return InetAddressRange.fromRange((Inet4Address)address1, (Inet4Address)address2);
            }
            if (address1 instanceof Inet6Address && address2 instanceof Inet6Address) {
                return InetAddressRange.fromRange((Inet6Address)address1, (Inet6Address)address2);
            }
            throw new ParseException("Invalid inet addresses range. You should specify either ipv4 or ipv6");
        }
        return InetAddressRange.fromAddress(InetAddressRange.forString(s));
    }

    public static InetAddressRange all() {
        return new InetAddressRange();
    }

    public static InetAddressRange fromAddressMask(Inet6Address address, Inet6Address mask) throws ParseException {
        return InetAddressRange.fromAddressMask(InetAddressRange.ip2int(address), InetAddressRange.ip2int(mask));
    }

    public static InetAddressRange fromAddressMask(Inet4Address address, Inet4Address mask) throws ParseException {
        return InetAddressRange.fromAddressMask(InetAddressRange.ip2int(address), InetAddressRange.ip2int(mask));
    }

    private static InetAddressRange fromAddressMask(int[] address, int[] mask) throws ParseException {
        if (!InetAddressRange.isValidMask(mask)) {
            throw new ParseException("Invalid mask: " + InetAddressRange.forInteger(mask).toString());
        }
        int[] network = new int[4];
        int[] end = new int[4];
        for (int i = 0; i < 4; ++i) {
            network[i] = address[i] & mask[i];
            end[i] = network[i] | ~mask[i];
        }
        return new InetAddressRange(network, mask, end);
    }

    public static InetAddressRange fromCidr(Inet4Address address, int cidrPrefix) throws ParseException {
        return InetAddressRange.fromCidr(InetAddressRange.ip2int(address), cidrPrefix + 96);
    }

    public static InetAddressRange fromCidr(Inet6Address address, int cidrPrefix) throws ParseException {
        return InetAddressRange.fromCidr(InetAddressRange.ip2int(address), cidrPrefix);
    }

    private static InetAddressRange fromCidr(int[] address, int cidrPrefix) throws ParseException {
        return InetAddressRange.fromAddressMask(address, InetAddressRange.cidrPrefix2mask(cidrPrefix));
    }

    public static InetAddressRange fromRange(Inet4Address start, Inet4Address end) throws ParseException {
        return InetAddressRange.fromRange(InetAddressRange.ip2int(start), InetAddressRange.ip2int(end));
    }

    public static InetAddressRange fromRange(Inet6Address start, Inet6Address end) throws ParseException {
        return InetAddressRange.fromRange(InetAddressRange.ip2int(start), InetAddressRange.ip2int(end));
    }

    private static InetAddressRange fromRange(int[] start, int[] end) throws ParseException {
        if (InetAddressRange.compareBitsArrays(start, end) > 0) {
            throw new IllegalArgumentException("Invalid range: " + InetAddressRange.forInteger(start) + " > " + InetAddressRange.forInteger(end));
        }
        int[] mask = InetAddressRange.range2mask(start, end);
        if (InetAddressRange.isValidMask(mask)) {
            InetAddressRange inetAddressRange = InetAddressRange.fromAddressMask(start, mask);
            if (start == inetAddressRange.network && end == inetAddressRange.end) {
                return inetAddressRange;
            }
        }
        return new InetAddressRange(start, end);
    }

    public static InetAddressRange fromAddress(InetAddress address) {
        return InetAddressRange.fromAddress(InetAddressRange.ip2int(address));
    }

    private static InetAddressRange fromAddress(int[] address) {
        return new InetAddressRange(address, address);
    }

    public InetAddress getStartAddress() {
        try {
            return InetAddressRange.forInteger(this.network);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Start address is not valid", e);
        }
    }

    public InetAddress getEndAddress() {
        try {
            return InetAddressRange.forInteger(this.end);
        }
        catch (ParseException e) {
            throw new IllegalStateException("End address is not valid", e);
        }
    }

    public InetAddress getMaskAddress() {
        Preconditions.check((boolean)this.isSubnet(), (Object)"IpRange is not subnet");
        try {
            return InetAddressRange.forInteger(this.mask);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Mask is not valid");
        }
    }

    public InetAddress getNetworkAddress() {
        try {
            Preconditions.check((boolean)this.isSubnet(), (Object)"IpRange is not subnet");
            return InetAddressRange.forInteger(this.network);
        }
        catch (ParseException e) {
            throw new IllegalStateException("network address is not valid");
        }
    }

    public int getCidrPrefix() {
        Preconditions.check((boolean)this.isSubnet(), (Object)"IpRange is not subnet");
        return InetAddressRange.pop(this.mask);
    }

    public boolean contains(InetAddress address) {
        return this.contains(InetAddressRange.ip2int(address));
    }

    private boolean contains(int[] address) {
        return this.acceptAll || InetAddressRange.compareBitsArrays(address, this.network) >= 0 && InetAddressRange.compareBitsArrays(address, this.end) <= 0;
    }

    public boolean isSubnet() {
        return !Arrays.equals(this.mask, EMPTY_MASK);
    }

    public boolean isSingle() {
        return Arrays.equals(this.network, this.end);
    }

    private static InetAddress forString(String s) throws ParseException {
        try {
            return InetAddress.getByName(s);
        }
        catch (UnknownHostException e) {
            throw new ParseException("Invalid network supplied", (Throwable)e);
        }
    }

    private static InetAddress forInteger(int[] network) throws ParseException {
        try {
            return InetAddress.getByAddress(InetAddressRange.toByteArray(network));
        }
        catch (UnknownHostException e) {
            throw new ParseException("Invalid network supplied", (Throwable)e);
        }
    }

    private static int[] cidrPrefix2mask(int cidrPrefix) throws ParseException {
        if (cidrPrefix <= 0 || cidrPrefix > 128) {
            throw new ParseException("Invalid cidrPrefix " + cidrPrefix);
        }
        int pos = 0;
        int[] mask = new int[4];
        while (cidrPrefix > 32) {
            mask[pos++] = -1;
            cidrPrefix -= 32;
        }
        for (int j = 0; j < cidrPrefix; ++j) {
            int n = pos;
            mask[n] = mask[n] | 1 << 31 - j;
        }
        return mask;
    }

    private static int[] ip2int(InetAddress address) {
        if (address instanceof Inet4Address) {
            return new int[]{0, 0, 0, address.hashCode()};
        }
        return InetAddressRange.fromByteArray(address.getAddress());
    }

    private static int[] range2mask(int[] low, int[] high) {
        int[] mask = new int[4];
        for (int i = 0; i < 4; ++i) {
            mask[i] = ~(low[i] ^ high[i]);
        }
        return mask;
    }

    private static boolean isValidMask(int[] mask) {
        int i;
        int[] m = new int[4];
        for (i = 0; i < 4; ++i) {
            m[i] = ~mask[i];
        }
        mask = InetAddressRange.inc(m);
        for (i = 0; i < 4; ++i) {
            if ((m[i] & mask[i]) == 0) continue;
            return false;
        }
        return true;
    }

    private static int[] inc(int[] arr) {
        int[] res = new int[arr.length];
        int val = 1;
        for (int i = arr.length - 1; i >= 0; --i) {
            if (val != 0 && arr[i] == -1) {
                res[i] = 0;
                continue;
            }
            if (val != 0) {
                res[i] = arr[i] + val;
                val = 0;
                continue;
            }
            res[i] = arr[i];
        }
        return res;
    }

    private static int compareBitsArrays(int[] start, int[] end) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 31; j >= 0; --j) {
                int mask = 1 << j;
                if ((start[i] & mask) == (end[i] & mask)) continue;
                if ((start[i] & mask) >> j == 1) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private static int pop(int[] arr) {
        int num = 0;
        for (int x : arr) {
            num += InetAddressRange.pop(x);
        }
        return num;
    }

    private static int pop(int x) {
        x -= x >>> 1 & 0x55555555;
        x = (x & 0x33333333) + (x >>> 2 & 0x33333333);
        x = x + (x >>> 4) & 0xF0F0F0F;
        x += x >>> 8;
        x += x >>> 16;
        return x & 0x3F;
    }

    private static int[] fromByteArray(byte[] address) {
        int[] ints = new int[4];
        for (int i = 0; i < 4; ++i) {
            ints[i] = (address[i * 4] & 0xFF) << 24;
            int n = i;
            ints[n] = ints[n] | (address[i * 4 + 1] & 0xFF) << 16;
            int n2 = i;
            ints[n2] = ints[n2] | (address[i * 4 + 2] & 0xFF) << 8;
            int n3 = i;
            ints[n3] = ints[n3] | address[i * 4 + 3] & 0xFF;
        }
        return ints;
    }

    private static byte[] toByteArray(int[] ints) {
        byte[] res = new byte[16];
        for (int i = 0; i < ints.length; ++i) {
            InetAddressRange.toByteArray(res, 4 * i, ints[i]);
        }
        return res;
    }

    private static void toByteArray(byte[] bytes, int pos, int val) {
        bytes[pos] = (byte)((val & 0xFF000000) >> 24);
        bytes[pos + 1] = (byte)((val & 0xFF0000) >> 16);
        bytes[pos + 2] = (byte)((val & 0xFF00) >> 8);
        bytes[pos + 3] = (byte)(val & 0xFF);
    }

    public String toString() {
        if (this.isSingle()) {
            return this.getStartAddress().toString();
        }
        return this.isSubnet() ? this.toCidrString() : this.toRangeString();
    }

    public String toCidrString() {
        return this.getNetworkAddress().toString() + "/" + InetAddressRange.pop(this.mask);
    }

    public String toRangeString() {
        return this.getStartAddress().toString() + "-" + this.getEndAddress().toString();
    }

    public int hashCode() {
        int hash = 31;
        for (int i = 0; i < this.network.length; ++i) {
            hash += 31 * this.network[i] + this.end[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InetAddressRange o = (InetAddressRange)obj;
        return Arrays.equals(this.network, o.network) && Arrays.equals(this.end, o.end);
    }

    @Override
    public int compareTo(InetAddressRange o) {
        int c = InetAddressRange.compareBitsArrays(this.network, o.network);
        if (c != 0) {
            return c;
        }
        return InetAddressRange.compareBitsArrays(this.end, o.end);
    }

    @Override
    public Iterator<InetAddress> iterator() {
        return new InetAddressIterator(this.network, this.end);
    }

    private static class InetAddressIterator
    implements Iterator<InetAddress> {
        private int[] current;
        private final int[] end;

        InetAddressIterator(int[] start, int[] end) {
            this.current = start;
            this.end = InetAddressRange.inc(end);
        }

        @Override
        public boolean hasNext() {
            return InetAddressRange.compareBitsArrays(this.current, this.end) < 0;
        }

        @Override
        public InetAddress next() throws NoSuchElementException {
            if (InetAddressRange.compareBitsArrays(this.current, this.end) == 0) {
                throw new NoSuchElementException();
            }
            try {
                return InetAddress.getByAddress(InetAddressRange.toByteArray(this.current));
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)"Should not ever get here");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }
}

