/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.eventloop.AbstractServer;
import io.datakernel.eventloop.AsyncTcpSocket;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.WorkerServer;
import io.datakernel.util.Initializable;
import java.util.List;

public final class PrimaryServer
extends AbstractServer<PrimaryServer>
implements Initializable<PrimaryServer> {
    private final WorkerServer[] workerServers;
    private int currentAcceptor = -1;

    private PrimaryServer(Eventloop primaryEventloop, WorkerServer[] workerServers) {
        super(primaryEventloop);
        this.workerServers = workerServers;
        for (WorkerServer workerServer : workerServers) {
            if (!(workerServer instanceof AbstractServer)) continue;
            ((AbstractServer)workerServer).acceptServer = this;
        }
    }

    public static PrimaryServer create(Eventloop primaryEventloop, List<? extends WorkerServer> workerServers) {
        return PrimaryServer.create(primaryEventloop, workerServers.toArray(new WorkerServer[workerServers.size()]));
    }

    public static PrimaryServer create(Eventloop primaryEventloop, WorkerServer ... workerServer) {
        return new PrimaryServer(primaryEventloop, workerServer);
    }

    @Override
    protected AsyncTcpSocket.EventHandler createSocketHandler(AsyncTcpSocket asyncTcpSocket) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected WorkerServer getWorkerServer() {
        this.currentAcceptor = (this.currentAcceptor + 1) % this.workerServers.length;
        return this.workerServers[this.currentAcceptor];
    }
}

