/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.async.AsyncCancellable;

public final class ScheduledRunnable
implements Comparable<ScheduledRunnable>,
AsyncCancellable {
    private final long timestamp;
    private Runnable runnable;
    private boolean cancelled;
    private boolean complete;

    private ScheduledRunnable(long timestamp, Runnable runnable) {
        this.timestamp = timestamp;
        this.runnable = runnable;
    }

    public static ScheduledRunnable create(long timestamp, Runnable runnable) {
        return new ScheduledRunnable(timestamp, runnable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledRunnable that = (ScheduledRunnable)o;
        return this.timestamp == that.timestamp;
    }

    public int hashCode() {
        return (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    @Override
    public int compareTo(ScheduledRunnable o) {
        return Long.compare(this.timestamp, o.timestamp);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.runnable = null;
    }

    public void complete() {
        this.complete = true;
        this.runnable = null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{timestamp=" + this.timestamp + ", cancelled=" + this.cancelled + ", complete=" + this.complete + ", runnable=" + this.runnable + "}";
    }
}

