/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.eventloop;

import io.datakernel.eventloop.Eventloop;
import io.datakernel.jmx.EventloopJmxMBean;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxOperation;
import io.datakernel.jmx.JmxReducers;
import io.datakernel.util.Preconditions;
import java.time.Duration;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThrottlingController
implements EventloopJmxMBean {
    private static int staticInstanceCounter = 0;
    private final Logger logger = LoggerFactory.getLogger((String)(ThrottlingController.class.getName() + "." + staticInstanceCounter++));
    public static final Duration TARGET_TIME = Duration.ofMillis(20L);
    public static final Duration GC_TIME = Duration.ofMillis(20L);
    public static final Duration SMOOTHING_WINDOW = Duration.ofSeconds(10L);
    public static final double THROTTLING_DECREASE = 0.1;
    public static final double INITIAL_KEYS_PER_SECOND = 100.0;
    public static final double INITIAL_THROTTLING = 0.0;
    private static final Random random = new Random(){
        private long prev = System.nanoTime();

        @Override
        protected int next(int nbits) {
            long x = this.prev;
            x ^= x << 21;
            x ^= x >>> 35;
            x ^= x << 4;
            this.prev = x;
            return (int)(x &= (1L << nbits) - 1L);
        }
    };
    private Eventloop eventloop;
    private int targetTimeMillis;
    private int gcTimeMillis;
    private double throttlingDecrease;
    private int smoothingWindow;
    private int bufferedRequests;
    private int bufferedRequestsThrottled;
    private double smoothedThrottling;
    private double smoothedTimePerKeyMillis;
    private long infoTotalRequests;
    private long infoTotalRequestsThrottled;
    private long infoTotalTimeMillis;
    private long infoRounds;
    private long infoRoundsZeroThrottling;
    private long infoRoundsExceededTargetTime;
    private long infoRoundsGc;
    private float throttling;

    private ThrottlingController() {
    }

    public static ThrottlingController create() {
        return new ThrottlingController().withTargetTime(TARGET_TIME).withGcTime(GC_TIME).withSmoothingWindow(SMOOTHING_WINDOW).withThrottlingDecrease(0.1).withInitialKeysPerSecond(100.0).withInitialThrottling(0.0);
    }

    public ThrottlingController withTargetTime(Duration targetTime) {
        this.setTargetTimeMillis(targetTime);
        return this;
    }

    public ThrottlingController withGcTime(Duration gcTime) {
        this.setGcTimeMillis(gcTime);
        return this;
    }

    public ThrottlingController withSmoothingWindow(Duration smoothingWindow) {
        this.setSmoothingWindow(smoothingWindow);
        return this;
    }

    public ThrottlingController withThrottlingDecrease(double throttlingDecrease) {
        this.setThrottlingDecrease(throttlingDecrease);
        return this;
    }

    public ThrottlingController withInitialKeysPerSecond(double initialKeysPerSecond) {
        Preconditions.checkArgument((initialKeysPerSecond > 0.0 ? 1 : 0) != 0, (Object)"Initial keys per second should not be zero or less");
        this.smoothedTimePerKeyMillis = 1000.0 / initialKeysPerSecond;
        return this;
    }

    public ThrottlingController withInitialThrottling(double initialThrottling) {
        Preconditions.checkArgument((initialThrottling >= 0.0 ? 1 : 0) != 0, (Object)"Initial throttling should not be zero or less");
        this.smoothedThrottling = initialThrottling;
        return this;
    }

    public boolean isOverloaded() {
        ++this.bufferedRequests;
        if (random.nextFloat() < this.throttling) {
            ++this.bufferedRequestsThrottled;
            return true;
        }
        return false;
    }

    void updateInternalStats(int lastKeys, int lastTime) {
        double value;
        if (lastTime < 0 || lastTime > 60000) {
            this.logger.warn("Invalid processing time: {}", (Object)lastTime);
            return;
        }
        int lastTimePredicted = (int)((double)lastKeys * this.getAvgTimePerKeyMillis());
        if ((double)this.gcTimeMillis != 0.0 && lastTime > lastTimePredicted + this.gcTimeMillis) {
            this.logger.debug("GC detected {} ms, {} keys", (Object)lastTime, (Object)lastKeys);
            lastTime = lastTimePredicted + this.gcTimeMillis;
            ++this.infoRoundsGc;
        }
        double weight = 1.0 - 1.0 / (double)this.smoothingWindow;
        if (this.bufferedRequests != 0) {
            assert (this.bufferedRequestsThrottled <= this.bufferedRequests);
            value = (double)this.bufferedRequestsThrottled / (double)this.bufferedRequests;
            this.smoothedThrottling = (this.smoothedThrottling - value) * Math.pow(weight, this.bufferedRequests) + value;
            this.infoTotalRequests += (long)this.bufferedRequests;
            this.infoTotalRequestsThrottled += (long)this.bufferedRequestsThrottled;
            this.bufferedRequests = 0;
            this.bufferedRequestsThrottled = 0;
        }
        if (lastKeys != 0) {
            value = (double)lastTime / (double)lastKeys;
            this.smoothedTimePerKeyMillis = (this.smoothedTimePerKeyMillis - value) * Math.pow(weight, lastKeys) + value;
        }
        this.infoTotalTimeMillis += (long)lastTime;
    }

    void calculateThrottling(int newKeys) {
        double extraThrottling;
        double predictedTime = (double)newKeys * this.getAvgTimePerKeyMillis();
        double newThrottling = this.getAvgThrottling() - this.throttlingDecrease;
        if (newThrottling < 0.0) {
            newThrottling = 0.0;
        }
        if (predictedTime > (double)this.targetTimeMillis && (extraThrottling = 1.0 - (double)this.targetTimeMillis / predictedTime) > newThrottling) {
            newThrottling = extraThrottling;
            ++this.infoRoundsExceededTargetTime;
        }
        if (newThrottling == 0.0) {
            ++this.infoRoundsZeroThrottling;
        }
        ++this.infoRounds;
        this.throttling = (float)newThrottling;
    }

    public double getAvgTimePerKeyMillis() {
        return this.smoothedTimePerKeyMillis;
    }

    @JmxAttribute
    public double getAvgKeysPerSecond() {
        return 1000.0 / this.getAvgTimePerKeyMillis();
    }

    @JmxAttribute
    public double getAvgThrottling() {
        return this.smoothedThrottling;
    }

    @JmxAttribute
    public Duration getTargetTimeMillis() {
        return Duration.ofMillis(this.targetTimeMillis);
    }

    @JmxAttribute
    public void setTargetTimeMillis(Duration targetTime) {
        Preconditions.checkArgument((targetTime.toMillis() > 0L ? 1 : 0) != 0, (Object)"Target time should not be zero or less");
        this.targetTimeMillis = (int)targetTime.toMillis();
    }

    @JmxAttribute
    public Duration getGcTimeMillis() {
        return Duration.ofMillis(this.gcTimeMillis);
    }

    @JmxAttribute
    public void setGcTimeMillis(Duration gcTime) {
        Preconditions.checkArgument((gcTime.toMillis() > 0L ? 1 : 0) != 0, (Object)"GC time should not be zero or less");
        this.gcTimeMillis = (int)gcTime.toMillis();
    }

    @JmxAttribute
    public double getThrottlingDecrease() {
        return this.throttlingDecrease;
    }

    @JmxAttribute
    public void setThrottlingDecrease(double throttlingDecrease) {
        Preconditions.checkArgument((throttlingDecrease >= 0.0 && throttlingDecrease <= 1.0 ? 1 : 0) != 0, (Object)"Throttling decrease should not fall out of [0;1] range");
        this.throttlingDecrease = throttlingDecrease;
    }

    @JmxAttribute
    public Duration getSmoothingWindow() {
        return Duration.ofMillis(this.smoothingWindow);
    }

    @JmxAttribute
    public void setSmoothingWindow(Duration smoothingWindow) {
        Preconditions.checkArgument((smoothingWindow.toMillis() > 0L ? 1 : 0) != 0, (Object)"Smoothing window should not be zero or less");
        this.smoothingWindow = (int)smoothingWindow.toMillis();
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalRequests() {
        return this.infoTotalRequests;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalRequestsThrottled() {
        return this.infoTotalRequestsThrottled;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalProcessed() {
        return this.infoTotalRequests - this.infoTotalRequestsThrottled;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getTotalTimeMillis() {
        return this.infoTotalTimeMillis;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getRounds() {
        return this.infoRounds;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getRoundsZeroThrottling() {
        return this.infoRoundsZeroThrottling;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getRoundsExceededTargetTime() {
        return this.infoRoundsExceededTargetTime;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getInfoRoundsGc() {
        return this.infoRoundsGc;
    }

    @JmxAttribute
    public double getThrottling() {
        return this.throttling;
    }

    @JmxOperation
    public void resetInfo() {
        this.infoTotalRequests = 0L;
        this.infoTotalRequestsThrottled = 0L;
        this.infoTotalTimeMillis = 0L;
        this.infoRounds = 0L;
        this.infoRoundsZeroThrottling = 0L;
        this.infoRoundsExceededTargetTime = 0L;
    }

    public String toString() {
        return String.format("{throttling:%2d%% avgKps=%-4d avgThrottling=%2d%% requests=%-4d throttled=%-4d rounds=%-3d zero=%-3d >targetTime=%-3d}", (int)(this.throttling * 100.0f), (int)this.getAvgKeysPerSecond(), (int)(this.getAvgThrottling() * 100.0), this.infoTotalRequests, this.infoTotalRequestsThrottled, this.infoRounds, this.infoRoundsZeroThrottling, this.infoRoundsExceededTargetTime);
    }

    void setEventloop(Eventloop eventloop) {
        this.eventloop = eventloop;
    }

    @Override
    public Eventloop getEventloop() {
        return this.eventloop;
    }
}

