/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.file;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.SettableStage;
import io.datakernel.async.Stage;
import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufPool;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public final class AsyncFile {
    private final Eventloop eventloop = Eventloop.getCurrentEventloop();
    private final ExecutorService executor;
    private final AsynchronousFileChannel channel;
    private final Path path;

    private AsyncFile(ExecutorService executor, AsynchronousFileChannel channel, Path path) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.channel = (AsynchronousFileChannel)Preconditions.checkNotNull((Object)channel);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
    }

    public static AsyncFile open(ExecutorService executor, Path path, OpenOption[] openOptions) throws IOException {
        AsynchronousFileChannel channel = AsyncFile.doOpenChannel(executor, path, openOptions);
        return new AsyncFile(executor, channel, path);
    }

    public static Stage<AsyncFile> openAsync(ExecutorService executor, Path path, OpenOption[] openOptions) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        return Stage.ofCallable(executor, () -> AsyncFile.doOpenChannel(executor, path, openOptions)).thenApply(channel -> new AsyncFile(executor, (AsynchronousFileChannel)channel, path));
    }

    private static AsynchronousFileChannel doOpenChannel(ExecutorService executor, Path path, OpenOption[] openOptions) throws IOException {
        return AsynchronousFileChannel.open(path, new HashSet<OpenOption>(Arrays.asList(openOptions)), executor, new FileAttribute[0]);
    }

    public static Stage<Void> delete(ExecutorService executor, Path path) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        return Stage.ofCallable(executor, () -> {
            Files.delete(path);
            return null;
        });
    }

    public static Stage<Long> size(ExecutorService executor, Path path) {
        Eventloop eventloop = Eventloop.getCurrentEventloop();
        return Stage.ofCallable(executor, () -> Files.isRegularFile(path, new LinkOption[0]) ? Files.size(path) : -1L);
    }

    public static Stage<Void> move(Eventloop eventloop, ExecutorService executor, Path source, Path target, CopyOption ... options) {
        return Stage.ofCallable(executor, () -> {
            Files.move(source, target, options);
            return null;
        });
    }

    public static Stage<Void> createDirectory(Eventloop eventloop, ExecutorService executor, Path dir, @Nullable FileAttribute<?>[] attrs) {
        return Stage.ofCallable(executor, () -> {
            Files.createDirectory(dir, attrs == null ? new FileAttribute[]{} : attrs);
            return null;
        });
    }

    public static Stage<Void> createDirectories(Eventloop eventloop, ExecutorService executor, Path dir, @Nullable FileAttribute<?>[] attrs) {
        return Stage.ofCallable(executor, () -> {
            Files.createDirectories(dir, attrs == null ? new FileAttribute[]{} : attrs);
            return null;
        });
    }

    public static Stage<ByteBuf> readFile(ExecutorService executor, Path path) {
        return AsyncFile.openAsync(executor, path, new OpenOption[]{StandardOpenOption.READ}).thenCompose(file -> file.readFully().whenComplete(($, e) -> file.close()));
    }

    public static Stage<Void> writeNewFile(ExecutorService executor, Path path, ByteBuf buf) {
        return AsyncFile.openAsync(executor, path, new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW}).thenCompose(file -> file.writeFully(buf, 0L).whenComplete(($, throwable) -> buf.recycle()));
    }

    public Stage<Integer> write(final ByteBuf buf, long position) {
        this.eventloop.startExternalTask();
        final ByteBuffer byteBuffer = buf.toReadByteBuffer();
        final SettableStage<Integer> stage = SettableStage.create();
        this.channel.write(byteBuffer, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object $) {
                buf.ofReadByteBuffer(byteBuffer);
                AsyncFile.this.eventloop.execute(() -> {
                    AsyncFile.this.eventloop.completeExternalTask();
                    stage.set(result);
                });
            }

            @Override
            public void failed(Throwable exc, Object $) {
                AsyncFile.this.eventloop.execute(() -> {
                    AsyncFile.this.eventloop.completeExternalTask();
                    stage.setException(exc instanceof Exception ? (Exception)exc : new Exception(exc));
                });
            }
        });
        return stage;
    }

    public Stage<Integer> read(final ByteBuf buf, long position) {
        this.eventloop.startExternalTask();
        final ByteBuffer byteBuffer = buf.toWriteByteBuffer();
        final SettableStage<Integer> stage = SettableStage.create();
        this.channel.read(byteBuffer, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer bytesRead, Object $) {
                buf.ofWriteByteBuffer(byteBuffer);
                AsyncFile.this.eventloop.execute(() -> {
                    AsyncFile.this.eventloop.completeExternalTask();
                    stage.set(bytesRead);
                });
            }

            @Override
            public void failed(Throwable exc, Object $) {
                AsyncFile.this.eventloop.execute(() -> {
                    AsyncFile.this.eventloop.completeExternalTask();
                    stage.setException(exc instanceof Exception ? (Exception)exc : new Exception(exc));
                });
            }
        });
        return stage;
    }

    public Stage<Void> writeFully(final ByteBuf buf, final long position) {
        final ByteBuffer byteBuffer = buf.toReadByteBuffer();
        final SettableStage<Void> stage = SettableStage.create();
        this.eventloop.startExternalTask();
        this.channel.write(byteBuffer, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer writtenBytes, Object $) {
                buf.ofReadByteBuffer(byteBuffer);
                if (buf.readRemaining() == 0) {
                    AsyncFile.this.eventloop.execute(() -> {
                        AsyncFile.this.eventloop.completeExternalTask();
                        buf.recycle();
                        stage.set(null);
                    });
                    return;
                }
                AsyncFile.this.writeFully(buf, position + (long)writtenBytes.intValue()).whenComplete(stage::set);
            }

            @Override
            public void failed(Throwable e, Object $) {
                AsyncFile.this.eventloop.execute(() -> {
                    buf.recycle();
                    AsyncFile.this.eventloop.completeExternalTask();
                    stage.setException(e instanceof Exception ? (Exception)e : new Exception(e));
                });
            }
        });
        return stage;
    }

    public Stage<ByteBuf> readFully() {
        return this.readFully(0L);
    }

    public Stage<ByteBuf> readFully(long position) {
        long size;
        try {
            size = this.channel.size();
        }
        catch (IOException e2) {
            return Stage.ofException(e2);
        }
        ByteBuf buf = ByteBufPool.allocate((int)((int)(size - position)));
        return this.readFully(buf, position, size).whenComplete(($, e) -> {
            if (e != null) {
                buf.recycle();
            }
        }).thenApply($ -> buf);
    }

    public Stage<Void> readFully(ByteBuf buf, long position) {
        long size;
        try {
            size = this.channel.size();
        }
        catch (IOException e) {
            return Stage.ofException(e);
        }
        return this.readFully(buf, position, size);
    }

    private Stage<Void> readFully(final ByteBuf buf, final long position, final long size) {
        final SettableStage<Void> stage = SettableStage.create();
        final ByteBuffer byteBuffer = buf.toWriteByteBuffer();
        this.eventloop.startExternalTask();
        this.channel.read(byteBuffer, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object $) {
                buf.ofWriteByteBuffer(byteBuffer);
                if ((long)buf.readRemaining() == size || result == -1) {
                    AsyncFile.this.eventloop.execute(() -> {
                        AsyncFile.this.eventloop.completeExternalTask();
                        try {
                            AsyncFile.this.channel.close();
                            stage.set(null);
                        }
                        catch (IOException e) {
                            stage.setException(e);
                        }
                    });
                    return;
                }
                AsyncFile.this.readFully(buf, position + (long)result.intValue(), size - (long)result.intValue()).whenComplete(stage::set);
            }

            @Override
            public void failed(Throwable e, Object $) {
                AsyncFile.this.eventloop.execute(() -> {
                    try {
                        AsyncFile.this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    AsyncFile.this.eventloop.completeExternalTask();
                    stage.setException(e instanceof Exception ? (Exception)e : new Exception(e));
                });
            }
        });
        return stage;
    }

    public Stage<Void> forceAndClose(boolean forceMetadata) {
        return Stage.ofCallable(this.executor, () -> {
            this.channel.force(forceMetadata);
            this.channel.close();
            return null;
        });
    }

    public Stage<Void> close() {
        return Stage.ofCallable(this.executor, () -> {
            this.channel.close();
            return null;
        });
    }

    public Stage<Void> truncate(long size) {
        return Stage.ofCallable(this.executor, () -> {
            this.channel.truncate(size);
            return null;
        });
    }

    public Stage<Void> force(boolean metaData) {
        return Stage.ofCallable(this.executor, () -> {
            this.channel.force(metaData);
            return null;
        });
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public AsynchronousFileChannel getChannel() {
        return this.channel;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return this.path.toString();
    }
}

