/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.jmx;

import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxRefreshableStats;
import io.datakernel.jmx.JmxStatsWithReset;
import io.datakernel.jmx.JmxStatsWithSmoothingWindow;
import java.time.Duration;

public final class EventStats
implements JmxRefreshableStats<EventStats>,
JmxStatsWithSmoothingWindow,
JmxStatsWithReset {
    private static final long TOO_LONG_TIME_PERIOD_BETWEEN_REFRESHES = Duration.ofHours(1L).toMillis();
    private static final double LN_2 = Math.log(2.0);
    private long lastTimestampMillis;
    private int lastCount;
    private long totalCount;
    private double smoothedCount;
    private double smoothedTimeSeconds;
    private double smoothedRate;
    private double smoothingWindow;
    private double smoothingWindowCoef;
    private int addedStats;

    private EventStats(double smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
        this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(smoothingWindow);
    }

    private EventStats() {
        this.smoothingWindow = -1.0;
        this.smoothingWindowCoef = -1.0;
    }

    public static EventStats createAccumulator() {
        return new EventStats();
    }

    public static EventStats create(Duration smoothingWindow) {
        return new EventStats((double)smoothingWindow.toMillis() / 1000.0);
    }

    private static double calculateSmoothingWindowCoef(double smoothingWindow) {
        return -(LN_2 / smoothingWindow);
    }

    @Override
    public void resetStats() {
        this.lastCount = 0;
        this.totalCount = 0L;
        this.lastTimestampMillis = 0L;
        this.smoothedCount = 0.0;
        this.smoothedRate = 0.0;
        this.smoothedTimeSeconds = 0.0;
    }

    public void recordEvent() {
        ++this.lastCount;
    }

    public void recordEvents(int events) {
        this.lastCount += events;
    }

    @Override
    public void refresh(long timestamp) {
        long timeElapsedMillis = timestamp - this.lastTimestampMillis;
        if (EventStats.isTimePeriodValid(timeElapsedMillis)) {
            double timeElapsedSeconds = (double)timeElapsedMillis * 0.001;
            double smoothingFactor = Math.exp(timeElapsedSeconds * this.smoothingWindowCoef);
            this.smoothedCount = (double)this.lastCount + this.smoothedCount * smoothingFactor;
            this.smoothedTimeSeconds = timeElapsedSeconds + this.smoothedTimeSeconds * smoothingFactor;
            this.smoothedRate = this.smoothedCount / this.smoothedTimeSeconds;
        }
        this.totalCount += (long)this.lastCount;
        this.lastCount = 0;
        this.lastTimestampMillis = timestamp;
    }

    private static boolean isTimePeriodValid(long timePeriod) {
        return timePeriod < TOO_LONG_TIME_PERIOD_BETWEEN_REFRESHES && timePeriod > 0L;
    }

    @Override
    public void add(EventStats anotherStats) {
        this.totalCount += anotherStats.totalCount;
        this.smoothedCount += anotherStats.smoothedCount;
        this.smoothedRate += anotherStats.smoothedRate;
        if (this.addedStats == 0) {
            this.smoothingWindow = anotherStats.smoothingWindow;
            this.smoothingWindowCoef = anotherStats.smoothingWindowCoef;
        } else if (this.smoothingWindow != anotherStats.smoothingWindow) {
            this.smoothingWindow = -1.0;
            this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(this.smoothingWindow);
        }
        ++this.addedStats;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedRate() {
        return this.smoothedRate;
    }

    @JmxAttribute(optional=true)
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    @JmxAttribute(optional=true)
    public Duration getSmoothingWindow() {
        return Duration.ofMillis((long)(this.smoothingWindow * 1000.0));
    }

    @Override
    @JmxAttribute(optional=true)
    public void setSmoothingWindow(Duration smoothingWindow) {
        this.smoothingWindow = (double)smoothingWindow.toMillis() / 1000.0;
        this.smoothingWindowCoef = EventStats.calculateSmoothingWindowCoef(this.smoothingWindow);
    }

    @JmxAttribute
    public String get() {
        return this.toString();
    }

    public String toString() {
        if (this.getTotalCount() == 0L) {
            return null;
        }
        return String.format("%d @ %.3f/s", this.getTotalCount(), this.getSmoothedRate());
    }
}

