/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.jmx;

import io.datakernel.annotation.Nullable;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxStats;
import io.datakernel.jmx.JmxStatsWithReset;
import io.datakernel.jmx.MBeanFormat;
import java.time.Instant;
import java.util.List;

public final class ExceptionStats
implements JmxStats<ExceptionStats>,
JmxStatsWithReset {
    private static final long DETAILS_REFRESH_TIMEOUT = 1000L;
    private Class<? extends Throwable> exceptionClass;
    private int count;
    private long lastExceptionTimestamp;
    private Throwable throwable;
    private Object context;

    private ExceptionStats() {
    }

    public static ExceptionStats create() {
        return new ExceptionStats();
    }

    public void recordException(Throwable throwable, Object context) {
        ++this.count;
        long now = System.currentTimeMillis();
        if (now >= this.lastExceptionTimestamp + 1000L) {
            this.exceptionClass = throwable != null ? throwable.getClass() : null;
            this.throwable = throwable;
            this.context = context;
            this.lastExceptionTimestamp = now;
        }
    }

    public void recordException(Throwable throwable) {
        this.recordException(throwable, null);
    }

    @Override
    public void resetStats() {
        this.count = 0;
        this.lastExceptionTimestamp = 0L;
        this.exceptionClass = null;
        this.throwable = null;
        this.context = null;
    }

    @Override
    public void add(ExceptionStats another) {
        this.count += another.count;
        if (another.lastExceptionTimestamp >= this.lastExceptionTimestamp) {
            this.lastExceptionTimestamp = another.lastExceptionTimestamp;
            this.exceptionClass = another.exceptionClass;
            this.throwable = another.throwable;
            this.context = another.context;
        }
    }

    @JmxAttribute(optional=true)
    public int getTotal() {
        return this.count;
    }

    @JmxAttribute(optional=true)
    public String getLastType() {
        return this.exceptionClass != null ? this.exceptionClass.toString() : null;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public Instant getLastTime() {
        return this.lastExceptionTimestamp != 0L ? Instant.ofEpochMilli(this.lastExceptionTimestamp) : null;
    }

    @JmxAttribute(optional=true)
    public Throwable getLastException() {
        return this.throwable;
    }

    @JmxAttribute(optional=true)
    public String getLastMessage() {
        return this.throwable != null ? this.throwable.getMessage() : null;
    }

    @JmxAttribute
    public String getMultilineError() {
        if (this.count == 0) {
            return "";
        }
        StringBuilder summary = new StringBuilder("Count: " + this.count + " " + MBeanFormat.formatTimestamp(this.lastExceptionTimestamp));
        if (this.throwable != null) {
            summary.append("\nStack Trace: ");
            summary.append(MBeanFormat.formatExceptionMultiline(this.throwable).trim());
        }
        if (this.context != null) {
            summary.append("\nContext: ");
            summary.append(this.context.toString());
        }
        return summary.toString();
    }

    @JmxAttribute
    public List<String> getError() {
        return MBeanFormat.formatMultilineStringAsList(this.getMultilineError());
    }

    public String toString() {
        String last = "";
        if (this.exceptionClass != null) {
            last = "; " + this.exceptionClass.getSimpleName();
            last = last + " @" + MBeanFormat.formatTimestamp(this.lastExceptionTimestamp);
        }
        return Integer.toString(this.count) + last;
    }
}

