/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.jmx;

import io.datakernel.jmx.JmxReducer;
import io.datakernel.util.JmxUtils;
import java.util.List;
import java.util.Objects;

public final class JmxReducers {
    private JmxReducers() {
    }

    private static boolean isFloatingPointNumber(Class<?> numberClass) {
        return Float.class.isAssignableFrom(numberClass) || Double.class.isAssignableFrom(numberClass);
    }

    private static boolean isIntegerNumber(Class<?> numberClass) {
        return Byte.class.isAssignableFrom(numberClass) || Short.class.isAssignableFrom(numberClass) || Integer.class.isAssignableFrom(numberClass) || Long.class.isAssignableFrom(numberClass);
    }

    private static Number convert(Number number, Class<?> targetClass) {
        if (Byte.class.isAssignableFrom(targetClass)) {
            return number.byteValue();
        }
        if (Short.class.isAssignableFrom(targetClass)) {
            return number.shortValue();
        }
        if (Integer.class.isAssignableFrom(targetClass)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(targetClass)) {
            return number.longValue();
        }
        if (Float.class.isAssignableFrom(targetClass)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(targetClass)) {
            return number.doubleValue();
        }
        throw new IllegalArgumentException("target class is not a number class");
    }

    public static final class JmxReducerMax
    implements JmxReducer<Number> {
        @Override
        public Number reduce(List<? extends Number> input) {
            List inputListWithoutNulls = JmxUtils.filterNulls(input);
            if (inputListWithoutNulls.size() == 0) {
                return null;
            }
            Number first = (Number)inputListWithoutNulls.get(0);
            Class<?> numberClass = first.getClass();
            if (JmxReducers.isFloatingPointNumber(numberClass)) {
                double floatingPointMax = first.doubleValue();
                for (int i = 1; i < inputListWithoutNulls.size(); ++i) {
                    double currentValue = ((Number)inputListWithoutNulls.get(i)).doubleValue();
                    if (!(currentValue > floatingPointMax)) continue;
                    floatingPointMax = currentValue;
                }
                return JmxReducers.convert(floatingPointMax, numberClass);
            }
            if (JmxReducers.isIntegerNumber(numberClass)) {
                long integerMax = first.longValue();
                for (int i = 1; i < inputListWithoutNulls.size(); ++i) {
                    long currentValue = ((Number)inputListWithoutNulls.get(i)).longValue();
                    if (currentValue <= integerMax) continue;
                    integerMax = currentValue;
                }
                return JmxReducers.convert(integerMax, numberClass);
            }
            throw new IllegalArgumentException("Cannot calculate max of objects of type: " + first.getClass().getName());
        }
    }

    public static final class JmxReducerMin
    implements JmxReducer<Number> {
        @Override
        public Number reduce(List<? extends Number> input) {
            List inputListWithoutNulls = JmxUtils.filterNulls(input);
            if (inputListWithoutNulls.size() == 0) {
                return null;
            }
            Number first = (Number)inputListWithoutNulls.get(0);
            Class<?> numberClass = first.getClass();
            if (JmxReducers.isFloatingPointNumber(numberClass)) {
                double floatingPointMin = first.doubleValue();
                for (int i = 1; i < inputListWithoutNulls.size(); ++i) {
                    double currentValue = ((Number)inputListWithoutNulls.get(i)).doubleValue();
                    if (!(currentValue < floatingPointMin)) continue;
                    floatingPointMin = currentValue;
                }
                return JmxReducers.convert(floatingPointMin, numberClass);
            }
            if (JmxReducers.isIntegerNumber(numberClass)) {
                long integerMin = first.longValue();
                for (int i = 1; i < inputListWithoutNulls.size(); ++i) {
                    long currentValue = ((Number)inputListWithoutNulls.get(i)).longValue();
                    if (currentValue >= integerMin) continue;
                    integerMin = currentValue;
                }
                return JmxReducers.convert(integerMin, numberClass);
            }
            throw new IllegalArgumentException("Cannot calculate min of objects of type: " + first.getClass().getName());
        }
    }

    public static final class JmxReducerSum
    implements JmxReducer<Number> {
        @Override
        public Number reduce(List<? extends Number> input) {
            List inputListWithoutNulls = JmxUtils.filterNulls(input);
            if (inputListWithoutNulls.size() == 0) {
                return null;
            }
            Number first = (Number)inputListWithoutNulls.get(0);
            Class<?> numberClass = first.getClass();
            if (JmxReducers.isFloatingPointNumber(numberClass)) {
                double floatingPointSum = first.doubleValue();
                for (int i = 1; i < inputListWithoutNulls.size(); ++i) {
                    floatingPointSum += ((Number)inputListWithoutNulls.get(i)).doubleValue();
                }
                return JmxReducers.convert(floatingPointSum, numberClass);
            }
            if (JmxReducers.isIntegerNumber(numberClass)) {
                long integerSum = first.longValue();
                for (int i = 1; i < inputListWithoutNulls.size(); ++i) {
                    integerSum += ((Number)inputListWithoutNulls.get(i)).longValue();
                }
                return JmxReducers.convert(integerSum, numberClass);
            }
            throw new IllegalArgumentException("Cannot calculate sum of objects of type: " + first.getClass().getName());
        }
    }

    public static final class JmxReducerDistinct
    implements JmxReducer<Object> {
        @Override
        public Object reduce(List<?> input) {
            if (input.size() == 0) {
                return null;
            }
            Object firstValue = input.get(0);
            for (int i = 1; i < input.size(); ++i) {
                Object currentValue = input.get(i);
                if (Objects.equals(firstValue, currentValue)) continue;
                return null;
            }
            return firstValue;
        }
    }
}

