/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.jmx;

import io.datakernel.annotation.Nullable;
import io.datakernel.util.StringFormatUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class MBeanFormat {
    private MBeanFormat() {
    }

    public static String formatExceptionMultiline(@Nullable Throwable exception) {
        if (exception == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String[] formatException(Throwable exception) {
        return exception == null ? new String[]{} : MBeanFormat.formatExceptionMultiline(exception).split("\n");
    }

    public static String formatInstant(@Nullable Instant instant) {
        if (instant == null) {
            return "";
        }
        Duration ago = Duration.between(instant, Instant.ofEpochMilli(System.currentTimeMillis())).withNanos(0);
        return StringFormatUtils.formatInstant((Instant)instant) + " (" + StringFormatUtils.formatDuration((Duration)ago) + " ago)";
    }

    public static String formatTimestamp(long timestamp) {
        return MBeanFormat.formatInstant(timestamp != 0L ? Instant.ofEpochMilli(timestamp) : null);
    }

    @Nullable
    public static String formatListAsMultilineString(@Nullable List<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        List strings = list.stream().map(Object::toString).collect(Collectors.toList());
        return (strings.stream().anyMatch(s -> s.contains("\n")) ? strings.stream().map(s -> s + "\n") : strings.stream()).collect(Collectors.joining("\n")).trim();
    }

    @Nullable
    public static List<String> formatMultilineStringAsList(@Nullable String multiline) {
        if (multiline == null) {
            return null;
        }
        return multiline.isEmpty() ? null : Arrays.asList(multiline.split("\n"));
    }
}

