/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.jmx;

import io.datakernel.annotation.Nullable;
import io.datakernel.async.AsyncCallable;
import io.datakernel.async.Stage;
import io.datakernel.async.StageConsumer;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.jmx.ExceptionStats;
import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxReducers;
import io.datakernel.jmx.ValueStats;
import java.time.Duration;
import java.time.Instant;

public class StageStats {
    private Eventloop eventloop;
    private int activeStages = 0;
    private long lastStartTimestamp = 0L;
    private long lastCompleteTimestamp = 0L;
    private final ValueStats duration;
    private final ExceptionStats exceptions = ExceptionStats.create();

    protected StageStats(Eventloop eventloop, ValueStats duration) {
        this.eventloop = eventloop;
        this.duration = duration;
    }

    public static StageStats createMBean(Eventloop eventloop, Duration smoothingWindow) {
        return new StageStats(eventloop, ValueStats.create(smoothingWindow));
    }

    public static StageStats create(Duration smoothingWindow) {
        return new StageStats(null, ValueStats.create(smoothingWindow));
    }

    public StageStats withHistogram(int[] levels) {
        this.setHistogramLevels(levels);
        return this;
    }

    public void setHistogramLevels(int[] levels) {
        this.duration.setHistogramLevels(levels);
    }

    private long currentTimeMillis() {
        if (this.eventloop == null) {
            this.eventloop = Eventloop.getCurrentEventloop();
        }
        return this.eventloop.currentTimeMillis();
    }

    public <T> AsyncCallable<T> wrapper(AsyncCallable<T> callable) {
        return () -> this.monitor(callable.call());
    }

    public <T> Stage<T> monitor(Stage<T> stage) {
        return stage.whenComplete(this.recordStats());
    }

    public <T> StageConsumer<T> recordStats() {
        long before;
        ++this.activeStages;
        this.lastStartTimestamp = before = this.currentTimeMillis();
        return (value, throwable) -> {
            --this.activeStages;
            long now = this.currentTimeMillis();
            long durationMillis = now - before;
            this.lastCompleteTimestamp = now;
            this.duration.recordValue(durationMillis);
            if (throwable != null) {
                this.exceptions.recordException(throwable);
            }
        };
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getActiveStages() {
        return this.activeStages;
    }

    @JmxAttribute
    @Nullable
    public Instant getLastStartTime() {
        return this.lastStartTimestamp != 0L ? Instant.ofEpochMilli(this.lastStartTimestamp) : null;
    }

    @JmxAttribute
    @Nullable
    public Instant getLastCompleteTime() {
        return this.lastCompleteTimestamp != 0L ? Instant.ofEpochMilli(this.lastCompleteTimestamp) : null;
    }

    @JmxAttribute
    @Nullable
    public Duration getCurrentDuration() {
        return this.activeStages != 0 ? Duration.ofMillis(this.currentTimeMillis() - this.lastStartTimestamp) : null;
    }

    @JmxAttribute
    public ValueStats getDuration() {
        return this.duration;
    }

    @JmxAttribute
    public ExceptionStats getExceptions() {
        return this.exceptions;
    }
}

