/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.net;

import io.datakernel.net.ServerSocketSettings;
import io.datakernel.net.SocketSettings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockingSocketServer {
    private static final Logger logger = LoggerFactory.getLogger(BlockingSocketServer.class);
    private ThreadFactory acceptThreadFactory;
    private final ExecutorService executor;
    private final AcceptHandler acceptHandler;
    private ServerSocketSettings serverSocketSettings;
    private SocketSettings socketSettings;
    private final List<InetSocketAddress> listenAddresses = new ArrayList<InetSocketAddress>();
    private final List<ServerSocket> serverSockets = new ArrayList<ServerSocket>();
    private final Map<ServerSocket, Thread> acceptThreads = new HashMap<ServerSocket, Thread>();

    private BlockingSocketServer(ExecutorService executor, AcceptHandler acceptHandler) {
        this.executor = executor;
        this.acceptHandler = acceptHandler;
    }

    private static BlockingSocketServer create(ExecutorService executor, AcceptHandler acceptHandler) {
        return new BlockingSocketServer(executor, acceptHandler);
    }

    public BlockingSocketServer withAcceptThreadFactory(ThreadFactory acceptThreadFactory) {
        this.acceptThreadFactory = acceptThreadFactory;
        return this;
    }

    public BlockingSocketServer withListenAddresses(List<InetSocketAddress> listenAddresses) {
        this.listenAddresses.addAll(listenAddresses);
        return this;
    }

    public BlockingSocketServer withListenAddresses(InetSocketAddress ... listenAddresses) {
        return this.withListenAddresses(Arrays.asList(listenAddresses));
    }

    public BlockingSocketServer withListenAddress(InetSocketAddress listenAddress) {
        this.listenAddresses.add(listenAddress);
        return this;
    }

    public BlockingSocketServer withListenPort(int port) {
        return this.withListenAddress(new InetSocketAddress(port));
    }

    public BlockingSocketServer withServerSocketSettings(ServerSocketSettings socketSettings) {
        this.serverSocketSettings = socketSettings;
        return this;
    }

    public BlockingSocketServer withSocketSettings(SocketSettings socketSettings) {
        this.socketSettings = socketSettings;
        return this;
    }

    private void serveClient(final Socket socket) throws IOException {
        this.socketSettings.applySettings(socket.getChannel());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BlockingSocketServer.this.acceptHandler.onAccept(socket);
                }
                catch (Exception e) {
                    logger.error("Failed to serve socket " + socket, (Throwable)e);
                }
            }
        });
    }

    public void start() throws Exception {
        for (InetSocketAddress address : this.listenAddresses) {
            final ServerSocket serverSocket = new ServerSocket(address.getPort(), this.serverSocketSettings.getBacklog(), address.getAddress());
            this.serverSocketSettings.applySettings(serverSocket.getChannel());
            this.serverSockets.add(serverSocket);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    while (!Thread.interrupted()) {
                        try {
                            BlockingSocketServer.this.serveClient(serverSocket.accept());
                        }
                        catch (Exception e) {
                            if (Thread.currentThread().isInterrupted()) break;
                            logger.error("Socket error for " + serverSocket, (Throwable)e);
                        }
                    }
                }
            };
            Thread acceptThread = this.acceptThreadFactory == null ? new Thread(runnable) : this.acceptThreadFactory.newThread(runnable);
            acceptThread.setDaemon(true);
            this.acceptThreads.put(serverSocket, acceptThread);
            acceptThread.start();
        }
    }

    public void stop() throws Exception {
        for (ServerSocket serverSocket : this.serverSockets) {
            Thread acceptThread = this.acceptThreads.get(serverSocket);
            acceptThread.interrupt();
            serverSocket.close();
        }
        for (Thread acceptThread : this.acceptThreads.values()) {
            acceptThread.join();
        }
        this.serverSockets.clear();
    }

    public static interface AcceptHandler {
        public void onAccept(Socket var1) throws IOException;
    }
}

