/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.net;

import io.datakernel.annotation.Nullable;
import io.datakernel.util.MemSize;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;

public final class DatagramSocketSettings {
    protected static final byte DEF_BOOL = -1;
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    private final MemSize receiveBufferSize;
    private final byte reuseAddress;
    private final MemSize sendBufferSize;
    private final byte broadcast;

    private DatagramSocketSettings(@Nullable MemSize receiveBufferSize, @Nullable MemSize sendBufferSize, byte reuseAddress, byte broadcast) {
        this.receiveBufferSize = receiveBufferSize;
        this.reuseAddress = reuseAddress;
        this.sendBufferSize = sendBufferSize;
        this.broadcast = broadcast;
    }

    public static DatagramSocketSettings create() {
        return new DatagramSocketSettings(null, null, -1, -1);
    }

    public DatagramSocketSettings withReceiveBufferSize(MemSize receiveBufferSize) {
        return new DatagramSocketSettings(receiveBufferSize, this.sendBufferSize, this.reuseAddress, this.broadcast);
    }

    public DatagramSocketSettings withSendBufferSize(MemSize sendBufferSize) {
        return new DatagramSocketSettings(this.receiveBufferSize, sendBufferSize, this.reuseAddress, this.broadcast);
    }

    public DatagramSocketSettings withReuseAddress(boolean reuseAddress) {
        return new DatagramSocketSettings(this.receiveBufferSize, this.sendBufferSize, reuseAddress ? (byte)1 : 0, this.broadcast);
    }

    public DatagramSocketSettings withBroadcast(boolean broadcast) {
        return new DatagramSocketSettings(this.receiveBufferSize, this.sendBufferSize, this.reuseAddress, broadcast ? (byte)1 : 0);
    }

    public void applySettings(DatagramChannel channel) throws IOException {
        if (this.receiveBufferSize != null) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize.toInt());
        }
        if (this.sendBufferSize != null) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sendBufferSize.toInt());
        }
        if (this.reuseAddress != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)(this.reuseAddress != 0 ? 1 : 0));
        }
        if (this.broadcast != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)(this.broadcast != 0 ? 1 : 0));
        }
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != null;
    }

    public MemSize getReceiveBufferSize() {
        Preconditions.check((boolean)this.hasReceiveBufferSize());
        return this.receiveBufferSize;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != -1;
    }

    public boolean getReuseAddress() {
        Preconditions.check((boolean)this.hasReuseAddress());
        return this.reuseAddress != 0;
    }

    public boolean hasSendBufferSize() {
        return this.sendBufferSize != null;
    }

    public MemSize getSendBufferSize() {
        Preconditions.check((boolean)this.hasSendBufferSize());
        return this.sendBufferSize;
    }

    public boolean hasBroadcast() {
        return this.broadcast != -1;
    }

    public boolean getBroadcast() {
        Preconditions.check((boolean)this.hasBroadcast());
        return this.broadcast != 0;
    }
}

