/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.net;

import io.datakernel.annotation.Nullable;
import io.datakernel.util.MemSize;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ServerSocketChannel;

public final class ServerSocketSettings {
    public static final int DEFAULT_BACKLOG = 16384;
    protected static final byte DEF_BOOL = -1;
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    private final int backlog;
    @Nullable
    private final MemSize receiveBufferSize;
    private final byte reuseAddress;

    private ServerSocketSettings(int backlog, MemSize receiveBufferSize, byte reuseAddress) {
        this.backlog = backlog;
        this.receiveBufferSize = receiveBufferSize;
        this.reuseAddress = reuseAddress;
    }

    public static ServerSocketSettings create(int backlog) {
        return new ServerSocketSettings(backlog, null, -1);
    }

    public ServerSocketSettings withBacklog(int backlog) {
        return new ServerSocketSettings(backlog, this.receiveBufferSize, this.reuseAddress);
    }

    public ServerSocketSettings withReceiveBufferSize(MemSize receiveBufferSize) {
        return new ServerSocketSettings(this.backlog, receiveBufferSize, this.reuseAddress);
    }

    public ServerSocketSettings withReuseAddress(boolean reuseAddress) {
        return new ServerSocketSettings(this.backlog, this.receiveBufferSize, reuseAddress ? (byte)1 : 0);
    }

    public void applySettings(ServerSocketChannel channel) throws IOException {
        if (this.receiveBufferSize != null) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize.toInt());
        }
        if (this.reuseAddress != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)(this.reuseAddress != 0 ? 1 : 0));
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != null;
    }

    public MemSize getReceiveBufferSize() {
        Preconditions.check((boolean)this.hasReceiveBufferSize());
        return this.receiveBufferSize;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != -1;
    }

    public boolean getReuseAddress() {
        Preconditions.check((boolean)this.hasReuseAddress());
        return this.reuseAddress != 0;
    }
}

