/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.net;

import io.datakernel.annotation.Nullable;
import io.datakernel.util.MemSize;
import io.datakernel.util.Preconditions;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import java.time.Duration;

public final class SocketSettings {
    protected static final byte DEF_BOOL = -1;
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    private final byte keepAlive;
    private final byte reuseAddress;
    private final byte tcpNoDelay;
    @Nullable
    private final MemSize sendBufferSize;
    @Nullable
    private final MemSize receiveBufferSize;
    @Nullable
    private final Duration implReadTimeout;
    @Nullable
    private final Duration implWriteTimeout;
    @Nullable
    private final MemSize implReadSize;
    @Nullable
    private final MemSize implWriteSize;

    private SocketSettings(@Nullable MemSize sendBufferSize, @Nullable MemSize receiveBufferSize, byte keepAlive, byte reuseAddress, byte tcpNoDelay, @Nullable Duration implReadTimeout, @Nullable Duration implWriteTimeout, MemSize implReadSize, MemSize implWriteSize) {
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.keepAlive = keepAlive;
        this.reuseAddress = reuseAddress;
        this.tcpNoDelay = tcpNoDelay;
        this.implReadTimeout = implReadTimeout;
        this.implWriteTimeout = implWriteTimeout;
        this.implReadSize = implReadSize;
        this.implWriteSize = implWriteSize;
    }

    public static SocketSettings create() {
        return new SocketSettings(null, null, -1, -1, -1, null, null, null, null);
    }

    public SocketSettings withSendBufferSize(MemSize sendBufferSize) {
        return new SocketSettings(sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withReceiveBufferSize(MemSize receiveBufferSize) {
        return new SocketSettings(this.sendBufferSize, receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withKeepAlive(boolean keepAlive) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, keepAlive ? (byte)1 : 0, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withReuseAddress(boolean reuseAddress) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, reuseAddress ? (byte)1 : 0, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withTcpNoDelay(boolean tcpNoDelay) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, tcpNoDelay ? (byte)1 : 0, this.implReadTimeout, this.implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withImplReadTimeout(Duration implReadTimeout) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, implReadTimeout, this.implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withImplWriteTimeout(Duration implWriteTimeout) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, implWriteTimeout, this.implReadSize, this.implWriteSize);
    }

    public SocketSettings withImplReadSize(MemSize implReadSize) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, implReadSize, this.implWriteSize);
    }

    public SocketSettings withImplWriteSize(MemSize implWriteSize) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadSize, implWriteSize);
    }

    public void applySettings(SocketChannel channel) throws IOException {
        if (this.sendBufferSize != null) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sendBufferSize.toInt());
        }
        if (this.receiveBufferSize != null) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize.toInt());
        }
        if (this.keepAlive != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)(this.keepAlive != 0 ? 1 : 0));
        }
        if (this.reuseAddress != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)(this.reuseAddress != 0 ? 1 : 0));
        }
        if (this.tcpNoDelay != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)(this.tcpNoDelay != 0 ? 1 : 0));
        }
    }

    public boolean hasSendBufferSize() {
        return this.sendBufferSize != null;
    }

    public MemSize getSendBufferSize() {
        Preconditions.check((boolean)this.hasSendBufferSize());
        return this.sendBufferSize;
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != null;
    }

    public MemSize getReceiveBufferSize() {
        Preconditions.check((boolean)this.hasReceiveBufferSize());
        return this.receiveBufferSize;
    }

    public boolean hasKeepAlive() {
        return this.keepAlive != -1;
    }

    public boolean getKeepAlive() {
        Preconditions.check((boolean)this.hasKeepAlive());
        return this.keepAlive != 0;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != -1;
    }

    public boolean getReuseAddress() {
        Preconditions.check((boolean)this.hasReuseAddress());
        return this.reuseAddress != 0;
    }

    public boolean hasTcpNoDelay() {
        return this.tcpNoDelay != -1;
    }

    public boolean getTcpNoDelay() {
        Preconditions.check((boolean)this.hasTcpNoDelay());
        return this.tcpNoDelay != 0;
    }

    public boolean hasImplReadTimeout() {
        return this.implReadTimeout != null;
    }

    public Duration getImplReadTimeout() {
        assert (this.hasImplReadTimeout());
        return this.implReadTimeout;
    }

    public boolean hasImplWriteTimeout() {
        return this.implWriteTimeout != null;
    }

    public Duration getImplWriteTimeout() {
        assert (this.hasImplWriteTimeout());
        return this.implWriteTimeout;
    }

    public boolean hasImplReadSize() {
        return this.implReadSize != null;
    }

    public MemSize getImplReadSize() {
        assert (this.hasImplReadSize());
        return this.implReadSize;
    }

    public boolean hasImplWriteSize() {
        return this.implWriteSize != null;
    }

    public MemSize getImplWriteSize() {
        assert (this.hasImplWriteSize());
        return this.implWriteSize;
    }
}

