/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.util;

import io.datakernel.async.StageConsumer;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class LogUtils {
    public static String thisMethod() {
        try {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            return stackTraceElement.getMethodName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> StageConsumer<T> toLogger(Logger logger, Level callLevel, Supplier<String> callMsg, Level resultLevel, Function<T, String> resultMsg, Level errorLevel, Function<Throwable, String> errorMsg) {
        LogUtils.log(logger, callLevel, callMsg);
        return (result, throwable) -> {
            if (throwable == null) {
                LogUtils.log(logger, resultLevel, () -> (String)resultMsg.apply(result));
            } else if (errorLevel == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((String)errorMsg.apply(throwable), throwable);
                }
            } else {
                LogUtils.log(logger, errorLevel, () -> (String)errorMsg.apply(throwable));
            }
        };
    }

    public static <T> StageConsumer<T> toLogger(Logger logger, Level callLevel, Supplier<String> callMsg, Level resultLevel, Function<T, String> resultMsg) {
        return LogUtils.toLogger(logger, callLevel, callMsg, resultLevel, resultMsg, null, (Throwable throwable) -> (String)callMsg.get());
    }

    public static <T> StageConsumer<T> toLogger(Logger logger, Level callLevel, Level resultLevel, Level errorLevel, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, callLevel, () -> LogUtils.formatCall(methodName, parameters), resultLevel, (T result) -> LogUtils.formatResult(methodName, result, parameters), errorLevel, errorLevel == null ? throwable -> LogUtils.formatCall(methodName, parameters) : throwable -> LogUtils.formatResult(methodName, throwable, parameters));
    }

    public static <T> StageConsumer<T> toLogger(Logger logger, Level callLevel, Level resultLevel, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, callLevel, resultLevel, null, methodName, parameters);
    }

    public static <T> StageConsumer<T> toLogger(Logger logger, Level level, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, level, level, methodName, parameters);
    }

    public static <T> StageConsumer<T> toLogger(Logger logger, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, Level.TRACE, Level.INFO, methodName, parameters);
    }

    public static void log(Logger logger, Level level, Supplier<String> messageSupplier) {
        switch (level) {
            case TRACE: {
                if (!logger.isTraceEnabled()) break;
                logger.trace(messageSupplier.get());
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) break;
                logger.debug(messageSupplier.get());
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) break;
                logger.info(messageSupplier.get());
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) break;
                logger.warn(messageSupplier.get());
                break;
            }
            case ERROR: {
                if (!logger.isErrorEnabled()) break;
                logger.error(messageSupplier.get());
            }
        }
    }

    public static String formatCall(String methodName, Object ... parameters) {
        return methodName + (parameters.length != 0 ? " " + Arrays.stream(parameters).map(Object::toString).collect(Collectors.joining(", ")) : "") + " ...";
    }

    public static String formatResult(String methodName, Object result, Object ... parameters) {
        return methodName + (parameters.length != 0 ? " " + Arrays.stream(parameters).map(Object::toString).collect(Collectors.joining(", ")) : "") + " -> " + result;
    }

    public static enum Level {
        OFF,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

