/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.util;

import io.datakernel.jmx.JmxAttribute;
import io.datakernel.jmx.JmxRefreshableStats;
import io.datakernel.jmx.JmxStats;
import io.datakernel.jmx.JmxStatsWithReset;
import io.datakernel.jmx.JmxStatsWithSmoothingWindow;
import io.datakernel.util.CollectionUtils;
import io.datakernel.util.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static boolean isJmxStats(Class<?> clazz) {
        return JmxStats.class.isAssignableFrom(clazz);
    }

    public static boolean isJmxRefreshableStats(Class<?> clazz) {
        return JmxRefreshableStats.class.isAssignableFrom(clazz);
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return Boolean.TYPE.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isPrimitiveTypeWrapper(Class<?> clazz) {
        return Boolean.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz);
    }

    public static boolean isString(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    public static boolean isThrowable(Class<?> clazz) {
        return Throwable.class.isAssignableFrom(clazz);
    }

    public static boolean isGetter(Method method) {
        boolean returnsBoolean = method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class;
        boolean isIsGetter = method.getName().length() > 2 && method.getName().startsWith("is") && returnsBoolean;
        boolean doesntReturnVoid = method.getReturnType() != Void.TYPE;
        boolean isGetGetter = method.getName().length() >= 3 && method.getName().startsWith("get") && doesntReturnVoid;
        return isIsGetter || isGetGetter;
    }

    public static String extractFieldNameFromGetter(Method getter) {
        Preconditions.checkArgument((boolean)ReflectionUtils.isGetter(getter));
        if (getter.getName().startsWith("get")) {
            if (getter.getName().length() == 3) {
                return "";
            }
            String getterName = getter.getName();
            String firstLetter = getterName.substring(3, 4);
            String restOfName = getterName.substring(4);
            return firstLetter.toLowerCase() + restOfName;
        }
        if (getter.getName().startsWith("is")) {
            String getterName = getter.getName();
            String firstLetter = getterName.substring(2, 3);
            String restOfName = getterName.substring(3);
            return firstLetter.toLowerCase() + restOfName;
        }
        throw new RuntimeException();
    }

    public static boolean isSetter(Method method) {
        boolean hasSingleParameter = method.getParameterTypes().length == 1;
        return method.getName().length() > 3 && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && hasSingleParameter;
    }

    public static String extractFieldNameFromSetter(Method setter) {
        Preconditions.checkArgument((boolean)ReflectionUtils.isSetter(setter));
        String setterName = setter.getName();
        String firstLetter = setterName.substring(3, 4);
        String restOfName = setterName.substring(4);
        return firstLetter.toLowerCase() + restOfName;
    }

    public static boolean classHasPublicNoArgConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean classHasPublicStaticFactoryMethod(Class<?> clazz, String methodName) {
        Method createMethod;
        try {
            createMethod = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return Modifier.isStatic(createMethod.getModifiers()) && Modifier.isPublic(createMethod.getModifiers()) && createMethod.getReturnType().equals(clazz);
    }

    private static void visitFields(Object instance, Function<Object, Boolean> action) {
        if (instance == null) {
            return;
        }
        for (Method method : instance.getClass().getMethods()) {
            Object fieldValue;
            Class<?> returnType;
            if (method.getParameters().length != 0 || !Modifier.isPublic(method.getModifiers()) || (returnType = method.getReturnType()) == Void.TYPE || returnType == String.class || ReflectionUtils.isPrimitiveType(returnType) || ReflectionUtils.isPrimitiveTypeWrapper(returnType) || Arrays.stream(method.getAnnotations()).noneMatch(a -> a.annotationType() == JmxAttribute.class)) continue;
            try {
                fieldValue = method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                continue;
            }
            if (fieldValue == null || action.apply(fieldValue).booleanValue()) continue;
            if (Map.class.isAssignableFrom(returnType)) {
                for (Object item : ((Map)fieldValue).values()) {
                    ReflectionUtils.visitFields(item, action);
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                for (Object item : (Collection)fieldValue) {
                    ReflectionUtils.visitFields(item, action);
                }
                continue;
            }
            ReflectionUtils.visitFields(fieldValue, action);
        }
    }

    public static void resetStats(Object instance) {
        ReflectionUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithReset) {
                ((JmxStatsWithReset)item).resetStats();
                return true;
            }
            return false;
        });
    }

    public static void setSmoothingWindow(Object instance, Duration smoothingWindowSeconds) {
        ReflectionUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithSmoothingWindow) {
                ((JmxStatsWithSmoothingWindow)item).setSmoothingWindow(smoothingWindowSeconds);
                return true;
            }
            return false;
        });
    }

    public static Duration getSmoothingWindow(Object instance) {
        HashSet result = new HashSet();
        ReflectionUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithSmoothingWindow) {
                Duration smoothingWindow = ((JmxStatsWithSmoothingWindow)item).getSmoothingWindow();
                result.add(smoothingWindow);
                return true;
            }
            return false;
        });
        if (result.size() == 1) {
            return (Duration)CollectionUtils.first(result);
        }
        return null;
    }
}

