/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.service;

import io.datakernel.common.Preconditions;
import io.datakernel.service.SupplierService;
import io.datakernel.service.util.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSupplierService<V>
implements SupplierService<V> {
    private V value;
    private final Executor executor;

    public AbstractSupplierService() {
        this(Runnable::run);
    }

    public AbstractSupplierService(Executor executor) {
        this.executor = executor;
    }

    @Override
    public final V get() {
        return (V)Preconditions.checkNotNull(this.value);
    }

    @Override
    public final CompletableFuture<?> start() {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                this.value = Preconditions.checkNotNull(this.compute());
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @NotNull
    protected abstract V compute() throws Exception;

    @Override
    public final CompletableFuture<?> stop() {
        try {
            this.onStop(this.value);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture completableFuture = Utils.completedExceptionallyFuture(e);
            return completableFuture;
        }
        finally {
            this.value = null;
        }
    }

    protected void onStop(V value) throws Exception {
    }
}

