/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.service;

import io.datakernel.common.Initializable;
import io.datakernel.common.Preconditions;
import io.datakernel.common.Stopwatch;
import io.datakernel.common.StringFormatUtils;
import io.datakernel.common.collection.CollectionUtils;
import io.datakernel.di.core.Name;
import io.datakernel.di.util.ReflectionUtils;
import io.datakernel.jmx.api.ConcurrentJmxMBean;
import io.datakernel.jmx.api.JmxAttribute;
import io.datakernel.jmx.api.JmxOperation;
import io.datakernel.service.Service;
import io.datakernel.service.util.Utils;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceGraph
implements Initializable<ServiceGraph>,
ConcurrentJmxMBean {
    private static final Logger logger = LoggerFactory.getLogger(ServiceGraph.class);
    private Runnable startCallback;
    private boolean started;
    private final Map<Key, Set<Key>> forwards = new HashMap<Key, Set<Key>>();
    private final Map<Key, Set<Key>> backwards = new HashMap<Key, Set<Key>>();
    private final Map<Key, Service> services = new HashMap<Key, Service>();
    private volatile long startBegin;
    private volatile long startEnd;
    private volatile Throwable startException;
    private volatile SlowestChain slowestChain;
    private volatile long stopBegin;
    private volatile long stopEnd;
    private volatile Throwable stopException;
    private final Map<Key, NodeStatus> nodeStatuses = new ConcurrentHashMap<Key, NodeStatus>();
    private String graphvizGraph = "rankdir=LR";
    private String graphvizStarting = "color=green";
    private String graphvizStarted = "color=blue";
    private String graphvizStopping = "color=green";
    private String graphvizStopped = "color=grey";
    private String graphvizException = "color=red";
    private String graphvizNodeWithSuffix = "peripheries=2";
    private String graphvizSlowestNode = "style=bold";
    private String graphvizSlowestEdge = "color=blue style=bold";
    private String graphvizEdge = "";

    private ServiceGraph() {
    }

    public static ServiceGraph create() {
        return new ServiceGraph();
    }

    void setStartCallback(Runnable startCallback) {
        this.startCallback = startCallback;
    }

    public ServiceGraph withGraphvizGraph(String graphvizGraph) {
        this.graphvizGraph = graphvizGraph;
        return this;
    }

    public ServiceGraph withGraphvizStarting(String graphvizStarting) {
        this.graphvizStarting = ServiceGraph.toGraphvizAttribute(graphvizStarting);
        return this;
    }

    public ServiceGraph withGraphvizStarted(String graphvizStarted) {
        this.graphvizStarted = ServiceGraph.toGraphvizAttribute(graphvizStarted);
        return this;
    }

    public ServiceGraph withGraphvizStopping(String graphvizStopping) {
        this.graphvizStopping = ServiceGraph.toGraphvizAttribute(graphvizStopping);
        return this;
    }

    public ServiceGraph withGraphvizStopped(String graphvizStopped) {
        this.graphvizStopped = ServiceGraph.toGraphvizAttribute(graphvizStopped);
        return this;
    }

    public ServiceGraph withGraphvizException(String graphvizException) {
        this.graphvizException = ServiceGraph.toGraphvizAttribute(graphvizException);
        return this;
    }

    public ServiceGraph withGraphvizEdge(String graphvizEdge) {
        this.graphvizEdge = ServiceGraph.toGraphvizAttribute(graphvizEdge);
        return this;
    }

    public ServiceGraph withGraphvizNodeWithSuffix(String graphvizNodeWithSuffix) {
        this.graphvizNodeWithSuffix = ServiceGraph.toGraphvizAttribute(graphvizNodeWithSuffix);
        return this;
    }

    public ServiceGraph withGraphvizSlowestNode(String graphvizSlowestNode) {
        this.graphvizSlowestNode = ServiceGraph.toGraphvizAttribute(graphvizSlowestNode);
        return this;
    }

    public ServiceGraph withGraphvizSlowestEdge(String graphvizSlowestEdge) {
        this.graphvizSlowestEdge = ServiceGraph.toGraphvizAttribute(graphvizSlowestEdge);
        return this;
    }

    private static String toGraphvizAttribute(String colorOrAttribute) {
        if (colorOrAttribute.isEmpty() || colorOrAttribute.contains("=")) {
            return colorOrAttribute;
        }
        return "color=" + (colorOrAttribute.startsWith("#") ? "\"" + colorOrAttribute + "\"" : colorOrAttribute);
    }

    public ServiceGraph add(Key key, @Nullable Service service, Key ... dependencies) {
        Preconditions.checkArgument((!this.services.containsKey(key) ? 1 : 0) != 0, (Object)"Key has already been added");
        if (service != null) {
            this.services.put(key, service);
        }
        this.add(key, Arrays.asList(dependencies));
        return this;
    }

    public ServiceGraph add(Key key, Collection<Key> dependencies) {
        for (Key dependency : dependencies) {
            this.forwards.computeIfAbsent(key, o -> new HashSet()).add(dependency);
            this.backwards.computeIfAbsent(dependency, o -> new HashSet()).add(key);
        }
        return this;
    }

    public ServiceGraph add(Key key, Key first, Key ... rest) {
        this.add(key, CollectionUtils.concat(Collections.singletonList(first), Arrays.asList(rest)));
        return this;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized CompletableFuture<?> startFuture() {
        List<Key> circularDependencies;
        if (this.started) {
            return CompletableFuture.completedFuture(false);
        }
        this.started = true;
        if (this.startCallback != null) {
            this.startCallback.run();
        }
        Preconditions.checkState(((circularDependencies = this.findCircularDependencies()) == null ? 1 : 0) != 0, (String)"Circular dependencies found: %s", (Object[])new Object[]{circularDependencies});
        Set rootNodes = CollectionUtils.difference((Set)io.datakernel.di.util.Utils.union(this.services.keySet(), this.forwards.keySet()), this.backwards.keySet());
        if (rootNodes.isEmpty()) {
            throw new IllegalStateException("No root nodes found, nobody requested a service");
        }
        logger.info("Starting services");
        logger.trace("Root nodes: {}", (Object)rootNodes);
        this.startBegin = System.currentTimeMillis();
        return this.doStartStop(true, rootNodes).whenComplete(($, e) -> {
            this.startEnd = System.currentTimeMillis();
            if (e == null) {
                this.slowestChain = this.findSlowestChain(rootNodes);
            } else {
                this.startException = e;
            }
        }).toCompletableFuture();
    }

    public synchronized CompletableFuture<?> stopFuture() {
        Set leafNodes = CollectionUtils.difference((Set)io.datakernel.di.util.Utils.union(this.services.keySet(), this.backwards.keySet()), this.forwards.keySet());
        logger.info("Stopping services");
        logger.trace("Leaf nodes: {}", (Object)leafNodes);
        this.stopBegin = System.currentTimeMillis();
        return this.doStartStop(false, leafNodes).whenComplete(($, e) -> {
            this.stopEnd = System.currentTimeMillis();
            if (e != null) {
                this.stopException = e;
            }
        }).toCompletableFuture();
    }

    private CompletionStage<?> doStartStop(boolean start, Collection<Key> rootNodes) {
        HashMap cache = new HashMap();
        return Utils.combineAll(rootNodes.stream().map(rootNode -> this.processNode((Key)rootNode, start, cache)).collect(Collectors.toList()));
    }

    private synchronized CompletionStage<?> processNode(Key node, boolean start, Map<Key, CompletionStage<?>> cache) {
        if (cache.containsKey(node)) {
            CompletionStage<?> future = cache.get(node);
            if (logger.isTraceEnabled()) {
                logger.trace(this.keyToString(node) + " : reusing " + future);
            }
            return future;
        }
        Set dependencies = (start ? this.forwards : this.backwards).getOrDefault(node, Collections.emptySet());
        if (logger.isTraceEnabled()) {
            logger.trace(this.keyToString(node) + " : processing " + dependencies);
        }
        CompletionStage future = Utils.combineAll(dependencies.stream().map(dependency -> this.processNode((Key)dependency, start, cache)).collect(Collectors.toList())).thenCompose($ -> {
            Service service = this.services.get(node);
            if (service == null) {
                logger.trace("...skipping no-service node: " + this.keyToString(node));
                return CompletableFuture.completedFuture(null);
            }
            if (!start && !this.nodeStatuses.getOrDefault(node, NodeStatus.DEFAULT).isStartedSuccessfully()) {
                logger.trace("...skipping not running node: " + this.keyToString(node));
                return CompletableFuture.completedFuture(null);
            }
            Stopwatch sw = Stopwatch.createStarted();
            logger.trace((start ? "Starting " : "Stopping ") + this.keyToString(node) + " ...");
            NodeStatus nodeStatus = this.nodeStatuses.computeIfAbsent(node, $1 -> new NodeStatus());
            if (start) {
                nodeStatus.startBegin = System.currentTimeMillis();
            } else {
                nodeStatus.stopBegin = System.currentTimeMillis();
            }
            return (start ? service.start() : service.stop()).whenComplete(($2, e) -> {
                if (start) {
                    nodeStatus.startEnd = System.currentTimeMillis();
                    nodeStatus.startException = e;
                } else {
                    nodeStatus.stopEnd = System.currentTimeMillis();
                    nodeStatus.stopException = e;
                }
                long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                if (e == null) {
                    logger.info((start ? "Started " : "Stopped ") + this.keyToString(node) + (elapsed >= 1L ? " in " + sw : ""));
                } else {
                    logger.error((start ? "Start error " : "Stop error ") + this.keyToString(node), (e instanceof CompletionException || e instanceof ExecutionException) && e.getCause() != null ? e.getCause() : e);
                }
            });
        });
        cache.put(node, future);
        return future;
    }

    private static void removeValue(Map<Key, Set<Key>> map, Key key, Key value) {
        Set<Key> objects = map.get(key);
        objects.remove(value);
        if (objects.isEmpty()) {
            map.remove(key);
        }
    }

    private void removeIntermediateOneWay(Key vertex, Map<Key, Set<Key>> forwards, Map<Key, Set<Key>> backwards) {
        for (Key backward : backwards.getOrDefault(vertex, Collections.emptySet())) {
            ServiceGraph.removeValue(forwards, backward, vertex);
            for (Key forward : forwards.getOrDefault(vertex, Collections.emptySet())) {
                if (forward.equals(backward)) continue;
                forwards.computeIfAbsent(backward, o -> new HashSet()).add(forward);
            }
        }
    }

    private void removeIntermediate(Key vertex) {
        this.removeIntermediateOneWay(vertex, this.forwards, this.backwards);
        this.removeIntermediateOneWay(vertex, this.backwards, this.forwards);
        this.forwards.remove(vertex);
        this.backwards.remove(vertex);
    }

    public void removeIntermediateNodes() {
        ArrayList<Key> toRemove = new ArrayList<Key>();
        for (Key v : io.datakernel.di.util.Utils.union(this.forwards.keySet(), this.backwards.keySet())) {
            if (this.services.containsKey(v)) continue;
            toRemove.add(v);
        }
        for (Key v : toRemove) {
            this.removeIntermediate(v);
        }
    }

    @Nullable
    private List<Key> findCircularDependencies() {
        LinkedHashSet<Key> visited = new LinkedHashSet<Key>();
        ArrayList<Key> path = new ArrayList<Key>();
        while (true) {
            for (Key node : path.isEmpty() ? this.services.keySet() : this.forwards.getOrDefault(path.get(path.size() - 1), Collections.emptySet())) {
                int loopIndex = path.indexOf(node);
                if (loopIndex != -1) {
                    logger.warn("Circular dependencies found: " + path.subList(loopIndex, path.size()).stream().map(this::keyToString).collect(Collectors.joining(", ", "[", "]")));
                    return path.subList(loopIndex, path.size());
                }
                if (visited.contains(node)) continue;
                visited.add(node);
                path.add(node);
            }
            if (path.isEmpty()) break;
            path.remove(path.size() - 1);
        }
        return null;
    }

    private SlowestChain findSlowestChain(Collection<Key> nodes) {
        return nodes.stream().map(node -> {
            Set<Key> children = this.forwards.get(node);
            if (children != null && !children.isEmpty()) {
                return this.findSlowestChain(children).concat((Key)node, this.nodeStatuses.get(node).getStartTime());
            }
            return SlowestChain.of(node, this.nodeStatuses.get(node).getStartTime());
        }).max(Comparator.comparingLong(longestPath -> longestPath.sum)).orElse(SlowestChain.EMPTY);
    }

    private String keyToString(Key key) {
        Name name = key.getName();
        String keySuffix = key.getSuffix();
        String keyIndex = key.getIndex();
        return (name != null ? name.toString() + " " : "") + key.getType().getTypeName() + (keySuffix == null ? "" : "[" + keySuffix + "]") + (keyIndex == null ? "" : (keyIndex.isEmpty() ? "" : " #" + keyIndex));
    }

    private String keyToNode(Key key) {
        String str = this.keyToString(key).replace("\n", "\\n").replace("\"", "\\\"");
        return "\"" + str + "\"";
    }

    private String keyToLabel(Key key) {
        Name name = key.getName();
        String keySuffix = key.getSuffix();
        String keyIndex = key.getIndex();
        NodeStatus status = this.nodeStatuses.get(key);
        String label = (name != null ? name.getDisplayString() + "\\n" : "") + ReflectionUtils.getShortName((Type)key.getType()) + (keySuffix == null ? "" : "[" + keySuffix + "]") + (keyIndex == null ? "" : (keyIndex.isEmpty() ? "" : "#" + keyIndex)) + (status != null && status.isStarted() ? "\\n" + StringFormatUtils.formatDuration((Duration)Duration.ofMillis(status.getStartTime())) + (status.isStopped() ? " / " + StringFormatUtils.formatDuration((Duration)Duration.ofMillis(status.getStopTime())) : "") : "") + (status != null && status.startException != null ? "\\n" + status.startException : "") + (status != null && status.stopException != null ? "\\n" + status.stopException : "");
        return label.replace("\"", "\\\"");
    }

    public String toString() {
        return this.toGraphViz();
    }

    @JmxOperation
    public String toGraphViz() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph {\n");
        if (!this.graphvizGraph.isEmpty()) {
            sb.append("\t" + this.graphvizGraph + "\n");
        }
        for (Key node : this.forwards.keySet()) {
            for (Key dependency : this.forwards.get(node)) {
                sb.append("\t" + this.keyToNode(node) + " -> " + this.keyToNode(dependency)).append(this.slowestChain != null && this.slowestChain.path.contains(node) && this.slowestChain.path.contains(dependency) && this.slowestChain.path.indexOf(node) == this.slowestChain.path.indexOf(dependency) + 1 ? " [" + this.graphvizSlowestEdge + "]" : (!this.graphvizEdge.isEmpty() ? " [" + this.graphvizEdge + "]" : "")).append("\n");
            }
        }
        HashMap<NodeStatus.Operation, String> nodeColors = new HashMap<NodeStatus.Operation, String>();
        nodeColors.put(NodeStatus.Operation.STARTING, this.graphvizStarting);
        nodeColors.put(NodeStatus.Operation.STARTED, this.graphvizStarted);
        nodeColors.put(NodeStatus.Operation.STOPPING, this.graphvizStopping);
        nodeColors.put(NodeStatus.Operation.STOPPED, this.graphvizStopped);
        nodeColors.put(NodeStatus.Operation.EXCEPTION, this.graphvizException);
        sb.append("\n");
        for (Key key : io.datakernel.di.util.Utils.union(this.services.keySet(), (Set)io.datakernel.di.util.Utils.union(this.backwards.keySet(), this.forwards.keySet()))) {
            NodeStatus status = this.nodeStatuses.get(key);
            String nodeColor = status != null ? nodeColors.getOrDefault((Object)status.getOperation(), "") : "";
            sb.append("\t" + this.keyToNode(key) + " [ label=\"" + this.keyToLabel(key)).append("\"" + (!nodeColor.isEmpty() ? " " + nodeColor : "")).append(key.getSuffix() != null ? " " + this.graphvizNodeWithSuffix : "").append(this.slowestChain != null && this.slowestChain.path.contains(key) ? " " + this.graphvizSlowestNode : "").append(" ]\n");
        }
        sb.append("\n\t{ rank=same; " + CollectionUtils.difference((Set)io.datakernel.di.util.Utils.union(this.services.keySet(), this.backwards.keySet()), this.forwards.keySet()).stream().map(this::keyToNode).collect(Collectors.joining(" "))).append(" }\n");
        sb.append("}\n");
        return sb.toString();
    }

    @JmxAttribute
    public String getStartingNodes() {
        return io.datakernel.di.util.Utils.union(this.services.keySet(), (Set)io.datakernel.di.util.Utils.union(this.backwards.keySet(), this.forwards.keySet())).stream().filter(node -> {
            NodeStatus status = this.nodeStatuses.get(node);
            return status != null && status.isStarting();
        }).map(this::keyToString).collect(Collectors.joining(", "));
    }

    @JmxAttribute
    public String getStoppingNodes() {
        return io.datakernel.di.util.Utils.union(this.services.keySet(), (Set)io.datakernel.di.util.Utils.union(this.backwards.keySet(), this.forwards.keySet())).stream().filter(node -> {
            NodeStatus status = this.nodeStatuses.get(node);
            return status != null && status.isStopping();
        }).map(this::keyToString).collect(Collectors.joining(", "));
    }

    @JmxAttribute
    @Nullable
    public String getSlowestNode() {
        return io.datakernel.di.util.Utils.union(this.services.keySet(), (Set)io.datakernel.di.util.Utils.union(this.backwards.keySet(), this.forwards.keySet())).stream().filter(key -> {
            NodeStatus nodeStatus = this.nodeStatuses.get(key);
            return nodeStatus != null && nodeStatus.isStarted();
        }).max(Comparator.comparingLong(node -> this.nodeStatuses.get(node).getStartTime())).map(node -> this.keyToString((Key)node) + " : " + StringFormatUtils.formatDuration((Duration)Duration.ofMillis(this.nodeStatuses.get(node).getStartTime()))).orElse(null);
    }

    @JmxAttribute
    @Nullable
    public String getSlowestChain() {
        if (this.slowestChain == null) {
            return null;
        }
        return this.slowestChain.path.stream().map(this::keyToString).collect(Collectors.joining(", ", "[", "]")) + " : " + StringFormatUtils.formatDuration((Duration)Duration.ofMillis(this.slowestChain.sum));
    }

    @JmxAttribute
    @Nullable
    public Duration getStartDuration() {
        if (this.startBegin == 0L) {
            return null;
        }
        return Duration.ofMillis((this.startEnd != 0L ? this.startEnd : System.currentTimeMillis()) - this.startBegin);
    }

    @JmxAttribute
    public Throwable getStartException() {
        return this.startException;
    }

    @JmxAttribute
    @Nullable
    public Duration getStopDuration() {
        if (this.stopBegin == 0L) {
            return null;
        }
        return Duration.ofMillis((this.stopEnd != 0L ? this.stopEnd : System.currentTimeMillis()) - this.stopBegin);
    }

    @JmxAttribute
    public Throwable getStopException() {
        return this.stopException;
    }

    private static final class SlowestChain {
        static final SlowestChain EMPTY = new SlowestChain(Collections.emptyList(), 0L);
        final List<Key> path;
        final long sum;

        private SlowestChain(List<Key> path, long sum) {
            this.path = path;
            this.sum = sum;
        }

        SlowestChain concat(Key key, long time) {
            return new SlowestChain(CollectionUtils.concat(this.path, Collections.singletonList(key)), this.sum + time);
        }

        static SlowestChain of(Key key, long keyValue) {
            return new SlowestChain(Collections.singletonList(key), keyValue);
        }
    }

    private static final class NodeStatus {
        private static final NodeStatus DEFAULT = new NodeStatus();
        volatile long startBegin;
        volatile long startEnd;
        volatile Throwable startException;
        volatile long stopBegin;
        volatile long stopEnd;
        volatile Throwable stopException;

        private NodeStatus() {
        }

        Operation getOperation() {
            if (this.startException != null || this.stopException != null) {
                return Operation.EXCEPTION;
            }
            if (this.stopEnd != 0L) {
                return Operation.STOPPED;
            }
            if (this.stopBegin != 0L) {
                return Operation.STOPPING;
            }
            if (this.startEnd != 0L) {
                return Operation.STARTED;
            }
            if (this.startBegin != 0L) {
                return Operation.STARTING;
            }
            return Operation.NEW;
        }

        boolean isStarting() {
            return this.startBegin != 0L && this.startEnd == 0L;
        }

        boolean isStarted() {
            return this.startEnd != 0L;
        }

        boolean isStartedSuccessfully() {
            return this.startEnd != 0L && this.startException == null;
        }

        boolean isStopping() {
            return this.stopBegin != 0L && this.stopEnd == 0L;
        }

        boolean isStopped() {
            return this.stopEnd != 0L;
        }

        long getStartTime() {
            Preconditions.checkState((this.startBegin != 0L && this.startEnd != 0L ? 1 : 0) != 0, (Object)"Start() has not been called or has not finished yet");
            return this.startEnd - this.startBegin;
        }

        long getStopTime() {
            Preconditions.checkState((this.stopBegin != 0L && this.stopEnd != 0L ? 1 : 0) != 0, (Object)"Stop() has not been called or has not finished yet");
            return this.stopEnd - this.stopBegin;
        }

        private static enum Operation {
            NEW,
            STARTING,
            STARTED,
            STOPPING,
            STOPPED,
            EXCEPTION;

        }
    }

    public static interface Key {
        @NotNull
        public Type getType();

        @Nullable
        public Name getName();

        @Nullable
        public String getSuffix();

        @Nullable
        public String getIndex();
    }
}

