/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.datakernel.uikernel.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CreateResponse<K> {
    private final K id;
    private final Map<String, List<String>> errors;

    private CreateResponse(K id, Map<String, List<String>> errors) {
        this.id = Utils.checkNotNull(id, "Id cannot be null in CreateResponse");
        this.errors = Utils.checkNotNull(errors, "Errors cannot be null in CreateResponse");
    }

    public static <K> CreateResponse<K> of(K id) {
        return new CreateResponse<K>(id, Collections.emptyMap());
    }

    public static <K> CreateResponse<K> of(K id, Map<String, List<String>> errors) {
        return new CreateResponse<K>(id, errors);
    }

    String toJson(Gson gson, Class<K> idType) {
        JsonObject result = new JsonObject();
        result.add("data", gson.toJsonTree(this.id, idType));
        result.add("errors", gson.toJsonTree(this.errors));
        return gson.toJson((JsonElement)result);
    }
}

