/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.datakernel.uikernel.AbstractRecord;
import io.datakernel.uikernel.Utils;
import java.util.Collections;
import java.util.List;

public final class ReadResponse<K, R extends AbstractRecord<K>> {
    private final List<R> records;
    private final int count;
    private List<R> extra;
    private R totals;

    private ReadResponse(List<R> records, int count, List<R> extra, R totals) {
        this.records = Utils.checkNotNull(records, "Records cannot be null in ReadResponse");
        this.count = count;
        this.extra = Utils.checkNotNull(extra, "Extras cannot be null in ReadResponse");
        this.totals = totals;
    }

    public static <K, R extends AbstractRecord<K>> ReadResponse<K, R> of(List<R> records, int count) {
        return new ReadResponse<K, Object>(records, count, Collections.emptyList(), null);
    }

    public static <K, R extends AbstractRecord<K>> ReadResponse<K, R> of(List<R> records, int count, List<R> extra) {
        return new ReadResponse<K, Object>(records, count, extra, null);
    }

    public static <K, R extends AbstractRecord<K>> ReadResponse<K, R> of(List<R> records, int count, List<R> extra, R totals) {
        return new ReadResponse<K, R>(records, count, extra, totals);
    }

    String toJson(Gson gson, Class<R> type, Class<K> idType) {
        JsonObject result = new JsonObject();
        JsonArray recs = new JsonArray();
        for (AbstractRecord record : this.records) {
            JsonArray arr = new JsonArray();
            arr.add(gson.toJsonTree(record.getId(), idType));
            arr.add(gson.toJsonTree((Object)record, type));
            recs.add((JsonElement)arr);
        }
        result.add("records", (JsonElement)recs);
        JsonArray extras = new JsonArray();
        for (AbstractRecord record : this.extra) {
            JsonArray arr = new JsonArray();
            arr.add(gson.toJsonTree(record.getId(), idType));
            arr.add(gson.toJsonTree((Object)record, type));
            extras.add((JsonElement)arr);
        }
        result.add("extra", (JsonElement)extras);
        if (this.totals != null) {
            result.add("total", gson.toJsonTree(this.totals, type));
        }
        result.add("count", gson.toJsonTree((Object)this.count));
        return gson.toJson((JsonElement)result);
    }
}

