/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.uikernel;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import io.datakernel.bytebuf.ByteBufStrings;
import io.datakernel.exception.ParseException;
import io.datakernel.http.HttpRequest;
import io.datakernel.uikernel.Utils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReadSettings<K> {
    private static final int DEFAULT_OFFSET = 0;
    private static final int DEFAULT_LIMIT = Integer.MAX_VALUE;
    private static final Type LIST_STRING_TYPE_TOKEN = new TypeToken<List<String>>(){}.getType();
    private static final Type MAP_STRING_STRING_TYPE_TOKEN = new TypeToken<LinkedHashMap<String, String>>(){}.getType();
    private final List<String> fields;
    private final int offset;
    private final int limit;
    private final Map<String, String> filters;
    private final Map<String, SortOrder> sort;
    private final Set<K> extra;

    private ReadSettings(List<String> fields, int offset, int limit, Map<String, String> filters, Map<String, SortOrder> sort, Set<K> extra) {
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.filters = filters;
        this.sort = sort;
        this.extra = extra;
    }

    public static <K> ReadSettings<K> from(Gson gson, HttpRequest request) throws ParseException {
        Map<String, SortOrder> sort;
        Map<String, String> filters;
        String filtersParameter;
        String fieldsParameter = request.getQueryParameter("fields");
        List fields = fieldsParameter != null && !fieldsParameter.isEmpty() ? (List)Utils.fromJson(gson, fieldsParameter, LIST_STRING_TYPE_TOKEN) : Collections.emptyList();
        String offsetParameter = request.getQueryParameter("offset");
        int offset = 0;
        if (offsetParameter != null && !offsetParameter.isEmpty()) {
            offset = ByteBufStrings.decodeDecimal((byte[])ByteBufStrings.encodeAscii((String)offsetParameter), (int)0, (int)offsetParameter.length());
        }
        String limitParameter = request.getQueryParameter("limit");
        int limit = Integer.MAX_VALUE;
        if (limitParameter != null && !limitParameter.isEmpty()) {
            limit = ByteBufStrings.decodeDecimal((byte[])ByteBufStrings.encodeAscii((String)limitParameter), (int)0, (int)limitParameter.length());
        }
        if ((filtersParameter = request.getQueryParameter("filters")) != null && !filtersParameter.isEmpty()) {
            filters = (Map<String, String>)Utils.fromJson(gson, filtersParameter, MAP_STRING_STRING_TYPE_TOKEN);
            filters = Collections.unmodifiableMap(filters);
        } else {
            filters = Collections.emptyMap();
        }
        String sortParameter = request.getQueryParameter("sort");
        if (sortParameter != null && !sortParameter.isEmpty()) {
            sort = new LinkedHashMap();
            JsonArray array = Utils.fromJson(gson, sortParameter, JsonArray.class);
            for (JsonElement element : array) {
                JsonArray arr = element.getAsJsonArray();
                String key = arr.get(0).getAsString();
                SortOrder value = SortOrder.of(arr.get(1).getAsString());
                sort.put(key, value);
            }
            sort = Collections.unmodifiableMap(sort);
        } else {
            sort = Collections.emptyMap();
        }
        String extraParameter = request.getQueryParameter("extra");
        Set extra = extraParameter != null && !extraParameter.isEmpty() ? (Set)Utils.fromJson(gson, extraParameter, new TypeToken<LinkedHashSet<K>>(){}.getType()) : Collections.emptySet();
        return new ReadSettings(fields, offset, limit, filters, sort, extra);
    }

    public static <K> ReadSettings<K> of(List<String> fields, int offset, int limit, Map<String, String> filters, Map<String, SortOrder> sort, Set<K> extra) {
        return new ReadSettings<K>(fields, offset, limit, filters, sort, extra);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public Map<String, SortOrder> getSort() {
        return this.sort;
    }

    public Set<K> getExtra() {
        return this.extra;
    }

    public String toString() {
        return "ReadSettings{fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", filters=" + this.filters + ", sort=" + this.sort + ", extra=" + this.extra + '}';
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;


        static SortOrder of(String value) {
            if (value.equals("asc")) {
                return ASCENDING;
            }
            return DESCENDING;
        }
    }
}

