/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.uikernel;

import com.google.gson.Gson;
import io.datakernel.async.Stage;
import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufStrings;
import io.datakernel.exception.ParseException;
import io.datakernel.http.AsyncServlet;
import io.datakernel.http.ContentType;
import io.datakernel.http.HttpMethod;
import io.datakernel.http.HttpRequest;
import io.datakernel.http.HttpResponse;
import io.datakernel.http.MediaType;
import io.datakernel.http.MediaTypes;
import io.datakernel.http.MiddlewareServlet;
import io.datakernel.uikernel.AbstractRecord;
import io.datakernel.uikernel.GridModel;
import io.datakernel.uikernel.ReadSettings;
import io.datakernel.uikernel.Utils;
import java.nio.charset.Charset;
import java.util.List;

public class UiKernelServlets {
    private static final ContentType JSON_UTF8 = ContentType.of((MediaType)MediaTypes.JSON, (Charset)Charset.forName("UTF-8"));
    private static final String ID_PARAMETER_NAME = "id";

    public static <K, R extends AbstractRecord<K>> MiddlewareServlet apiServlet(GridModel<K, R> model, Gson gson) {
        return MiddlewareServlet.create().with(HttpMethod.POST, "/", UiKernelServlets.create(model, gson)).with(HttpMethod.GET, "/", UiKernelServlets.read(model, gson)).with(HttpMethod.PUT, "/", UiKernelServlets.update(model, gson)).with(HttpMethod.DELETE, "/:id", UiKernelServlets.delete(model, gson)).with(HttpMethod.GET, "/:id", UiKernelServlets.get(model, gson));
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet read(final GridModel<K, R> model, final Gson gson) {
        return new AsyncServlet(){

            public Stage<HttpResponse> serve(HttpRequest request) {
                try {
                    ReadSettings settings = ReadSettings.from(gson, request);
                    return model.read(settings).thenApply(response -> UiKernelServlets.createResponse(response.toJson(gson, model.getRecordType(), model.getIdType())));
                }
                catch (ParseException e) {
                    return Stage.ofException((Throwable)e);
                }
            }
        };
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet get(final GridModel<K, R> model, final Gson gson) {
        return new AsyncServlet(){

            public Stage<HttpResponse> serve(HttpRequest request) {
                try {
                    ReadSettings settings = ReadSettings.from(gson, request);
                    Object id = Utils.fromJson(gson, request.getPathParameter(UiKernelServlets.ID_PARAMETER_NAME), model.getIdType());
                    return model.read(id, settings).thenApply(obj -> UiKernelServlets.createResponse(gson.toJson(obj, model.getRecordType())));
                }
                catch (ParseException e) {
                    return Stage.ofException((Throwable)e);
                }
            }
        };
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet create(final GridModel<K, R> model, final Gson gson) {
        return new AsyncServlet(){

            public Stage<HttpResponse> serve(HttpRequest request) {
                try {
                    String json = ByteBufStrings.decodeUtf8((ByteBuf)request.getBody());
                    AbstractRecord obj = (AbstractRecord)Utils.fromJson(gson, json, model.getRecordType());
                    return model.create(obj).thenApply(response -> UiKernelServlets.createResponse(response.toJson(gson, model.getIdType())));
                }
                catch (ParseException e) {
                    return Stage.ofException((Throwable)e);
                }
            }
        };
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet update(final GridModel<K, R> model, final Gson gson) {
        return new AsyncServlet(){

            public Stage<HttpResponse> serve(HttpRequest request) {
                try {
                    String json = ByteBufStrings.decodeUtf8((ByteBuf)request.getBody());
                    List list = Utils.deserializeUpdateRequest(gson, json, model.getRecordType(), model.getIdType());
                    return model.update(list).thenApply(result -> UiKernelServlets.createResponse(result.toJson(gson, model.getRecordType(), model.getIdType())));
                }
                catch (ParseException e) {
                    return Stage.ofException((Throwable)e);
                }
            }
        };
    }

    public static <K, R extends AbstractRecord<K>> AsyncServlet delete(final GridModel<K, R> model, final Gson gson) {
        return new AsyncServlet(){

            public Stage<HttpResponse> serve(HttpRequest request) {
                try {
                    Object id = Utils.fromJson(gson, request.getPathParameter(UiKernelServlets.ID_PARAMETER_NAME), model.getIdType());
                    return model.delete(id).thenApply(response -> {
                        HttpResponse res = HttpResponse.ok200();
                        if (response.hasErrors()) {
                            String json = gson.toJson(response.getErrors());
                            res.setContentType(JSON_UTF8);
                            res.setBody(ByteBufStrings.wrapUtf8((String)json));
                        }
                        return res;
                    });
                }
                catch (ParseException e) {
                    return Stage.ofException((Throwable)e);
                }
            }
        };
    }

    private static HttpResponse createResponse(String body) {
        return HttpResponse.ok200().withContentType(JSON_UTF8).withBody(ByteBufStrings.wrapUtf8((String)body));
    }
}

