/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.util.DateTool;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class DatarouterAccount
extends BaseDatabean<DatarouterAccountKey, DatarouterAccount> {
    private String apiKey;
    private String secretKey;
    private Date created;
    private String creator;
    private Date lastUsed;
    private Boolean enableUserMappings;

    public DatarouterAccount() {
        super((PrimaryKey)new DatarouterAccountKey());
    }

    public DatarouterAccount(String accountName, Date created, String creator) {
        super((PrimaryKey)new DatarouterAccountKey(accountName));
        this.created = created;
        this.creator = creator;
        this.enableUserMappings = false;
    }

    public Class<DatarouterAccountKey> getKeyClass() {
        return DatarouterAccountKey.class;
    }

    public String getCreatedDate(ZoneId zoneId) {
        if (this.created == null) {
            return "";
        }
        return DateTool.formatDateWithZone((Date)this.created, (ZoneId)zoneId);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String getLastUsedDate(ZoneId zoneId) {
        if (this.lastUsed == null) {
            return "";
        }
        return DateTool.formatDateWithZone((Date)this.lastUsed, (ZoneId)zoneId);
    }

    public void toggleUserMappings() {
        this.enableUserMappings = this.enableUserMappings == null ? Boolean.valueOf(true) : Boolean.valueOf(this.enableUserMappings == false);
    }

    public boolean getEnableUserMappings() {
        if (this.enableUserMappings == null) {
            return false;
        }
        return this.enableUserMappings;
    }

    public void setEnableUserMappings(boolean enableUserMappings) {
        this.enableUserMappings = enableUserMappings;
    }

    public static class DatarouterAccountFielder
    extends BaseDatabeanFielder<DatarouterAccountKey, DatarouterAccount> {
        public DatarouterAccountFielder() {
            super(DatarouterAccountKey.class);
        }

        public List<Field<?>> getNonKeyFields(DatarouterAccount account) {
            return List.of(new StringField(FieldKeys.apiKey, account.apiKey), new StringField(FieldKeys.secretKey, account.secretKey), new DateField(FieldKeys.created, account.created), new StringField(FieldKeys.creator, account.creator), new DateField(FieldKeys.lastUsed, account.lastUsed), new BooleanField(FieldKeys.enableUserMappings, account.enableUserMappings));
        }
    }

    private static class FieldKeys {
        private static final StringFieldKey apiKey = new StringFieldKey("apiKey");
        private static final StringFieldKey secretKey = new StringFieldKey("secretKey");
        private static final DateFieldKey created = new DateFieldKey("created");
        private static final StringFieldKey creator = new StringFieldKey("creator");
        private static final DateFieldKey lastUsed = new DateFieldKey("lastUsed");
        private static final BooleanFieldKey enableUserMappings = new BooleanFieldKey("enableUserMappings");

        private FieldKeys() {
        }
    }
}

