/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.service.DatarouterAccountService;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.httpclient.security.DefaultCsrfGenerator;
import io.datarouter.httpclient.security.DefaultSignatureGenerator;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.DefaultableMap;
import io.datarouter.web.config.DatarouterWebFiles;
import io.datarouter.web.dispatcher.BaseRouteSet;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.documentation.ApiDocService;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.http.RequestTool;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public abstract class DatarouterUserBasedDocumentationHandler
extends BaseHandler {
    @Inject
    private DatarouterAccountService datarouterAccountService;
    @Inject
    private ApiDocService apiDocService;
    @Inject
    private DatarouterWebFiles files;

    protected Mav createDocumentationMav(String apiName, String apiUrlContext, List<BaseRouteSet> routeSets) {
        List endpoints = this.apiDocService.buildDocumentation(apiUrlContext, routeSets);
        Mav model = new Mav(this.files.jsp.docs.dispatcherDocsJsp);
        model.put("endpoints", (Object)endpoints);
        model.put("apiName", (Object)apiName);
        model.put("hideAuth", (Object)false);
        this.getSessionInfo().getSession().ifPresent(session -> {
            model.put("apiKeyParameterName", (Object)"apiKey");
            this.datarouterAccountService.findFirstAccountCredentialForUser((Session)session).ifPresent(credential -> {
                Object object = model.put("apiKey", (Object)((DatarouterAccountCredentialKey)credential.getKey()).getApiKey());
            });
        });
        model.put("hideAuth", (Object)true);
        return model;
    }

    @BaseHandler.Handler
    public Map<String, String> getCsrfIv() {
        DefaultableMap result = RequestTool.getParamMap((HttpServletRequest)this.request);
        Optional<String> secret = this.datarouterAccountService.findAccountCredentialForApiKeyAuth((String)result.get("apiKey")).map(DatarouterAccountCredential::getSecretKey);
        if (secret.isEmpty()) {
            return result;
        }
        DefaultCsrfGenerator csrfGenerator = new DefaultCsrfGenerator(secret::get);
        String csrfIv = csrfGenerator.generateCsrfIv();
        String csrfToken = csrfGenerator.generateCsrfToken(csrfIv);
        result.put("csrfIv", csrfIv);
        result.put("csrfToken", csrfToken);
        return result;
    }

    @BaseHandler.Handler
    public Map<String, String> getSignature() {
        DefaultableMap params = RequestTool.getParamMap((HttpServletRequest)this.request);
        String body = RequestTool.getBodyAsString((HttpServletRequest)this.request);
        Optional<String> secret = this.datarouterAccountService.findAccountCredentialForApiKeyAuth((String)params.get("apiKey")).map(DatarouterAccountCredential::getSecretKey);
        if (secret.isEmpty()) {
            return params;
        }
        DefaultSignatureGenerator signatureGenerator = new DefaultSignatureGenerator(secret::get);
        if (StringTool.isNullOrEmpty((String)body)) {
            params.put("signature", signatureGenerator.getHexSignature((Map)params).signature);
        } else {
            StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
            params.put("signature", signatureGenerator.getHexSignature((Map)params, (HttpEntity)entity).signature);
        }
        return params;
    }
}

