/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMap;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.lang.ObjectTool;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterAccountCreationService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountCreationService.class);
    public static final String DEFAULT_ACCOUNT_NAME = "default";
    public static final String DEFAULT_ACCOUNT_CREATOR = "defaultCreator";
    @Inject
    private BaseDatarouterAccountDao datarouterAccountDao;
    @Inject
    private BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    @Inject
    private BaseDatarouterUserAccountMapDao userAccountMapDao;
    @Inject
    private BaseDatarouterAccountPermissionDao accountPermissionDao;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;

    public void createDefaultAccountAndMapToDefaultAdminUser() {
        boolean keyExists;
        boolean accountExists;
        if (ObjectTool.notEquals((Object)this.datarouterProperties.getServerTypeString(), (Object)ServerType.DEV.getPersistentString())) {
            return;
        }
        DatarouterAccount defaultAccount = this.datarouterAccountDao.get(new DatarouterAccountKey(DEFAULT_ACCOUNT_NAME));
        boolean bl = accountExists = defaultAccount != null && defaultAccount.getEnableUserMappings();
        if (!accountExists) {
            if (defaultAccount == null) {
                defaultAccount = new DatarouterAccount(DEFAULT_ACCOUNT_NAME, new Date(), DEFAULT_ACCOUNT_CREATOR);
            }
            defaultAccount.setEnableUserMappings(true);
            this.datarouterAccountDao.put(defaultAccount);
            logger.warn("Created default DatarouterAccount");
            this.userAccountMapDao.put(new DatarouterUserAccountMap(1L, DEFAULT_ACCOUNT_NAME));
            logger.warn("Mapped the default admin user to the default account");
        }
        String defaultApiKey = this.defaultDatarouterAccountKeys.getDefaultApiKey();
        String defaultSecretKey = this.defaultDatarouterAccountKeys.getDefaultSecretKey();
        DatarouterAccountCredential defaultCredential = this.datarouterAccountCredentialDao.get(new DatarouterAccountCredentialKey(defaultApiKey));
        boolean bl2 = keyExists = defaultCredential != null && defaultSecretKey.equals(defaultCredential.getSecretKey());
        if (!keyExists) {
            defaultCredential = new DatarouterAccountCredential(defaultApiKey, defaultSecretKey, DEFAULT_ACCOUNT_NAME, DEFAULT_ACCOUNT_CREATOR);
            this.datarouterAccountCredentialDao.put(defaultCredential);
            logger.warn("Created default DatarouterAccountCredential");
        }
    }

    public void createDefaultAccountPermission() {
        if (ObjectTool.notEquals((Object)this.datarouterProperties.getServerTypeString(), (Object)ServerType.DEV.getPersistentString())) {
            return;
        }
        this.accountPermissionDao.put(new DatarouterAccountPermission(DEFAULT_ACCOUNT_NAME, "all"));
        logger.warn("Created default DatarouterAccountPermission");
    }
}

