/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.user.session.service.RoleManager;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.PasswordTool;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserService {
    @Inject
    private DatarouterUserDao nodes;
    @Inject
    private RoleManager roleManager;

    public DatarouterUser getAndValidateCurrentUser(Session session) {
        DatarouterUser user = this.getUserBySession(session);
        if (user == null || !user.getEnabled().booleanValue()) {
            throw new RuntimeException("Current user does not exist or is not enabled.");
        }
        return user;
    }

    public DatarouterUser getUserBySession(Session session) {
        if (session == null || session.getUserId() == null) {
            return null;
        }
        return this.nodes.get(new DatarouterUserKey(session.getUserId()));
    }

    public DatarouterUser getUserById(Long id) {
        return this.nodes.get(new DatarouterUserKey(id));
    }

    public boolean canEditUserPassword(DatarouterUser editor, DatarouterUser user) {
        return user.equals((Object)editor) || !this.isDatarouterAdmin(user) && this.roleManager.isAdmin(editor.getRoles()) != false && editor.getEnabled() != false;
    }

    public boolean canEditUser(DatarouterUser editor, DatarouterUser user) {
        return user.equals((Object)editor) || this.roleManager.isAdmin(editor.getRoles()) != false && editor.getEnabled() != false;
    }

    public boolean canHavePassword(DatarouterUser user) {
        return user.getPasswordDigest() != null || this.isDatarouterAdmin(user);
    }

    public boolean isPasswordCorrect(DatarouterUser user, String rawPassword) {
        if (user == null || rawPassword == null) {
            return false;
        }
        String passwordDigest = PasswordTool.digest((String)user.getPasswordSalt(), (String)rawPassword);
        return Objects.equals(user.getPasswordDigest(), passwordDigest);
    }

    public boolean isPasswordCorrect(String email, String rawPassword) {
        DatarouterUser user = this.nodes.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(email));
        return this.isPasswordCorrect(user, rawPassword);
    }

    public Set<Role> getAllowedUserRoles(DatarouterUser currentUser, Set<Role> userRoles) {
        Set validRoles = this.roleManager.getConferrableRoles(currentUser.getRoles());
        userRoles.retainAll(validRoles);
        userRoles.add(DatarouterUserRole.REQUESTOR.getRole());
        return userRoles;
    }

    public void assertUserDoesNotExist(Long id, String userToken, String username) {
        DatarouterUser userWithId = this.getUserById(id);
        if (userWithId != null) {
            throw new IllegalArgumentException("DatarouterUser already exists with id=" + id);
        }
        DatarouterUser userWithUserToken = this.nodes.getByUserToken(new DatarouterUser.DatarouterUserByUserTokenLookup(userToken));
        if (userWithUserToken != null) {
            throw new IllegalArgumentException("DatarouterUser already exists with userToken=" + userToken);
        }
        DatarouterUser userWithEmail = this.nodes.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username));
        if (userWithEmail != null) {
            throw new IllegalArgumentException("DatarouterUser already exists with username=" + username);
        }
    }

    public boolean isDatarouterAdmin(DatarouterUser user) {
        return user.getRoles().contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole());
    }
}

