/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DatarouterAccountAvailableEndpointsProvider;
import io.datarouter.auth.service.DatarouterAccountCredentialService;
import io.datarouter.auth.service.DefaultDatarouterAccountAvailableEndpointsProvider;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.instrumentation.metric.MetricLinkBuilder;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secretweb.service.WebSecretOpReason;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.RequestBody;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJs;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import io.datarouter.web.user.session.service.Session;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterAccountManagerHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountManagerHandler.class);
    private final BaseDatarouterAccountDao datarouterAccountDao;
    private final BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao;
    private final DatarouterAccountCredentialService acccountCredentialService;
    private final DatarouterProperties datarouterProperties;
    private final DatarouterAuthFiles files;
    private final DatarouterAccountAvailableEndpointsProvider datarouterAccountAvailableEndpointsProvider;
    private final Bootstrap4ReactPageFactory reactPageFactory;
    private final ChangelogRecorder changelogRecorder;
    private final MetricLinkBuilder metricLinkBuilder;
    private final CurrentUserSessionInfoService currentSessionInfoService;
    private final String path;

    @Inject
    public DatarouterAccountManagerHandler(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao, DatarouterAccountCredentialService acccountCredentialService, DatarouterProperties datarouterProperties, DatarouterAuthFiles files, DatarouterAuthPaths paths, DefaultDatarouterAccountAvailableEndpointsProvider defaultDatarouterAccountAvailableEndpointsProvider, Bootstrap4ReactPageFactory reactPageFactory, ChangelogRecorder changelogRecorder, MetricLinkBuilder metricLinkBuilder, CurrentUserSessionInfoService currentSessionInfoService) {
        this(datarouterAccountDao, datarouterAccountPermissionDao, acccountCredentialService, datarouterProperties, files, defaultDatarouterAccountAvailableEndpointsProvider, reactPageFactory, changelogRecorder, metricLinkBuilder, currentSessionInfoService, paths.admin.accounts.toSlashedString());
    }

    protected DatarouterAccountManagerHandler(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao, DatarouterAccountCredentialService acccountCredentialService, DatarouterProperties datarouterProperties, DatarouterAuthFiles files, DatarouterAccountAvailableEndpointsProvider datarouterAccountAvailableEndpointsProvider, Bootstrap4ReactPageFactory reactPageFactory, ChangelogRecorder changelogRecorder, MetricLinkBuilder metricLinkBuilder, CurrentUserSessionInfoService currentSessionInfoService, String path) {
        this.datarouterAccountDao = datarouterAccountDao;
        this.datarouterAccountPermissionDao = datarouterAccountPermissionDao;
        this.acccountCredentialService = acccountCredentialService;
        this.datarouterProperties = datarouterProperties;
        this.files = files;
        this.datarouterAccountAvailableEndpointsProvider = datarouterAccountAvailableEndpointsProvider;
        this.reactPageFactory = reactPageFactory;
        this.changelogRecorder = changelogRecorder;
        this.metricLinkBuilder = metricLinkBuilder;
        this.currentSessionInfoService = currentSessionInfoService;
        this.path = path;
    }

    @BaseHandler.Handler(defaultHandler=true)
    public Mav index() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter Account Manager").withRequires(new String[]{DatarouterWebRequireJs.SORTTABLE}).withReactScript(this.files.js.accountManagerJsx).withJsStringConstant("REACT_BASE_PATH", String.valueOf(this.request.getContextPath()) + this.path + "/").buildMav();
    }

    @BaseHandler.Handler
    public List<DatarouterAccountDetails> list() {
        return this.getDetailsForAccounts(this.datarouterAccountDao.scan().list());
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails getDetails(String accountName) {
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails add(String accountName) {
        Require.isFalse((boolean)accountName.isEmpty());
        String creator = this.getSessionInfo().getRequiredSession().getUsername();
        DatarouterAccount account = new DatarouterAccount(accountName, new Date(), creator);
        this.datarouterAccountDao.put(account);
        this.logAndRecordAction(accountName, "add");
        return this.getDetailsForAccounts(List.of(account)).get(0);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails toggleUserMappings(String accountName) {
        return this.updateAccount(accountName, DatarouterAccount::toggleUserMappings, "toggleUserMappings");
    }

    @BaseHandler.Handler
    public void delete(String accountName) {
        DatarouterAccountPermissionKey prefix = new DatarouterAccountPermissionKey(accountName);
        this.datarouterAccountPermissionDao.deleteWithPrefix(prefix);
        this.acccountCredentialService.deleteAllCredentialsForAccount(accountName, this.getSessionInfo().getRequiredSession());
        DatarouterAccountKey accountKey = new DatarouterAccountKey(accountName);
        this.datarouterAccountDao.delete(accountKey);
        this.logAndRecordAction(accountName, "delete");
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails addCredential(String accountName) {
        Require.isFalse((boolean)accountName.isEmpty());
        String creatorUsername = this.getSessionInfo().getRequiredSession().getUsername();
        this.acccountCredentialService.createCredential(accountName, creatorUsername);
        this.logAndRecordAction(accountName, "add credential");
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails deleteCredential(String apiKey, String accountName) {
        this.acccountCredentialService.deleteCredential(apiKey);
        this.logAndRecordAction(accountName, "delete credential");
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsAndKeypair addSecretCredential(String accountName) {
        Require.isFalse((boolean)accountName.isEmpty());
        Session session = this.getSessionInfo().getRequiredSession();
        String creatorUsername = session.getUsername();
        SecretOpReason secretOpReason = WebSecretOpReason.manualOp((Session)session, (String)((Object)((Object)this)).getClass().getSimpleName());
        DatarouterAccountCredentialService.DatarouterAccountSecretCredentialKeypairDto keypair = this.acccountCredentialService.createSecretCredential(accountName, creatorUsername, secretOpReason);
        this.logAndRecordAction(accountName, "add secret credential");
        return new DatarouterAccountDetailsAndKeypair(this.getDetailsForAccountName(accountName), keypair);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails deleteSecretCredential(String secretName, String accountName) {
        SecretOpReason secretOpReason = WebSecretOpReason.manualOp((Session)this.getSessionInfo().getRequiredSession(), (String)((Object)((Object)this)).getClass().getSimpleName());
        this.acccountCredentialService.deleteSecretCredential(secretName, secretOpReason);
        this.logAndRecordAction(accountName, "delete secret credential");
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails setCredentialActivation(@RequestBody SetCredentialActivationDto dto) {
        Require.isFalse((boolean)dto.accountName.isEmpty());
        Require.notNull((Object)dto.active);
        if (dto.secretName != null && StringTool.notEmptyNorWhitespace((String)dto.secretName)) {
            this.acccountCredentialService.setSecretCredentialActivation(dto.secretName, dto.active);
        } else if (dto.apiKey != null && StringTool.notEmptyNorWhitespace((String)dto.apiKey)) {
            this.acccountCredentialService.setCredentialActivation(dto.apiKey, dto.active);
        } else {
            throw new RuntimeException("apiKey or secretName is required");
        }
        return this.getDetails(dto.accountName);
    }

    @BaseHandler.Handler
    public List<String> getAvailableEndpoints() {
        ArrayList<String> availableEndpoints = new ArrayList<String>();
        availableEndpoints.add("all");
        availableEndpoints.addAll(this.datarouterAccountAvailableEndpointsProvider.getAvailableEndpoints());
        return availableEndpoints;
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails addPermission(String accountName, String endpoint) {
        this.datarouterAccountPermissionDao.put(new DatarouterAccountPermission(accountName, endpoint));
        this.logAndRecordAction(accountName, "addPermission");
        return this.getDetails(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetails deletePermission(String accountName, String endpoint) {
        this.datarouterAccountPermissionDao.delete(new DatarouterAccountPermissionKey(accountName, endpoint));
        this.logAndRecordAction(accountName, "deletePermission");
        return this.getDetails(accountName);
    }

    @BaseHandler.Handler
    public boolean isServerTypeDev() {
        return StringTool.equalsCaseInsensitive((String)this.datarouterProperties.getServerTypeString(), (String)ServerType.DEV.getPersistentString());
    }

    private DatarouterAccountDetails updateAccount(String accountName, Consumer<DatarouterAccount> updateFunction, String logMessage) {
        DatarouterAccount account = this.datarouterAccountDao.get(new DatarouterAccountKey(accountName));
        updateFunction.accept(account);
        this.datarouterAccountDao.put(account);
        this.logAndRecordAction(accountName, logMessage);
        return this.getDetailsForAccountName(accountName);
    }

    private List<DatarouterAccountDetails> getDetailsForAccounts(List<DatarouterAccount> accounts) {
        ZoneId zoneId = this.currentSessionInfoService.getZoneId((ServletRequest)this.request);
        Set accountNames = (Set)Scanner.of(accounts).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).collect(HashSet::new);
        Map<String, List<AccountCredentialDto>> credentialsByAccountName = this.acccountCredentialService.getCredentialsByAccountName(accountNames, zoneId);
        Map<String, List<DatarouterAccountCredentialService.SecretCredentialDto>> secretCredentialsByAccountName = this.acccountCredentialService.getSecretCredentialsByAccountName(accountNames, zoneId);
        Map permissionsByAccountName = ((Scanner)Scanner.of((Iterable)accountNames).map(DatarouterAccountPermissionKey::new).listTo(this.datarouterAccountPermissionDao::scanKeysWithPrefixes)).map(TextPermission::create).groupBy(permission -> permission.accountName);
        return Scanner.of(accounts).map(account -> new AccountDto((DatarouterAccount)((Object)account), zoneId)).map(account -> this.getDetailsForAccount((AccountDto)account, (List)credentialsByAccountName.get(account.accountName), (List)secretCredentialsByAccountName.get(account.accountName), (List)permissionsByAccountName.get(account.accountName))).list();
    }

    private DatarouterAccountDetails getDetailsForAccount(AccountDto account, List<AccountCredentialDto> credentials, List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials, List<TextPermission> permissions) {
        String counterName = "Datarouter account name " + account.accountName;
        String metricLink = this.metricLinkBuilder.exactMetricLink(counterName);
        return new DatarouterAccountDetails(account, credentials, secretCredentials, permissions, metricLink);
    }

    public DatarouterAccountDetails getDetailsForAccountName(String accountName) {
        DatarouterAccount account = this.datarouterAccountDao.get(new DatarouterAccountKey(accountName));
        return this.getDetailsForAccounts(List.of(account)).get(0);
    }

    private void logAndRecordAction(String account, String action) {
        this.recordChangelog("DatarouterAccount", account, action);
        logger.warn("account={} action={} by={}", new Object[]{account, action, this.getCurrentUsername()});
    }

    private String getCurrentUsername() {
        return this.getSessionInfo().getNonEmptyUsernameOrElse("unknown");
    }

    private void recordChangelog(String changelogType, String name, String action) {
        this.changelogRecorder.record(changelogType, name, action, this.getCurrentUsername());
    }

    public static class AccountCredentialDto {
        public final String apiKey;
        public final String secretKey;
        public final String accountName;
        public final String created;
        public final String creatorUsername;
        public final String lastUsed;
        public final Boolean active;

        public AccountCredentialDto(DatarouterAccountCredential credential, ZoneId zoneId) {
            this.apiKey = ((DatarouterAccountCredentialKey)credential.getKey()).getApiKey();
            this.secretKey = credential.getSecretKey();
            this.accountName = credential.getAccountName();
            this.created = credential.getCreatedDate(zoneId);
            this.creatorUsername = credential.getCreatorUsername();
            this.lastUsed = credential.getLastUsedDate(zoneId);
            this.active = credential.getActive();
        }
    }

    public static class AccountDto {
        public final String accountName;
        public final String created;
        public final String creator;
        public final String lastUsed;
        public final Boolean enableUserMappings;

        public AccountDto(DatarouterAccount account, ZoneId zoneId) {
            this.accountName = ((DatarouterAccountKey)account.getKey()).getAccountName();
            this.created = account.getCreatedDate(zoneId);
            this.creator = account.getCreator();
            this.lastUsed = account.getLastUsedDate(zoneId);
            this.enableUserMappings = account.getEnableUserMappings();
        }
    }

    public static class AvailableRouteSet {
        public final String name;
        public final String className;
        public final List<String> rules;

        public AvailableRouteSet(String name, String className, List<String> rules) {
            this.name = name;
            this.className = className;
            this.rules = rules;
        }
    }

    public static class DatarouterAccountDetails {
        public final AccountDto account;
        public final List<AccountCredentialDto> credentials;
        public final List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials;
        public final List<TextPermission> permissions;
        public final String metricLink;
        public final String error;

        public DatarouterAccountDetails(AccountDto account, List<AccountCredentialDto> credentials, List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials, List<TextPermission> permissions, String metricLink) {
            this.account = account;
            this.credentials = credentials == null ? List.of() : credentials;
            this.secretCredentials = secretCredentials == null ? List.of() : secretCredentials;
            this.permissions = permissions == null ? List.of() : permissions;
            this.metricLink = metricLink;
            this.error = null;
        }

        public DatarouterAccountDetails(String error) {
            this.account = null;
            this.credentials = null;
            this.secretCredentials = null;
            this.permissions = null;
            this.metricLink = null;
            this.error = error;
        }
    }

    public static class DatarouterAccountDetailsAndKeypair {
        public final DatarouterAccountDetails details;
        public final DatarouterAccountCredentialService.DatarouterAccountSecretCredentialKeypairDto keypair;

        public DatarouterAccountDetailsAndKeypair(DatarouterAccountDetails details, DatarouterAccountCredentialService.DatarouterAccountSecretCredentialKeypairDto keypair) {
            this.details = details;
            this.keypair = keypair;
        }
    }

    public static class SetCredentialActivationDto {
        public final String apiKey;
        public final String secretName;
        public final Boolean active;
        public final String accountName;

        public SetCredentialActivationDto(String apiKey, String secretName, Boolean active, String accountName) {
            this.apiKey = apiKey;
            this.secretName = secretName;
            this.active = active;
            this.accountName = accountName;
        }
    }

    public static class TextPermission {
        public final String accountName;
        public final String endpoint;

        public TextPermission(String accountName, String endpoint) {
            this.accountName = accountName;
            this.endpoint = endpoint;
        }

        public static TextPermission create(DatarouterAccountPermissionKey permission) {
            return new TextPermission(permission.getAccountName(), permission.getEndpoint());
        }
    }
}

