/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.client;

import io.datarouter.httpclient.client.DatarouterHttpClientBuilder;
import io.datarouter.httpclient.client.SimpleDatarouterHttpClientSettings;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.duration.DatarouterDuration;
import java.time.Duration;
import java.util.function.Supplier;

public abstract class BaseSimpleDatarouterClientSettings
extends SettingNode
implements SimpleDatarouterHttpClientSettings {
    public final CachedSetting<DatarouterDuration> timeout = this.registerDurations("timeout", this.getTimeoutDefaultSettingValue());
    public final CachedSetting<Integer> numRetries = this.registerIntegers("numRetries", this.getNumRetriesDefault());
    public final CachedSetting<Boolean> enableBreakers = this.registerBooleans("enableBreakers", this.getEnableBreakersDefault());

    public BaseSimpleDatarouterClientSettings(SettingFinder finder, String settingNodeName) {
        super(finder, settingNodeName);
    }

    public final Duration getTimeout() {
        return ((DatarouterDuration)this.timeout.get()).toJavaDuration();
    }

    public final Supplier<Integer> getNumRetries() {
        return this.numRetries;
    }

    public final Supplier<Boolean> getEnableBreakers() {
        return this.enableBreakers;
    }

    protected Duration getTimeoutDefault() {
        return DatarouterHttpClientBuilder.DEFAULT_TIMEOUT;
    }

    protected DefaultSettingValue<Integer> getNumRetriesDefault() {
        return BaseSimpleDatarouterClientSettings.defaultTo((Object)1);
    }

    protected DefaultSettingValue<Boolean> getEnableBreakersDefault() {
        return BaseSimpleDatarouterClientSettings.defaultTo((Object)false);
    }

    protected DefaultSettingValue<DatarouterDuration> getTimeoutDefaultSettingValue() {
        return BaseSimpleDatarouterClientSettings.defaultTo((Object)new DatarouterDuration(this.getTimeoutDefault()));
    }
}

