/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountCredentialService;
import io.datarouter.httpclient.security.DefaultCsrfGenerator;
import io.datarouter.web.security.CsrfValidator;
import io.datarouter.web.security.DefaultCsrfValidator;
import io.datarouter.web.util.http.RequestTool;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

public class DatarouterAccountCsrfValidator
implements CsrfValidator {
    private final Long requestTimeoutMs;
    private DatarouterAccountCredentialService datarouterAccountCredentialService;

    private DatarouterAccountCsrfValidator(Long requestTimeoutMs, DatarouterAccountCredentialService datarouterAccountApiKeyService) {
        this.requestTimeoutMs = requestTimeoutMs;
        this.datarouterAccountCredentialService = datarouterAccountApiKeyService;
    }

    public boolean check(HttpServletRequest request) {
        return this.getCsrfValidatorForAccountWithApiKey(request).map(csrfValidator -> csrfValidator.check(request)).orElse(false);
    }

    public Long getRequestTimeMs(HttpServletRequest request) {
        return this.getCsrfValidatorForAccountWithApiKey(request).map(csrfValidator -> csrfValidator.getRequestTimeMs(request)).orElse(null);
    }

    private Optional<DefaultCsrfValidator> getCsrfValidatorForAccountWithApiKey(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        return this.datarouterAccountCredentialService.findSecretKeyForApiKeyAuth(apiKey).map(secretKey -> () -> secretKey).map(secretKey -> new DefaultCsrfValidator(new DefaultCsrfGenerator(secretKey), this.requestTimeoutMs));
    }

    @Singleton
    public static class DatarouterAccountCsrfValidatorFactory {
        @Inject
        private DatarouterAccountCredentialService datarouterAccountCredentialService;

        public DatarouterAccountCsrfValidator create(Long requestTimeoutMs) {
            return new DatarouterAccountCsrfValidator(requestTimeoutMs, this.datarouterAccountCredentialService);
        }
    }
}

