/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMap;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapKey;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.util.BooleanTool;
import io.datarouter.web.config.service.ServiceName;
import io.datarouter.web.user.DatarouterSessionDao;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.util.PasswordTool;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserEditService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserEditService.class);
    @Inject
    private BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao;
    @Inject
    private DatarouterUserHistoryService userHistoryService;
    @Inject
    private DatarouterSessionDao datarouterSessionDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private ServiceName serviceName;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private EnvironmentName environmentName;

    public void editUser(DatarouterUser user, DatarouterUser editor, Set<Role> requestedRoles, Boolean enabled, String signinUrl, Set<DatarouterAccountKey> requestedAccounts, Optional<ZoneId> optionalZoneId, Optional<String> description) {
        DatarouterUserHistory history = new DatarouterUserHistory(user.getId(), Instant.now(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.EDIT, null);
        ArrayList<String> changes = new ArrayList<String>();
        HashSet currentRoles = new HashSet(user.getRoles());
        boolean isUserDatarouterAdmin = currentRoles.contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole());
        if (isUserDatarouterAdmin && !requestedRoles.contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole()) && !user.equals((Object)editor)) {
            throw new RuntimeException("cannot disable datarouterAdmin user");
        }
        Set<Role> allowedRoles = this.datarouterUserService.getAllowedUserRoles(editor, requestedRoles);
        boolean shouldUpdateSessions = false;
        if (!allowedRoles.equals(currentRoles)) {
            changes.add(DatarouterUserEditService.change("roles", currentRoles, allowedRoles));
            user.setRoles(allowedRoles);
            shouldUpdateSessions = true;
        }
        boolean shouldDeleteSessions = false;
        if (enabled != null && !BooleanTool.nullSafeSame((Boolean)enabled, (Boolean)user.getEnabled())) {
            if (isUserDatarouterAdmin) {
                throw new RuntimeException("cannot disable datarouterAdmin user");
            }
            changes.add(DatarouterUserEditService.change("enabled", user.getEnabled(), enabled));
            user.setEnabled(enabled);
            shouldDeleteSessions = true;
        }
        this.handleAccountChanges(user, requestedAccounts).ifPresent(changes::add);
        optionalZoneId.ifPresent(zoneId -> {
            boolean sameZoneId;
            Optional currentZoneId = user.getZoneId();
            boolean bl = sameZoneId = currentZoneId.isPresent() && ((ZoneId)currentZoneId.get()).equals(zoneId);
            if (!sameZoneId) {
                user.setZoneId(zoneId);
                changes.add(DatarouterUserEditService.change("timezone", currentZoneId.map(ZoneId::getId).orElse(""), zoneId.getId()));
            }
        });
        if (changes.size() > 0 || description.isPresent()) {
            String colon = changes.size() > 0 && description.isPresent() ? ": " : "";
            history.setChanges(String.valueOf(description.orElse("")) + colon + String.join((CharSequence)", ", changes));
            this.userHistoryService.putAndRecordRoleEdit(user, history, signinUrl);
            if (shouldUpdateSessions || shouldDeleteSessions) {
                Scanner sessions = this.datarouterSessionDao.scan().include(session -> session.getUserToken().equals(user.getUserToken()));
                if (shouldDeleteSessions) {
                    sessions.map(BaseDatabean::getKey).flush(arg_0 -> ((DatarouterSessionDao)this.datarouterSessionDao).deleteMulti(arg_0));
                } else {
                    sessions.each(session -> session.setRoles(user.getRoles())).flush(arg_0 -> ((DatarouterSessionDao)this.datarouterSessionDao).putMulti(arg_0));
                }
            }
            ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Admin Edit User", "User Edited - " + user.getUsername(), "Edit", editor.getUsername()).withComment(String.join((CharSequence)", ", changes)).build();
            this.changelogRecorder.record(dto);
        } else {
            logger.warn("User {} submitted edit request for user {}, but no changes were made.", (Object)editor.toString(), (Object)user.toString());
        }
    }

    private Optional<String> handleAccountChanges(DatarouterUser user, Set<DatarouterAccountKey> requestedAccounts) {
        Set currentAccounts = (Set)this.datarouterUserAccountMapDao.scanKeysWithPrefix(new DatarouterUserAccountMapKey(user.getId(), null)).collect(HashSet::new);
        Set<DatarouterUserAccountMapKey> accountsToDelete = currentAccounts.stream().filter(currentAccountKey -> !requestedAccounts.contains((Object)currentAccountKey.getDatarouterAccountKey())).collect(Collectors.toSet());
        Set<DatarouterUserAccountMap> accountsToAdd = requestedAccounts.stream().map(accountKey -> new DatarouterUserAccountMap(user.getId(), accountKey.getAccountName())).filter(requestedAccount -> !currentAccounts.contains(requestedAccount.getKey())).collect(Collectors.toSet());
        if (!accountsToDelete.isEmpty() || !accountsToAdd.isEmpty()) {
            if (!accountsToDelete.isEmpty()) {
                this.datarouterUserAccountMapDao.deleteMulti(accountsToDelete);
            }
            if (!accountsToAdd.isEmpty()) {
                this.datarouterUserAccountMapDao.putMulti(accountsToAdd);
            }
            String original = currentAccounts.stream().map(DatarouterUserAccountMapKey::getDatarouterAccountKey).map(DatarouterAccountKey::getAccountName).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining(","));
            String current = requestedAccounts.stream().map(DatarouterAccountKey::getAccountName).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining(","));
            return Optional.of(DatarouterUserEditService.change("accounts", original, current));
        }
        return Optional.empty();
    }

    public void changePassword(DatarouterUser user, DatarouterUser editor, String newPassword, String signinUrl) {
        DatarouterUserHistory history = new DatarouterUserHistory(user.getId(), Instant.now(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.RESET, null);
        this.updateUserPassword(user, newPassword);
        history.setChanges("password");
        this.userHistoryService.putAndRecordPasswordChange(user, history, signinUrl);
    }

    private void updateUserPassword(DatarouterUser user, String password) {
        String passwordSalt = PasswordTool.generateSalt();
        String passwordDigest = PasswordTool.digest((String)passwordSalt, (String)password);
        user.setPasswordSalt(passwordSalt);
        user.setPasswordDigest(passwordDigest);
    }

    private static String change(String name, Object before, Object after) {
        return String.valueOf(name) + ": " + before + " => " + after;
    }

    public String getPermissionRequestEmailSubject(DatarouterUser user) {
        return String.format("Permission Request %s - %s - %s", user.getUsername(), this.environmentName.get(), this.serviceName.get());
    }
}

