/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.Upload;
import io.datarouter.aws.s3.AwsSdkV2ToV1CredentialsProvider;
import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.S3Headers;
import io.datarouter.aws.s3.SerializableAwsCredentialsProviderProvider;
import io.datarouter.bytes.ByteUnitTool;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.node.op.raw.read.DirectoryDto;
import io.datarouter.util.Require;
import io.datarouter.util.concurrent.ThreadTool;
import io.datarouter.util.io.ReaderTool;
import io.datarouter.util.number.NumberFormatter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;

public abstract class BaseDatarouterS3Client
implements DatarouterS3Client,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(BaseDatarouterS3Client.class);
    private static final Pattern EXPECTED_REGION_EXTRACTOR = Pattern.compile("expecting '(.*)'");
    private static final int MIN_UPLOAD_PART_SIZE_BYTES = 0x500000;
    private static final Region DEFAULT_REGION = Region.US_EAST_1;
    private final SerializableAwsCredentialsProviderProvider<?> awsCredentialsProviderProvider;
    private transient Map<Region, S3Client> s3ClientByRegion;
    private transient Map<String, Region> regionByBucket;
    private transient S3Presigner s3Presigner;
    private transient Map<Region, TransferManager> transferManagerByRegion;

    public BaseDatarouterS3Client(SerializableAwsCredentialsProviderProvider<?> awsCredentialsProviderProvider) {
        this.awsCredentialsProviderProvider = awsCredentialsProviderProvider;
        this.init();
    }

    public Object readResolve() {
        this.init();
        return this;
    }

    private void init() {
        this.s3ClientByRegion = new ConcurrentHashMap<Region, S3Client>();
        this.regionByBucket = new ConcurrentHashMap<String, Region>();
        this.transferManagerByRegion = new ConcurrentHashMap<Region, TransferManager>();
        this.s3ClientByRegion.put(DEFAULT_REGION, this.createClient(DEFAULT_REGION));
        this.s3Presigner = S3Presigner.builder().credentialsProvider(this.awsCredentialsProviderProvider.get()).region(DEFAULT_REGION).build();
    }

    @Override
    public Scanner<Bucket> scanBuckets() {
        S3Client client = this.getS3ClientForRegion(DEFAULT_REGION);
        ListBucketsResponse response = client.listBuckets();
        return Scanner.of((Iterable)response.buckets());
    }

    @Override
    public void copyObject(String bucket, String sourceKey, String destinationKey, ObjectCannedACL acl) {
        CopyObjectRequest request = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(bucket).sourceKey(sourceKey).destinationBucket(bucket).destinationKey(destinationKey).acl(acl).build();
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 copyObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            s3Client.copyObject(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void deleteObject(String bucket, String key) {
        DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build();
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 deleteObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            s3Client.deleteObject(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putObjectWithHeartbeat(String bucket, String key, S3Headers.ContentType contentType, Path path, Runnable heartbeat) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, key, path.toFile());
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(contentType.getMimeType());
        putObjectRequest.setMetadata(metadata);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 upload", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            Upload upload = this.getTransferManagerForBucket(bucket).upload(putObjectRequest);
            this.handleTransfer((Transfer)upload, heartbeat);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public BufferedWriter putAsWriter(String bucket, String key, S3Headers.ContentType contentType) {
        return new BufferedWriter(new OutputStreamWriter(this.put(bucket, key, contentType)));
    }

    @Override
    public OutputStream putWithPublicRead(String bucket, String key, S3Headers.S3ContentType contentType) {
        return this.put(bucket, key, contentType, Optional.of(ObjectCannedACL.PUBLIC_READ));
    }

    @Override
    public OutputStream put(String bucket, String key, S3Headers.S3ContentType contentType) {
        return this.put(bucket, key, contentType, Optional.empty());
    }

    private OutputStream put(final String bucket, final String key, S3Headers.S3ContentType contentType, Optional<ObjectCannedACL> aclOpt) {
        CreateMultipartUploadResponse response;
        final S3Client s3Client = this.getS3ClientForBucket(bucket);
        CreateMultipartUploadRequest request = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().acl((ObjectCannedACL)aclOpt.orElse(null)).bucket(bucket).key(key).contentType(contentType.getMimeType()).build();
        Throwable throwable = null;
        Object var9_9 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 createMultipartUpload", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            response = s3Client.createMultipartUpload(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        final String uploadId = response.uploadId();
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        final ArrayList completedParts = new ArrayList();
        return new OutputStream(){
            private boolean closed;

            private void uploadPart() {
                UploadPartResponse response;
                UploadPartRequest uploadPartRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(bucket).key(key).uploadId(uploadId).partNumber(Integer.valueOf(completedParts.size() + 1)).build();
                RequestBody requestBody = RequestBody.fromBytes((byte[])buffer.toByteArray());
                Throwable throwable = null;
                Object var5_5 = null;
                try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 uploadPart", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
                    response = s3Client.uploadPart(uploadPartRequest, requestBody);
                    TracerTool.appendToSpanInfo((String)"Content-Length", (Object)uploadPartRequest.contentLength());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                String eTag = response.eTag();
                CompletedPart completedPart = (CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(completedParts.size() + 1)).eTag(eTag).build();
                completedParts.add(completedPart);
                buffer.reset();
            }

            private void checkBufferSize() {
                if (buffer.size() > 0x500000) {
                    this.uploadPart();
                }
            }

            @Override
            public void write(int by) {
                Require.isFalse((boolean)this.closed);
                buffer.write(by);
                this.checkBufferSize();
            }

            @Override
            public void write(byte[] by, int off, int len) {
                Require.isFalse((boolean)this.closed);
                buffer.write(by, off, len);
                this.checkBufferSize();
            }

            @Override
            public void close() {
                this.uploadPart();
                CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts((Collection)completedParts).build();
                CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(bucket).key(key).uploadId(uploadId).multipartUpload(completedMultipartUpload).build();
                Throwable throwable = null;
                Object var4_5 = null;
                try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 completeMultipartUpload", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
                    s3Client.completeMultipartUpload(completeMultipartUploadRequest);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.closed = true;
            }
        };
    }

    @Override
    public void putObjectAsString(String bucket, String key, S3Headers.ContentType contentType, String content) {
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        software.amazon.awssdk.services.s3.model.PutObjectRequest request = BaseDatarouterS3Client.makePutObjectRequest(bucket, key, contentType);
        RequestBody requestBody = RequestBody.fromString((String)content);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 putObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            s3Client.putObject(request, requestBody);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)request.contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putObjectAsBytes(String bucket, String key, S3Headers.ContentType contentType, String cacheControl, ObjectCannedACL acl, byte[] bytes) {
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        software.amazon.awssdk.services.s3.model.PutObjectRequest request = (software.amazon.awssdk.services.s3.model.PutObjectRequest)BaseDatarouterS3Client.makePutObjectRequestBuilder(bucket, key, contentType).cacheControl(cacheControl).acl(acl).build();
        RequestBody requestBody = RequestBody.fromBytes((byte[])bytes);
        Throwable throwable = null;
        Object var11_12 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 putObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            s3Client.putObject(request, requestBody);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)request.contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putObjectAsBytesWithExpirationTime(String bucket, String key, S3Headers.ContentType contentType, String cacheControl, ObjectCannedACL acl, byte[] bytes, Instant expirationTime) {
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        software.amazon.awssdk.services.s3.model.PutObjectRequest request = (software.amazon.awssdk.services.s3.model.PutObjectRequest)BaseDatarouterS3Client.makePutObjectRequestBuilder(bucket, key, contentType).cacheControl(cacheControl).acl(acl).expires(expirationTime).build();
        RequestBody requestBody = RequestBody.fromBytes((byte[])bytes);
        Throwable throwable = null;
        Object var12_13 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 putObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            s3Client.putObject(request, requestBody);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)request.contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void putPublicObject(String bucket, String key, S3Headers.ContentType contentType, Path path) {
        this.putObjectWithAcl(bucket, key, contentType, path, ObjectCannedACL.PUBLIC_READ);
    }

    @Override
    public void putObject(String bucket, String key, S3Headers.ContentType contentType, Path path) {
        this.putObjectWithAcl(bucket, key, contentType, path, ObjectCannedACL.PRIVATE);
    }

    @Override
    public void downloadFilesToDirectory(String bucket, String prefix, Path path) {
        this.scanObjects(bucket, prefix).map(S3Object::key).forEach(key -> {
            Path path2 = this.downloadFileToDirectory(bucket, (String)key, path);
        });
    }

    @Override
    public Path downloadFileToDirectory(String bucket, String key, Path path) {
        Path filePath = path.resolve(key);
        this.downloadFile(bucket, key, filePath);
        return filePath;
    }

    @Override
    public void downloadFile(String bucket, String key, Path path) {
        BaseDatarouterS3Client.prepareFileDestination(path);
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        GetObjectRequest request = BaseDatarouterS3Client.makeGetObjectRequest(bucket, key);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 getObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            GetObjectResponse response = (GetObjectResponse)s3Client.getObject(request, ResponseTransformer.toFile((Path)path));
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)response.contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void downloadFileWithHeartbeat(String bucket, String key, Path path, Runnable heartbeat) {
        BaseDatarouterS3Client.prepareFileDestination(path);
        TransferManager transferManager = this.getTransferManagerForBucket(bucket);
        Throwable throwable = null;
        Object var8_8 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 download", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            Download download = transferManager.download(bucket, key, path.toFile());
            this.handleTransfer((Transfer)download, heartbeat);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Scanner<List<String>> scanBatchesOfLinesWithPrefix(String bucket, String prefix, int batchSize) {
        return this.scanObjects(bucket, prefix).map(S3Object::key).concat(key -> this.scanBatchesOfLines(bucket, (String)key, batchSize));
    }

    @Override
    public Scanner<String> scanLines(String bucket, String key) {
        return ReaderTool.lines((BufferedReader)new BufferedReader(new InputStreamReader(this.getObject(bucket, key))));
    }

    @Override
    public Scanner<List<String>> scanBatchesOfLines(String bucket, String key, int batchSize) {
        return this.scanLines(bucket, key).batch(batchSize);
    }

    @Override
    public ResponseInputStream<GetObjectResponse> getObjectResponse(String bucket, String key) {
        ResponseInputStream response;
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        GetObjectRequest request = BaseDatarouterS3Client.makeGetObjectRequest(bucket, key);
        Throwable throwable = null;
        Object var7_7 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 getObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            response = s3Client.getObject(request);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)((GetObjectResponse)response.response()).contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return response;
    }

    @Override
    public InputStream getObject(String bucket, String key) {
        return this.getObjectResponse(bucket, key);
    }

    @Override
    public byte[] getObjectAsBytes(String bucket, String key) {
        ResponseBytes response;
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        GetObjectRequest request = BaseDatarouterS3Client.makeGetObjectRequest(bucket, key);
        Throwable throwable = null;
        Object var7_7 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 getObjectAsBytes", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            response = s3Client.getObjectAsBytes(request);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)((GetObjectResponse)response.response()).contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return response.asByteArray();
    }

    @Override
    public byte[] getPartialObject(String bucket, String key, long offset, int length) {
        ResponseBytes response;
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        GetObjectRequest request = BaseDatarouterS3Client.makeGetPartialObjectRequest(bucket, key, offset, length);
        Throwable throwable = null;
        Object var10_9 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 getPartialObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            response = s3Client.getObjectAsBytes(request);
            TracerTool.appendToSpanInfo((String)"offset", (Object)offset);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)((GetObjectResponse)response.response()).contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return response.asByteArray();
    }

    @Override
    public String getObjectAsString(String bucket, String key) {
        return new String(this.getObjectAsBytes(bucket, key));
    }

    @Override
    public Optional<Long> length(String bucket, String key) {
        return this.headObject(bucket, key).map(HeadObjectResponse::contentLength);
    }

    @Override
    public Optional<Instant> findLastModified(String bucket, String key) {
        return this.headObject(bucket, key).map(HeadObjectResponse::lastModified);
    }

    @Override
    public Optional<S3Object> findLastModifiedObjectWithPrefix(String bucket, String prefix) {
        return this.scanObjects(bucket, prefix).findMax(Comparator.comparing(S3Object::lastModified));
    }

    @Override
    public URL generateLink(String bucket, String key, Duration expireAfter) {
        return this.s3Presigner.presignGetObject(GetObjectPresignRequest.builder().getObjectRequest(BaseDatarouterS3Client.makeGetObjectRequest(bucket, key)).signatureDuration(expireAfter).build()).url();
    }

    @Override
    public Scanner<List<S3Object>> scanObjectsPaged(String bucket, String prefix) {
        ListObjectsV2Request requestBuilder = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).prefix(prefix).build();
        ListObjectsV2Iterable paginator = this.getS3ClientForBucket(bucket).listObjectsV2Paginator(requestBuilder);
        return Scanner.of((Iterable)paginator).map(ListObjectsV2Response::contents);
    }

    @Override
    public Scanner<S3Object> scanObjects(String bucket, String prefix, String startAfter, String delimiter) {
        ListObjectsV2Request.Builder requestBuilder = ListObjectsV2Request.builder().bucket(bucket);
        Optional.ofNullable(prefix).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)requestBuilder).prefix(arg_0));
        Optional.ofNullable(startAfter).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)requestBuilder).startAfter(arg_0));
        Optional.ofNullable(delimiter).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)requestBuilder).delimiter(arg_0));
        ListObjectsV2Iterable responsePages = this.getS3ClientForBucket(bucket).listObjectsV2Paginator((ListObjectsV2Request)requestBuilder.build());
        return Scanner.of((Iterable)responsePages).concatIter(ListObjectsV2Response::contents);
    }

    @Override
    public Scanner<String> scanPrefixes(String bucket, String prefix, String startAfter, String delimiter) {
        ListObjectsV2Request.Builder requestBuilder = ListObjectsV2Request.builder().bucket(bucket);
        Optional.ofNullable(prefix).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)requestBuilder).prefix(arg_0));
        Optional.ofNullable(startAfter).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)requestBuilder).startAfter(arg_0));
        Optional.ofNullable(delimiter).ifPresent(arg_0 -> ((ListObjectsV2Request.Builder)requestBuilder).delimiter(arg_0));
        ListObjectsV2Iterable responsePages = this.getS3ClientForBucket(bucket).listObjectsV2Paginator((ListObjectsV2Request)requestBuilder.build());
        return Scanner.of((Iterable)responsePages).concatIter(ListObjectsV2Response::commonPrefixes).map(CommonPrefix::prefix);
    }

    @Override
    public List<String> getCommonPrefixes(String bucket, String prefix, String delimiter) {
        ListObjectsV2Response response;
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).prefix(prefix).delimiter(delimiter).build();
        Throwable throwable = null;
        Object var8_8 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 listObjectsV2", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            response = s3Client.listObjectsV2(request);
            TracerTool.appendToSpanInfo((String)"size", (Object)response.contents().size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return response.commonPrefixes().stream().map(CommonPrefix::prefix).collect(Collectors.toList());
    }

    @Override
    public Scanner<DirectoryDto> scanSubdirectories(String bucket, String prefix, String startAfter, String delimiter, int pageSize, boolean currentDirectory) {
        ListObjectsV2Iterable pages;
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucket).prefix(prefix).startAfter(startAfter).delimiter(delimiter).maxKeys(Integer.valueOf(pageSize)).build();
        Throwable throwable = null;
        Object var10_10 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 listObjectsV2Paginator", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            pages = this.getS3ClientForBucket(bucket).listObjectsV2Paginator(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Scanner.of((Iterable)pages).map(res -> {
            Scanner objects = Scanner.of((Iterable)res.contents()).map(object -> new DirectoryDto(object.key(), false, object.size(), object.lastModified(), object.storageClass().name()));
            Scanner prefixes = Scanner.of((Iterable)res.commonPrefixes()).map(commonPrefix -> new DirectoryDto(commonPrefix.prefix(), true, Long.valueOf(0L), null, null));
            return Scanner.concat((Scanner[])new Scanner[]{objects, prefixes});
        }).concat(Function.identity());
    }

    @Override
    public boolean exists(String bucket, String key) {
        return this.headObject(bucket, key).isPresent();
    }

    @Override
    public boolean existsPrefix(String bucket, String prefix) {
        return this.scanObjects(bucket, prefix).hasAny();
    }

    @Override
    public Region getCachedOrLatestRegionForBucket(String bucket) {
        return this.regionByBucket.computeIfAbsent(bucket, this::getBucketRegion);
    }

    private void putObjectWithAcl(String bucket, String key, S3Headers.ContentType contentType, Path path, ObjectCannedACL acl) {
        S3Client s3Client = this.getS3ClientForBucket(bucket);
        software.amazon.awssdk.services.s3.model.PutObjectRequest request = (software.amazon.awssdk.services.s3.model.PutObjectRequest)BaseDatarouterS3Client.makePutObjectRequestBuilder(bucket, key, contentType).acl(acl).build();
        RequestBody requestBody = RequestBody.fromFile((Path)path);
        Throwable throwable = null;
        Object var10_11 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 putObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
            s3Client.putObject(request, requestBody);
            TracerTool.appendToSpanInfo((String)"Content-Length", (Object)request.contentLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void handleTransfer(Transfer transfer, Runnable heartbeat) {
        TransferProgress progress = transfer.getProgress();
        long totalBytesToTransfer = progress.getTotalBytesToTransfer();
        while (!transfer.isDone()) {
            try {
                heartbeat.run();
            }
            catch (Exception e) {
                logger.error("couldn't heartbeat", (Throwable)e);
            }
            logger.warn("{} / {} pct={} bytesTransferred={} totalBytesToTransfer={}", new Object[]{ByteUnitTool.byteCountToDisplaySize((long)progress.getBytesTransferred()), ByteUnitTool.byteCountToDisplaySize((long)totalBytesToTransfer), NumberFormatter.format((Number)progress.getPercentTransferred(), (int)2), progress.getBytesTransferred(), totalBytesToTransfer});
            ThreadTool.sleepUnchecked((long)1000L);
        }
    }

    private Optional<HeadObjectResponse> headObject(String bucket, String key) {
        try {
            HeadObjectResponse response;
            S3Client s3Client = this.getS3ClientForBucket(bucket);
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(key).build();
            Throwable throwable = null;
            Object var7_8 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 headObject", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
                response = s3Client.headObject(request);
                TracerTool.appendToSpanInfo((String)"Content-Length", (Object)response.contentLength());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return Optional.of(response);
        }
        catch (NoSuchKeyException e) {
            return Optional.empty();
        }
    }

    private TransferManager getTransferManagerForBucket(String bucket) {
        Region region = this.regionByBucket.computeIfAbsent(bucket, this::getBucketRegion);
        return this.transferManagerByRegion.computeIfAbsent(region, this::createTransferManager);
    }

    private S3Client getS3ClientForRegion(Region region) {
        return this.s3ClientByRegion.computeIfAbsent(region, this::createClient);
    }

    private S3Client getS3ClientForBucket(String bucket) {
        Region region = this.regionByBucket.computeIfAbsent(bucket, this::getBucketRegion);
        return this.getS3ClientForRegion(region);
    }

    @Override
    public Region getBucketRegion(String bucket) {
        String region;
        S3Client s3Client = this.s3ClientByRegion.get(DEFAULT_REGION);
        try {
            GetBucketLocationResponse response;
            GetBucketLocationRequest request = (GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(bucket).build();
            Throwable throwable = null;
            Object var7_10 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 getBucketLocation", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
                response = s3Client.getBucketLocation(request);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            region = response.locationConstraintAsString();
        }
        catch (NoSuchBucketException e) {
            throw new RuntimeException("bucket not found name=" + bucket, e);
        }
        catch (S3Exception e) {
            Matcher matcher = EXPECTED_REGION_EXTRACTOR.matcher(e.getMessage());
            if (matcher.find()) {
                region = matcher.group(1);
            }
            try {
                HeadBucketResponse response;
                HeadBucketRequest request = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucket).build();
                Throwable throwable = null;
                Object var9_19 = null;
                try (TraceSpanFinisher $ = TracerTool.startSpan((String)"S3 headBucket", (TraceSpanGroupType)TraceSpanGroupType.CLOUD_STORAGE);){
                    response = s3Client.headBucket(request);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                region = (String)response.sdkHttpResponse().firstMatchingHeader("x-amz-bucket-region").get();
            }
            catch (S3Exception e2) {
                region = (String)e2.awsErrorDetails().sdkHttpResponse().firstMatchingHeader("x-amz-bucket-region").get();
            }
        }
        return region.isEmpty() ? DEFAULT_REGION : Region.of((String)region);
    }

    private S3Client createClient(Region region) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.awsCredentialsProviderProvider.get())).region(region)).httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder().maxConnections(Integer.valueOf(50000)))).build();
    }

    private TransferManager createTransferManager(Region region) {
        return TransferManagerBuilder.standard().withS3Client((AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.fromName((String)region.id()))).withCredentials((AWSCredentialsProvider)new AwsSdkV2ToV1CredentialsProvider(this.awsCredentialsProviderProvider.get()))).build()).build();
    }

    private static GetObjectRequest makeGetObjectRequest(String bucket, String key) {
        return (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
    }

    private static GetObjectRequest makeGetPartialObjectRequest(String bucket, String key, long offset, int length) {
        long startInclusive = offset;
        long endInclusive = offset + (long)length - 1L;
        String range = "bytes=" + startInclusive + "-" + endInclusive;
        return (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).range(range).build();
    }

    private static PutObjectRequest.Builder makePutObjectRequestBuilder(String bucket, String key, S3Headers.ContentType contentType) {
        return software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(bucket).key(key).contentType(contentType.getMimeType());
    }

    private static software.amazon.awssdk.services.s3.model.PutObjectRequest makePutObjectRequest(String bucket, String key, S3Headers.ContentType contentType) {
        return (software.amazon.awssdk.services.s3.model.PutObjectRequest)BaseDatarouterS3Client.makePutObjectRequestBuilder(bucket, key, contentType).build();
    }

    private static void prepareFileDestination(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

