/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3;

import io.datarouter.aws.s3.S3Headers;
import io.datarouter.bytes.split.ChunkScannerTool;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.node.op.raw.read.DirectoryDto;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.S3Object;

public interface DatarouterS3Client {
    public Scanner<Bucket> scanBuckets();

    public Region getBucketRegion(String var1);

    public void copyObject(String var1, String var2, String var3, ObjectCannedACL var4);

    public void deleteObject(String var1, String var2);

    public void putObjectWithHeartbeat(String var1, String var2, S3Headers.ContentType var3, Path var4, Runnable var5);

    public BufferedWriter putAsWriter(String var1, String var2, S3Headers.ContentType var3);

    public OutputStream putWithPublicRead(String var1, String var2, S3Headers.S3ContentType var3);

    public OutputStream put(String var1, String var2, S3Headers.S3ContentType var3);

    default public void put(String bucket, String key, S3Headers.S3ContentType contentType, InputStream inputStream) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream outputStream = this.put(bucket, key, contentType);){
                inputStream.transferTo(outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void putObjectAsString(String var1, String var2, S3Headers.ContentType var3, String var4);

    public void putObjectAsBytes(String var1, String var2, S3Headers.ContentType var3, String var4, ObjectCannedACL var5, byte[] var6);

    public void putObjectAsBytesWithExpirationTime(String var1, String var2, S3Headers.ContentType var3, String var4, ObjectCannedACL var5, byte[] var6, Instant var7);

    public void putPublicObject(String var1, String var2, S3Headers.ContentType var3, Path var4);

    public void putObject(String var1, String var2, S3Headers.ContentType var3, Path var4);

    public void downloadFilesToDirectory(String var1, String var2, Path var3);

    public Path downloadFileToDirectory(String var1, String var2, Path var3);

    public void downloadFile(String var1, String var2, Path var3);

    public void downloadFileWithHeartbeat(String var1, String var2, Path var3, Runnable var4);

    public Scanner<List<String>> scanBatchesOfLinesWithPrefix(String var1, String var2, int var3);

    public Scanner<String> scanLines(String var1, String var2);

    public Scanner<List<String>> scanBatchesOfLines(String var1, String var2, int var3);

    public ResponseInputStream<GetObjectResponse> getObjectResponse(String var1, String var2);

    public InputStream getObject(String var1, String var2);

    public byte[] getObjectAsBytes(String var1, String var2);

    public byte[] getPartialObject(String var1, String var2, long var3, int var5);

    default public Scanner<byte[]> scanObjectChunks(String bucket, String key, ExecutorService exec, int numThreads, int chunkSize) {
        long totalLength = this.length(bucket, key).orElseThrow();
        return ChunkScannerTool.scanChunks((long)totalLength, (int)chunkSize).parallel(new ParallelScannerContext(exec, numThreads, false)).map(range -> this.getPartialObject(bucket, key, range.start, range.length));
    }

    public String getObjectAsString(String var1, String var2);

    public Optional<Long> length(String var1, String var2);

    public Optional<Instant> findLastModified(String var1, String var2);

    public Optional<S3Object> findLastModifiedObjectWithPrefix(String var1, String var2);

    public URL generateLink(String var1, String var2, Duration var3);

    public Scanner<List<S3Object>> scanObjectsPaged(String var1, String var2);

    default public Scanner<S3Object> scanObjects(String bucket, String prefix) {
        return this.scanObjectsPaged(bucket, prefix).concat(Scanner::of);
    }

    public Scanner<S3Object> scanObjects(String var1, String var2, String var3, String var4);

    public Scanner<String> scanPrefixes(String var1, String var2, String var3, String var4);

    public List<String> getCommonPrefixes(String var1, String var2, String var3);

    public Scanner<DirectoryDto> scanSubdirectories(String var1, String var2, String var3, String var4, int var5, boolean var6);

    public boolean exists(String var1, String var2);

    public boolean existsPrefix(String var1, String var2);

    public Region getCachedOrLatestRegionForBucket(String var1);
}

