/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3;

import io.datarouter.enums.DatarouterEnumTool;
import io.datarouter.enums.PersistentString;
import io.datarouter.enums.StringEnum;
import java.time.Duration;

public class S3Headers {
    public static final String KEY_ACL = "x-amz-acl";
    public static final String KEY_CONTENT_TYPE = "Content-Type";
    public static final String KEY_EXPIRES = "Expires";
    public static final String KEY_CACHE_CONTROL = "Cache-Control";
    public static final String ACL_PUBLIC_READ = "public-read";
    public static final String ACL_PRIVATE = "";
    public static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    public static final String CACHE_CONTROL_MINUTES_20 = S3Headers.makeCacheControlString(Duration.ofMinutes(20L));
    public static final String CACHE_CONTROL_WEEKS_1 = S3Headers.makeCacheControlString(Duration.ofDays(7L));
    public static final String CACHE_CONTROL_MONTHS_1 = S3Headers.makeCacheControlString(Duration.ofDays(30L));
    public static final String CACHE_CONTROL_YEARS_10 = S3Headers.makeCacheControlString(Duration.ofDays(3650L));

    private static String makeCacheControlString(Duration duration) {
        long seconds = duration.toSeconds();
        return "max-age=" + seconds + ", public";
    }

    public static final String getExtensionForContentType(String contentType) {
        ContentType type = ContentType.fromMimeType(contentType);
        if (type == null) {
            return null;
        }
        return type.getExtension();
    }

    public static enum ContentType implements StringEnum<ContentType>,
    S3ContentType
    {
        PNG("image/png", "png"),
        JPEG("image/jpeg", "jpg"),
        SWF("application/x-shockwave-flash", "swf"),
        TEXT_PLAIN("text/plain", "txt"),
        TEXT_CSV("text/csv", "csv"),
        TEXT_TSV("text/tsv", "tsv"),
        TEXT_XML("text/xml", "xml"),
        TEXT_SHELLSCRIPT("text/x-shellscript", "sh"),
        APPLICATION_JSON("application/json", "json"),
        APPLICATION_XML("application/xml", null),
        TEXT_HTML("text/html", "html"),
        MULTIPART_MIXED("multipart/mixed", null),
        GZIP("application/x-gzip", "gz"),
        ZIP("application/zip", "zip"),
        BINARY("binary/octet-stream", null),
        APPLICATION_OCTET_STREAM("application/octet-stream", null),
        PDF("application/pdf", "pdf"),
        MP3("audio/mpeg", "mp3");

        private final String mimeType;
        private final String extension;

        private ContentType(String mimeType, String extension) {
            this.mimeType = mimeType;
            this.extension = extension;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        public String getExtension() {
            return this.extension;
        }

        public static ContentType fromExtension(String ext) {
            ext = ext.toLowerCase();
            ContentType[] contentTypeArray = ContentType.values();
            int n = contentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentType type = contentTypeArray[n2];
                if (ext.equals(type.getExtension())) {
                    return type;
                }
                ++n2;
            }
            return APPLICATION_XML;
        }

        public String getPersistentString() {
            return this.mimeType;
        }

        public ContentType fromPersistentString(String mimeType) {
            return ContentType.fromMimeType(mimeType);
        }

        public static ContentType fromMimeType(String mimeType) {
            return (ContentType)DatarouterEnumTool.getEnumFromString((PersistentString[])ContentType.values(), (String)mimeType, null);
        }
    }

    public static interface S3ContentType {
        public String getMimeType();
    }
}

