/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3;

import io.datarouter.util.Require;
import java.util.regex.Pattern;

public class S3Tool {
    public static final String S3_ENDPOINT = "https://s3.amazonaws.com";
    public static final Pattern S3_KEY_NON_SAFE_CHARACTERS = Pattern.compile("[^0-9a-zA-Z\\!\\-\\_\\.\\*\\'\\(\\)]");

    public static String replaceS3KeyNonSafeCharacters(String input, String defaultReplacement) {
        if (input == null) {
            return input;
        }
        Require.isFalse((boolean)S3_KEY_NON_SAFE_CHARACTERS.matcher(defaultReplacement).find());
        return S3_KEY_NON_SAFE_CHARACTERS.matcher(input).replaceAll(defaultReplacement);
    }
}

