/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.client;

import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.SerializableStaticAwsCredentialsProviderProvider;
import io.datarouter.aws.s3.client.GenericDatarouterS3Client;
import io.datarouter.aws.s3.client.S3Options;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.timer.PhaseTimer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class S3ClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(S3ClientManager.class);
    @Inject
    private S3Options options;
    private final Map<ClientId, DatarouterS3Client> clientByClientId = new ConcurrentHashMap<ClientId, DatarouterS3Client>();

    public DatarouterS3Client getClient(ClientId clientId) {
        this.initClient(clientId);
        return this.clientByClientId.get(clientId);
    }

    protected void safeInitClient(ClientId clientId) {
        if (this.clientByClientId.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already exists");
        }
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        DatarouterS3Client client = this.create(clientId);
        this.clientByClientId.put(clientId, client);
        timer.add("create");
        logger.warn("{}", (Object)timer);
    }

    private DatarouterS3Client create(ClientId clientId) {
        SerializableStaticAwsCredentialsProviderProvider awsCredentialsProvider = this.options.makeCredentialsProvider(clientId.getName());
        return new GenericDatarouterS3Client(awsCredentialsProvider);
    }

    public void shutdown(ClientId clientId) {
    }
}

