/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.client;

import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.S3ClientType;
import io.datarouter.aws.s3.client.S3ClientManager;
import io.datarouter.aws.s3.node.S3DirectoryManager;
import io.datarouter.aws.s3.node.S3Node;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.BaseClientNodeFactory;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.client.imp.WrappedNodeFactory;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.DefaultEntity;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class S3ClientNodeFactory
extends BaseClientNodeFactory
implements BlobClientNodeFactory {
    @Inject
    private S3ClientType s3ClientType;
    @Inject
    private S3ClientManager s3ClientManager;

    protected <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> WrappedNodeFactory<EK, E, PK, D, F, ?> makeWrappedNodeFactory() {
        return new S3WrappedNodeFactory();
    }

    public BlobStorage.PhysicalBlobStorageNode createBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> nodeParams) {
        return this.createInternal(nodeParams);
    }

    private S3Node createInternal(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> nodeParams) {
        DatarouterS3Client client = this.s3ClientManager.getClient(nodeParams.getClientId());
        String bucket = nodeParams.getPhysicalName();
        Subpath path = nodeParams.getPath();
        S3DirectoryManager s3DirectoryManager = new S3DirectoryManager(client, bucket, path);
        return new S3Node(nodeParams, this.s3ClientType, client, s3DirectoryManager);
    }

    public class S3WrappedNodeFactory
    extends WrappedNodeFactory<PathbeanKey, DefaultEntity<PathbeanKey>, PathbeanKey, Pathbean, Pathbean.PathbeanFielder, BlobStorage.PhysicalBlobStorageNode> {
        protected BlobStorage.PhysicalBlobStorageNode createNode(EntityNodeParams<PathbeanKey, DefaultEntity<PathbeanKey>> entityNodeParams, NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> nodeParams) {
            return S3ClientNodeFactory.this.createInternal(nodeParams);
        }

        public List<UnaryOperator<BlobStorage.PhysicalBlobStorageNode>> getAdapters() {
            return List.of();
        }
    }
}

