/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.client;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import java.util.Properties;

public class S3ClientOptionsBuilder
implements ClientOptionsBuilder {
    private final String clientName;
    private final Properties properties;

    public S3ClientOptionsBuilder(ClientId clientId) {
        this.clientName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientName), "s3");
    }

    public S3ClientOptionsBuilder withCredentialsLocation(String accessKeyLocation) {
        String optionKey = this.makeKey("credentials.location");
        this.properties.setProperty(optionKey, accessKeyLocation);
        return this;
    }

    public S3ClientOptionsBuilder withAccessKey(String accessKey) {
        String optionKey = this.makeKey("accessKey");
        this.properties.setProperty(optionKey, accessKey);
        return this;
    }

    public S3ClientOptionsBuilder withSecretKey(String secretKey) {
        String optionKey = this.makeKey("secretKey");
        this.properties.setProperty(optionKey, secretKey);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientName, (String)suffix);
    }
}

