/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.client;

import io.datarouter.aws.s3.SerializableStaticAwsCredentialsProviderProvider;
import io.datarouter.secret.op.SecretOpConfig;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secret.service.SecretNamespacer;
import io.datarouter.secret.service.SecretService;
import io.datarouter.storage.client.ClientOptions;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class S3Options {
    private static final Logger logger = LoggerFactory.getLogger(S3Options.class);
    protected static final String PROP_credentialsLocation = "credentials.location";
    protected static final String PROP_accessKey = "accessKey";
    protected static final String PROP_secretKey = "secretKey";
    private final ConcurrentHashMap<String, Optional<SerializableStaticAwsCredentialsProviderProvider.S3CredentialsDto>> clientCredentials = new ConcurrentHashMap();
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private SecretNamespacer secretNamespacer;
    @Inject
    private SecretService secretService;

    public SerializableStaticAwsCredentialsProviderProvider makeCredentialsProvider(String clientName) {
        String accessKey = this.getAccessKey(clientName);
        String secretKey = this.getSecretKey(clientName);
        return new SerializableStaticAwsCredentialsProviderProvider(new SerializableStaticAwsCredentialsProviderProvider.S3CredentialsDto(accessKey, secretKey));
    }

    private String getAccessKey(String clientName) {
        return this.readCredentialsSecret(clientName).map(dto -> dto.accessKey).orElseGet(() -> this.clientOptions.getRequiredString(clientName, PROP_accessKey));
    }

    private String getSecretKey(String clientName) {
        return this.readCredentialsSecret(clientName).map(dto -> dto.secretKey).orElseGet(() -> this.clientOptions.getRequiredString(clientName, PROP_secretKey));
    }

    private Optional<SerializableStaticAwsCredentialsProviderProvider.S3CredentialsDto> readCredentialsSecret(String clientName) {
        return this.clientCredentials.computeIfAbsent(clientName, $ -> {
            Optional optionalCredentialsLocation = this.clientOptions.optString(clientName, PROP_credentialsLocation);
            if (optionalCredentialsLocation.isEmpty()) {
                logger.warn("credentialsLocation not specified");
            }
            return optionalCredentialsLocation.map(credentialsLocation -> {
                String namespacedLocationForLogs = this.secretNamespacer.sharedNamespaced(credentialsLocation);
                try {
                    SecretOpConfig config = SecretOpConfig.builder((SecretOpReason)SecretOpReason.automatedOp((String)this.getClass().getName())).useSharedNamespace().build();
                    SerializableStaticAwsCredentialsProviderProvider.S3CredentialsDto result = (SerializableStaticAwsCredentialsProviderProvider.S3CredentialsDto)this.secretService.read(credentialsLocation, SerializableStaticAwsCredentialsProviderProvider.S3CredentialsDto.class, config);
                    logger.info("using secret at credentialsLocation={}", (Object)namespacedLocationForLogs);
                    return result;
                }
                catch (RuntimeException e) {
                    logger.error("Failed to locate credentialsLocation={} for clientName={}", new Object[]{namespacedLocationForLogs, clientName, e});
                    return null;
                }
            });
        });
    }
}

