/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.client;

import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.S3ClientType;
import io.datarouter.aws.s3.client.S3ClientManager;
import io.datarouter.aws.s3.config.DatarouterAwsS3Executors;
import io.datarouter.aws.s3.config.DatarouterAwsS3Paths;
import io.datarouter.aws.s3.node.S3Node;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import software.amazon.awssdk.regions.Region;

public class S3WebInspector
implements DatarouterClientWebInspector {
    @Inject
    private DatarouterNodes nodes;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private S3ClientManager s3ClientManager;
    @Inject
    private DatarouterAwsS3Paths paths;
    @Inject
    private DatarouterAwsS3Executors.BucketRegionExecutor bucketRegionExecutor;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        String contextPath = request.getContextPath();
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, S3ClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), this.buildNodeTable(contextPath, clientId), this.buildBucketTable(contextPath, clientId)}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - S3").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)content).buildMav();
    }

    private ContainerTag<?> buildNodeTable(String contextPath, ClientId clientId) {
        List nodeDtos = Scanner.of((Iterable)this.nodes.getTableNamesForClient(clientId.getName())).map(tableName -> this.nodes.getPhysicalNodeForClientAndTable(clientId.getName(), tableName)).map(node -> NodeTool.extractSinglePhysicalNode((Node)node)).map(S3Node.class::cast).map(s3Node -> new S3NodeDto(s3Node.getBucket(), s3Node.getRootPath().toString())).list();
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn("Browse", row -> {
            String href = new URIBuilder().setPath(String.valueOf(contextPath) + this.paths.datarouter.clients.awsS3.listObjects.toSlashedString()).addParameter("client", clientId.getName()).addParameter("bucket", row.bucket).addParameter("prefix", row.rootPath).toString();
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)"Browse").withHref(href)});
        }).withColumn("Bucket", row -> row.bucket).withColumn("Root Path", row -> row.rootPath).build((Collection)nodeDtos);
        return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)("Nodes - " + nodeDtos.size())), table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private ContainerTag<?> buildBucketTable(String contextPath, ClientId clientId) {
        DatarouterS3Client client = this.s3ClientManager.getClient(clientId);
        List buckets = client.scanBuckets().parallel(new ParallelScannerContext((ExecutorService)((Object)this.bucketRegionExecutor), this.bucketRegionExecutor.getMaximumPoolSize(), true)).map(bucket -> {
            Region region = client.getBucketRegion(bucket.name());
            return new S3BucketDto(clientId.getName(), bucket.name(), region, bucket.creationDate());
        }).sort(Comparator.comparing(bucket -> bucket.bucketName.toLowerCase())).list();
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn("Name", bucket -> {
            String href = new URIBuilder().setPath(String.valueOf(contextPath) + this.paths.datarouter.clients.awsS3.listObjects.toSlashedString()).addParameter("client", bucket.clientName).addParameter("bucket", bucket.bucketName).addParameter("delimiter", "/").toString();
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)bucket.bucketName).withHref(href)});
        }).withColumn("Region", bucket -> bucket.region).withColumn("Created", bucket -> bucket.creationDate).build((Collection)buckets);
        return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)("Buckets - " + buckets.size())), table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private static class S3BucketDto {
        final String clientName;
        final String bucketName;
        final Region region;
        final Instant creationDate;

        public S3BucketDto(String clientName, String bucketName, Region region, Instant creationDate) {
            this.clientName = clientName;
            this.bucketName = bucketName;
            this.region = region;
            this.creationDate = creationDate;
        }
    }

    private static class S3NodeDto {
        final String bucket;
        final String rootPath;

        S3NodeDto(String bucket, String rootPath) {
            this.bucket = bucket;
            this.rootPath = rootPath;
        }
    }
}

