/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.node;

import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.S3Headers;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.Require;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3DirectoryManager {
    private final DatarouterS3Client client;
    private final String bucket;
    private final Subpath rootPath;

    public S3DirectoryManager(DatarouterS3Client client, String bucket, Subpath rootPath) {
        this.client = client;
        this.bucket = bucket;
        this.rootPath = rootPath;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Subpath getRootPath() {
        return this.rootPath;
    }

    public String fullPath(String suffix) {
        return String.valueOf(this.rootPath.toString()) + suffix;
    }

    public String relativePath(String fullPath) {
        Require.isTrue((boolean)fullPath.startsWith(this.rootPath.toString()));
        return fullPath.substring(this.rootPath.toString().length());
    }

    public S3DirectoryManager createSubdirectory(String name) {
        return new S3DirectoryManager(this.client, this.bucket, this.rootPath.append(name));
    }

    public boolean exists(String suffix) {
        String fullPath = this.fullPath(suffix);
        return this.client.exists(this.bucket, fullPath);
    }

    public Optional<Long> length(String suffix) {
        String fullPath = this.fullPath(suffix);
        return this.client.length(this.bucket, fullPath);
    }

    public byte[] read(String suffix) {
        String fullPath = this.fullPath(suffix);
        return this.client.getObjectAsBytes(this.bucket, fullPath);
    }

    public byte[] read(String suffix, long offset, int length) {
        String fullPath = this.fullPath(suffix);
        return this.client.getPartialObject(this.bucket, fullPath, offset, length);
    }

    public String readUtf8(String suffix) {
        byte[] bytes = this.read(suffix);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public Long size(String suffix) {
        String fullPath = this.fullPath(suffix);
        return this.client.scanObjects(this.bucket, fullPath).findFirst().map(S3Object::size).orElse(null);
    }

    public Scanner<List<S3Object>> scanS3ObjectsPaged(Subpath subpath) {
        return this.client.scanObjectsPaged(this.bucket, this.rootPath.append(subpath).toString());
    }

    public Scanner<List<String>> scanKeysPaged(Subpath subpath) {
        return this.client.scanObjectsPaged(this.bucket, this.rootPath.append(subpath).toString()).map(page -> Scanner.of((Iterable)page).map(S3Object::key).map(this::relativePath).list());
    }

    public void write(String suffix, byte[] content) {
        String fullPath = this.fullPath(suffix);
        this.client.putObjectAsBytes(this.bucket, fullPath, S3Headers.ContentType.BINARY, "no-cache", ObjectCannedACL.PRIVATE, content);
    }

    public void write(String suffix, Scanner<byte[]> chunks) {
        String fullPath = this.fullPath(suffix);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream outputStream = this.client.put(this.bucket, fullPath, S3Headers.ContentType.BINARY);){
                for (byte[] chunk : chunks.iterable()) {
                    outputStream.write(chunk);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(String suffix, InputStream inputStream) {
        String fullPath = this.fullPath(suffix);
        this.client.put(this.bucket, fullPath, S3Headers.ContentType.BINARY, inputStream);
    }

    public void writeUtf8(String suffix, String content) {
        this.write(suffix, content.getBytes(StandardCharsets.UTF_8));
    }

    public void delete(String suffix) {
        String fullPath = this.fullPath(suffix);
        this.client.deleteObject(this.bucket, fullPath);
    }
}

