/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.node;

import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.node.S3DirectoryManager;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.util.Subpath;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class S3Node
extends BasePhysicalNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder>
implements BlobStorage.PhysicalBlobStorageNode {
    private final DatarouterS3Client datarouterS3Client;
    private final S3DirectoryManager s3DirectoryManager;

    public S3Node(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> params, ClientType<?, ?> clientType, DatarouterS3Client datarouterS3Client, S3DirectoryManager directoryManager) {
        super(params, clientType);
        this.datarouterS3Client = datarouterS3Client;
        this.s3DirectoryManager = directoryManager;
    }

    public DatarouterS3Client getDatarouterS3Client() {
        return this.datarouterS3Client;
    }

    public String getBucket() {
        return this.s3DirectoryManager.getBucket();
    }

    public Subpath getRootPath() {
        return this.s3DirectoryManager.getRootPath();
    }

    public Optional<Long> length(PathbeanKey key) {
        return this.s3DirectoryManager.length(key.getPathAndFile());
    }

    public byte[] read(PathbeanKey key) {
        return this.s3DirectoryManager.read(key.getPathAndFile());
    }

    public byte[] read(PathbeanKey key, long offset, int length) {
        return this.s3DirectoryManager.read(key.getPathAndFile(), offset, length);
    }

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys) {
        return Scanner.of(keys).toMap(Function.identity(), this::read);
    }

    public void write(PathbeanKey key, byte[] content) {
        this.s3DirectoryManager.write(key.getPathAndFile(), content);
    }

    public void write(PathbeanKey key, Scanner<byte[]> chunks) {
        this.s3DirectoryManager.write(key.getPathAndFile(), chunks);
    }

    public void write(PathbeanKey key, InputStream inputStream) {
        this.s3DirectoryManager.write(key.getPathAndFile(), inputStream);
    }

    public void delete(PathbeanKey key) {
        this.s3DirectoryManager.delete(key.getPathAndFile());
    }

    public void deleteAll(Subpath subpath) {
        this.scanKeys(subpath).forEach(this::delete);
    }

    public boolean exists(PathbeanKey key) {
        return this.s3DirectoryManager.exists(key.getPathAndFile());
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath) {
        return this.s3DirectoryManager.scanS3ObjectsPaged(subpath).map(page -> Scanner.of((Iterable)page).map(s3Object -> {
            PathbeanKey key = PathbeanKey.of((String)this.s3DirectoryManager.relativePath(s3Object.key()));
            Long size = s3Object.size();
            return new Pathbean(key, size);
        }).list());
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath) {
        return this.s3DirectoryManager.scanKeysPaged(subpath).map(page -> Scanner.of((Iterable)page).map(PathbeanKey::of).list());
    }
}

