/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.s3.web;

import io.datarouter.aws.s3.DatarouterS3Client;
import io.datarouter.aws.s3.client.S3ClientManager;
import io.datarouter.aws.s3.config.DatarouterAwsS3Paths;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.op.raw.read.DirectoryDto;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalBoolean;
import io.datarouter.web.handler.types.optional.OptionalInteger;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(S3BucketHandler.class);
    public static final String P_client = "client";
    public static final String P_bucket = "bucket";
    public static final String P_prefix = "prefix";
    private static final String P_after = "after";
    private static final String P_offset = "offset";
    private static final String P_limit = "limit";
    private static final String P_currentDirectory = "currentDirectory";
    public static final String P_delimiter = "delimiter";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private DatarouterClients clients;
    @Inject
    private S3ClientManager s3ClientManager;
    @Inject
    private DatarouterAwsS3Paths paths;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav index(@Param(value="client") String client, @Param(value="bucket") String bucket, @Param(value="prefix") OptionalString prefix, @Param(value="after") OptionalString after, @Param(value="offset") OptionalInteger offset, @Param(value="limit") OptionalInteger limit, @Param(value="currentDirectory") OptionalBoolean currentDirectory, @Param(value="delimiter") OptionalString delimiter) {
        HtmlForm form = new HtmlForm().withMethod("get");
        form.addTextField().withDisplay("Client").withName(P_client).withPlaceholder("theClientName").withValue(client);
        form.addTextField().withDisplay("Bucket").withName(P_bucket).withPlaceholder("the.bucket.name").withValue(bucket);
        form.addTextField().withDisplay("Prefix").withName(P_prefix).withValue((String)prefix.orElse((Object)""));
        form.addTextField().withDisplay("After").withName(P_after).withValue((String)after.orElse((Object)""));
        form.addTextField().withDisplay("Offset").withName(P_offset).withValue("" + offset.orElse((Object)0));
        form.addTextField().withDisplay("Limit").withName(P_limit).withValue("" + limit.orElse((Object)100));
        form.addTextField().withDisplay("Delimiter").withName(P_delimiter).withValue((String)delimiter.orElse((Object)""));
        form.addCheckboxField().withDisplay(P_currentDirectory).withName(P_currentDirectory).withChecked(((Boolean)currentDirectory.orElse((Object)false)).booleanValue());
        form.addButton().withDisplay("Submit").withValue("");
        ContainerTag htmlForm = (ContainerTag)Bootstrap4FormHtml.render((HtmlForm)form).withClass("card card-body bg-light");
        ClientId clientId = this.clients.getClientId(client);
        DatarouterS3Client s3Client = this.s3ClientManager.getClient(clientId);
        List objects = s3Client.scanSubdirectories(bucket, (String)prefix.orElse(null), (String)after.orElse(null), (String)delimiter.orElse(null), (Integer)limit.orElse((Object)100), (Boolean)currentDirectory.orElse((Object)false)).list();
        int sizePadding = S3BucketHandler.sizePadding(objects);
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn("Key", object -> {
            String name = object.name;
            if (object.isDirectory) {
                return TagCreator.td((DomContent[])new DomContent[]{this.makePrefixLink(client, bucket, name, "/")});
            }
            return TagCreator.td((String)name);
        }).withHtmlColumn("Directory", object -> {
            boolean isDirectory = object.isDirectory;
            if (isDirectory) {
                String href = new URIBuilder().setPath(String.valueOf(this.request.getContextPath()) + this.paths.datarouter.clients.awsS3.countObjects.toSlashedString()).addParameter(P_client, client).addParameter(P_bucket, bucket).addParameter(P_prefix, object.name).toString();
                return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)"true, view count").withHref(href)});
            }
            return TagCreator.td((String)String.valueOf(isDirectory));
        }).withHtmlColumn("Size", object -> {
            String commas = NumberFormatter.addCommas((Number)object.size);
            String padded = StringTool.pad((String)commas, (char)' ', (int)sizePadding);
            String escaped = padded.replaceAll(" ", "&nbsp;");
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.rawHtml((String)escaped)});
        }).withColumn("Last Modified", object -> object.lastModified).withColumn("Storage Class", object -> object.storageClass).build((Collection)objects);
        ContainerTag tableWrapper = (ContainerTag)table.withStyle("font-family:monospace; font-size:.9em;");
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{htmlForm, TagCreator.h4((String)bucket), tableWrapper}).withClass("container-fluid my-4");
        return this.pageFactory.startBuilder(this.request).withTitle("S3 Bucket").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)content).buildMav();
    }

    @BaseHandler.Handler
    public Mav countObjects(@Param(value="client") String client, @Param(value="bucket") String bucket, @Param(value="prefix") OptionalString prefix) {
        ClientId clientId = this.clients.getClientId(client);
        DatarouterS3Client s3Client = this.s3ClientManager.getClient(clientId);
        AtomicLong count = new AtomicLong();
        AtomicLong size = new AtomicLong();
        AtomicReference message = new AtomicReference();
        s3Client.scanObjects(bucket, (String)prefix.orElse((Object)"")).each($ -> {
            long l = count.incrementAndGet();
        }).each(obj -> {
            long l = size.addAndGet(obj.size());
        }).sample(10000L, true).map(obj -> String.format("client=%s, bucket=%s, prefix=%s, count=%s, size=%s, through=%s", client, bucket, prefix.orElse(null), NumberFormatter.addCommas((Number)count.get()), NumberFormatter.addCommas((Number)size.get()), obj.key())).each(message::set).forEach(arg_0 -> ((Logger)logger).warn(arg_0));
        return this.pageFactory.message(this.request, (String)message.get());
    }

    private ContainerTag<?> makePrefixLink(String client, String bucket, String prefix, String delimiter) {
        String href = new URIBuilder().setPath(String.valueOf(this.request.getContextPath()) + this.paths.datarouter.clients.awsS3.listObjects.toSlashedString()).addParameter(P_client, client).addParameter(P_bucket, bucket).addParameter(P_prefix, prefix).addParameter(P_delimiter, delimiter).toString();
        return (ContainerTag)TagCreator.a((String)prefix).withHref(href);
    }

    private static int sizePadding(List<DirectoryDto> objects) {
        return Scanner.of(objects).map(object -> object.size).map(NumberFormatter::addCommas).map(String::length).findMax(Comparator.naturalOrder()).orElse(0);
    }
}

