/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting;

import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.PersistentString;
import io.datarouter.util.enums.StringEnum;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.string.StringTool;
import java.util.Objects;

public enum ClusterSettingScope implements StringEnum<ClusterSettingScope>
{
    DEFAULT_SCOPE("defaultScope", 100000),
    CLUSTER("cluster", 10000),
    SERVER_TYPE("serverType", 1000),
    SERVER_NAME("serverName", 100),
    APPLICATION("application", 10);

    private final String persistentString;
    private final int specificity;

    private ClusterSettingScope(String persistentString, int specificity) {
        this.persistentString = persistentString;
        this.specificity = specificity;
    }

    public String getPersistentString() {
        return this.persistentString;
    }

    public static ClusterSettingScope fromPersistentStringStatic(String str) {
        return (ClusterSettingScope)DatarouterEnumTool.getEnumFromString((PersistentString[])ClusterSettingScope.values(), (String)str, null);
    }

    public ClusterSettingScope fromPersistentString(String str) {
        return ClusterSettingScope.fromPersistentStringStatic(str);
    }

    public static ClusterSettingScope fromParams(ServerType serverType, String serverName, String application) {
        return ClusterSettingScope.fromParams(serverType.getPersistentString(), serverName, application);
    }

    public static ClusterSettingScope fromParams(String serverTypePersistentString, String serverName, String application) {
        if (StringTool.notEmpty((String)application)) {
            return APPLICATION;
        }
        if (StringTool.notEmpty((String)serverName)) {
            return SERVER_NAME;
        }
        if (ObjectTool.notEquals((Object)ServerType.UNKNOWN.getPersistentString(), (Object)serverTypePersistentString) && ObjectTool.notEquals((Object)ServerType.ALL.getPersistentString(), (Object)serverTypePersistentString)) {
            return SERVER_TYPE;
        }
        if (Objects.equals(ServerType.ALL.getPersistentString(), serverTypePersistentString)) {
            return CLUSTER;
        }
        return DEFAULT_SCOPE;
    }

    public int getSpecificity() {
        return this.specificity;
    }
}

