/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.clustersetting;

import io.datarouter.util.enums.PersistentString;
import java.util.Arrays;
import java.util.stream.Stream;

public enum ClusterSettingValidity implements PersistentString
{
    VALID("valid", "table-default", "Valid override"),
    INVALID_SERVER_NAME("invalidServerName", "table-success", "Unknown serverName"),
    REDUNDANT("redundant", "table-warning", "Value duplicates the default value"),
    OLD("old", "table-info", "Setting hasn't changed in a while - consider moving it in the code"),
    EXPIRED("expired", "table-danger", "Setting not known to webapp - probably deleted from code"),
    UNKNOWN("unknown", "table-secondary", "Root of setting not recognized by this webapp");

    public final String persistentString;
    public final String color;
    public final String description;

    private ClusterSettingValidity(String persistentString, String color, String description) {
        this.persistentString = persistentString;
        this.color = color;
        this.description = description;
    }

    public static Stream<ClusterSettingValidity> stream() {
        return Arrays.stream(ClusterSettingValidity.values());
    }

    public String getPersistentString() {
        return this.persistentString;
    }

    public String getColor() {
        return this.color;
    }

    public String getDescription() {
        return this.description;
    }
}

